/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.agent.communication;

import cn.com.infosec.netsign.agent.NetSignAgentUtil;
import cn.com.infosec.netsign.agent.communication.APIToServer;
import cn.com.infosec.netsign.agent.communication.ConnectionPool;
import cn.com.infosec.netsign.agent.exception.NetSignAgentException;
import cn.com.infosec.netsign.agent.exception.ServerProcessException;
import cn.com.infosec.netsign.base.AbstractMessage;
import cn.com.infosec.netsign.communication.Communicator;
import cn.com.infosec.netsign.communication.multiple.MultiCommunicator;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Date;

public class APIToServerNonePoolImpl
extends APIToServer {
    private Communicator getConnection() throws NetSignAgentException {
        try {
            Socket socket = new Socket(APIToServerNonePoolImpl.getHost(), APIToServerNonePoolImpl.getPort());
            socket.setSoTimeout(APIToServerNonePoolImpl.getTimeout());
            socket.setTcpNoDelay(true);
            return new MultiCommunicator(socket);
        }
        catch (IOException ioEx) {
            if (ioEx instanceof UnknownHostException) {
                NetSignAgentUtil.debug(new Date() + " New connection failed, " + "the error code is " + -1000 + ", the error is " + ioEx.getMessage(), null);
                throw new NetSignAgentException(-1000, ioEx.getMessage());
            }
            NetSignAgentUtil.debug(new Date() + " New connection failed, " + "the error code is " + -1001 + ", the error is " + ioEx.getMessage(), null);
            throw new NetSignAgentException(-1001, ioEx.getMessage());
        }
    }

    private Communicator getConnection(String host, int port, int timeout) throws NetSignAgentException {
        try {
            Socket socket = new Socket(host, port);
            socket.setSoTimeout(timeout);
            socket.setTcpNoDelay(true);
            return new MultiCommunicator(socket);
        }
        catch (IOException ioEx) {
            if (ioEx instanceof UnknownHostException) {
                NetSignAgentUtil.debug(new Date() + " New connection failed, " + "the error code is " + -1000 + ", the error is " + ioEx.getMessage(), null);
                throw new NetSignAgentException(-1000, ioEx.getMessage());
            }
            NetSignAgentUtil.debug(new Date() + " New connection failed, " + "the error code is " + -1001 + ", the error is " + ioEx.getMessage(), null);
            throw new NetSignAgentException(-1001, ioEx.getMessage());
        }
    }

    private Communicator getConnection(String host, int port) throws NetSignAgentException {
        try {
            Socket socket = new Socket(host, port);
            socket.setSoTimeout(30000);
            socket.setTcpNoDelay(true);
            return new MultiCommunicator(socket);
        }
        catch (IOException ioEx) {
            if (ioEx instanceof UnknownHostException) {
                NetSignAgentUtil.debug(new Date() + " New connection failed, " + "the error code is " + -1000 + ", the error is " + ioEx.getMessage(), null);
                throw new NetSignAgentException(-1000, ioEx.getMessage());
            }
            NetSignAgentUtil.debug(new Date() + " New connection failed, " + "the error code is " + -1001 + ", the error is " + ioEx.getMessage(), null);
            throw new NetSignAgentException(-1001, ioEx.getMessage());
        }
    }

    public AbstractMessage sendAndRecv(AbstractMessage req, ConnectionPool.PoolCommunicator comm) throws NetSignAgentException, ServerProcessException {
        throw new NetSignAgentException(new NoSuchMethodException("Only available for APIToServerPooledImpl").getMessage());
    }

    public AbstractMessage sendAndRecv(AbstractMessage req, String host, int port, int timeout) throws NetSignAgentException, ServerProcessException {
        Communicator comm = null;
        AbstractMessage res = null;
        try {
            comm = this.getConnection(host, port, timeout);
            NetSignAgentUtil.debug(new Date() + " Before Send message, " + "the message content is ", req);
            try {
                comm.send(req);
            }
            catch (IOException ioEx) {
                NetSignAgentUtil.debug(new Date() + " Send message failed, " + "the error code is " + -1003 + ", the error is " + ioEx.getMessage(), null);
                throw new NetSignAgentException(-1003, ioEx.getMessage());
            }
            try {
                res = comm.recv();
            }
            catch (IOException ioEx) {
                NetSignAgentUtil.debug(new Date() + " Recieve message failed, " + "the error code is " + -1004 + ", the error is " + ioEx.getMessage(), null);
                throw new NetSignAgentException(-1004, ioEx.getMessage());
            }
            catch (ClassNotFoundException clsEx) {
                NetSignAgentUtil.debug(new Date() + " Recieve message failed, " + "the error code is " + -1005 + ", the error is " + clsEx.getMessage(), null);
                throw new NetSignAgentException(-1005, clsEx.getMessage());
            }
        }
        catch (Throwable throwable) {
            this.close(comm);
            throw throwable;
        }
        this.close(comm);
        NetSignAgentUtil.debug(new Date() + " After recieve message, " + "the message content is ", res);
        this.checkResult(res);
        return res;
    }

    public AbstractMessage sendAndRecv(AbstractMessage req) throws NetSignAgentException, ServerProcessException {
        Communicator comm = null;
        AbstractMessage res = null;
        try {
            comm = this.getConnection();
            NetSignAgentUtil.debug(new Date() + " Before Send message, " + "the message content is ", req);
            try {
                comm.send(req);
            }
            catch (IOException ioEx) {
                NetSignAgentUtil.debug(new Date() + " Send message failed, " + "the error code is " + -1003 + ", the error is " + ioEx.getMessage(), null);
                throw new NetSignAgentException(-1003, ioEx.getMessage());
            }
            try {
                res = comm.recv();
            }
            catch (IOException ioEx) {
                NetSignAgentUtil.debug(new Date() + " Recieve message failed, " + "the error code is " + -1004 + ", the error is " + ioEx.getMessage(), null);
                throw new NetSignAgentException(-1004, ioEx.getMessage());
            }
            catch (ClassNotFoundException clsEx) {
                NetSignAgentUtil.debug(new Date() + " Recieve message failed, " + "the error code is " + -1005 + ", the error is " + clsEx.getMessage(), null);
                throw new NetSignAgentException(-1005, clsEx.getMessage());
            }
        }
        finally {
            this.close(comm);
        }
        NetSignAgentUtil.debug(new Date() + " After recieve message, " + "the message content is ", res);
        this.checkResult(res);
        return res;
    }
}

