/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.agent;

import cn.com.infosec.asn1.DERInputStream;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.DEROctetString;
import cn.com.infosec.netsign.agent.NetSignAgentRes;
import cn.com.infosec.netsign.agent.NetSignAgentUtil;
import cn.com.infosec.netsign.agent.exception.NetSignAgentException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class NetSignResult
implements Serializable {
    public static final String DIGEST_ALG = "DIGEST_ALG";
    public static final String ENC_ALG = "Enc_Alg";
    public static final String SIGN_TEXT = "Base64_Signed_Text";
    public static final String Sign_ID = "Signature_Id";
    public static final String PDF_ENCRPT_TEXT = "Pdf_Encrypt_Text";
    public static final String PLAIN_TEXT = "Byte_Array_Plain_Text";
    public static final String ENC_TEXT = "Base64_Enveloped_Text";
    public static final String TSA_TEXT = "Base64_TSA_Text";
    public static final String SIGN_CERT = "X509Certificate_Sign_Cert";
    public static final String TSA_GEN_TIME = "TSA_Gen_Time";
    public static final String SIGN_SUBJECT = "Sign_Subject";
    public static final String SIGN_SER_NUMBER = "Sign_Ser_Number";
    public static final String SIGN_ISSUER_SUBJECT = "Sign_Issuer_Subject";
    public static final String SIGN_START_TIME = "Sign_Start_Time";
    public static final String SIGN_END_TIME = "Sign_End_Time";
    public static final String ENC_SUBJECT = "Enc_Subject";
    public static final String ENC_SER_NUMBER = "Enc_Ser_Number";
    public static final String ENC_ISSUER_SUBJECT = "Enc_Issuer_Subject";
    public static final String ENC_START_TIME = "Enc_Start_Time";
    public static final String ENC_END_TIME = "Enc_End_Time";
    public static final String RESULT_NUMBER = "Result_Num";
    public static final String BARCODE_SYMBOLOGY = "BarCode_Symbology";
    private int result = 1;
    private Map results = null;

    public NetSignResult() {
    }

    void setResult(int result) {
        this.result = result;
    }

    public int getResult() {
        return this.result;
    }

    public static Map getFileItems(byte[] byteResults) throws NetSignAgentException {
        try {
            HashMap<String, byte[]> items = new HashMap<String, byte[]>();
            int pos = Integer.parseInt(new String(byteResults, 0, 8), 10) + 16;
            int fLen = 0;
            int fNameLen = 0;
            String fName = null;
            byte[] fContent = null;
            while (pos < byteResults.length) {
                fLen = Integer.parseInt(new String(byteResults, pos, 8), 10);
                fNameLen = Integer.parseInt(new String(byteResults, pos += 8, 8), 10);
                fName = new String(byteResults, pos += 8, fNameLen);
                fContent = new byte[fLen - fNameLen - 8];
                System.arraycopy(byteResults, pos += fNameLen, fContent, 0, fLen - fNameLen - 8);
                pos += fLen - fNameLen - 8;
                items.put(fName, fContent);
            }
            return items;
        }
        catch (Throwable t) {
            throw new NetSignAgentException(-1021, t.getMessage());
        }
    }

    public static String[] getFormItems(byte[] byteResults) throws NetSignAgentException {
        ArrayList<String> items;
        block5: {
            try {
                items = new ArrayList<String>();
                int pos = 0;
                int formsLen = Integer.parseInt(new String(byteResults, pos, 8), 10);
                if (formsLen != 0 && (pos += 8) <= formsLen + 7) {
                    while (pos < formsLen) {
                        int iLen = Integer.parseInt(new String(byteResults, pos, 8), 10);
                        byte[] item = new byte[iLen];
                        System.arraycopy(byteResults, pos += 8, item, 0, iLen);
                        items.add(new String(item));
                        pos += iLen;
                    }
                }
                if (items.size() != 0) break block5;
                return null;
            }
            catch (Throwable t) {
                throw new NetSignAgentException(-1020, t.getMessage());
            }
        }
        return items.toArray(new String[items.size()]);
    }

    public static byte[][] getFormItemsBytes(byte[] byteResults) throws NetSignAgentException {
        ArrayList<byte[]> items;
        block6: {
            items = new ArrayList<byte[]>();
            int pos = 0;
            int formsLen = Integer.parseInt(new String(byteResults, pos, 8), 10);
            if (formsLen != 0 && (pos += 8) <= formsLen + 7) {
                while (pos < formsLen) {
                    int iLen = Integer.parseInt(new String(byteResults, pos, 8), 10);
                    byte[] item = new byte[iLen];
                    System.arraycopy(byteResults, pos += 8, item, 0, iLen);
                    items.add(item);
                    pos += iLen;
                }
            }
            if (items.size() != 0) break block6;
            return null;
        }
        try {
            byte[][] bytes = new byte[items.size()][];
            int i = 0;
            int size = items.size();
            while (i < size) {
                bytes[i] = (byte[])items.get(i);
                ++i;
            }
            return bytes;
        }
        catch (Throwable t) {
            throw new NetSignAgentException(-1020, t.getMessage());
        }
    }

    public static Map getFileItemsBytes(byte[] byteResults) throws NetSignAgentException {
        try {
            HashMap<byte[], byte[]> items = new HashMap<byte[], byte[]>();
            int pos = Integer.parseInt(new String(byteResults, 0, 8), 10) + 16;
            int fLen = 0;
            int fNameLen = 0;
            byte[] fName = null;
            byte[] fContent = null;
            while (pos < byteResults.length) {
                fLen = Integer.parseInt(new String(byteResults, pos, 8), 10);
                fNameLen = Integer.parseInt(new String(byteResults, pos += 8, 8), 10);
                fName = new byte[fNameLen];
                System.arraycopy(byteResults, pos += 8, fName, 0, fNameLen);
                fContent = new byte[fLen - fNameLen - 8];
                System.arraycopy(byteResults, pos += fNameLen, fContent, 0, fLen - fNameLen - 8);
                pos += fLen - fNameLen - 8;
                items.put(fName, fContent);
            }
            return items;
        }
        catch (Throwable t) {
            throw new NetSignAgentException(-1021, t.getMessage());
        }
    }

    public NetSignResult(Map results) {
        this.results = results;
    }

    public Object getResult(String key) {
        Object o = this.results.get(key);
        if ((key.equals(ENC_SER_NUMBER) || key.equals(SIGN_SER_NUMBER)) && o != null) {
            String sn = (String)o;
            switch (NetSignAgentRes.getSNMode()) {
                case 1: {
                    sn = sn.length() % 2 == 0 ? sn : "0" + sn;
                    return sn;
                }
                case 2: {
                    BigInteger snbi = new BigInteger(sn, 16);
                    return snbi.toString(10);
                }
            }
            return sn;
        }
        return o;
    }

    public byte[] getByteArrayResult(String key) throws NetSignAgentException {
        Object o = this.results.get(key);
        if (o == null) {
            return null;
        }
        if (o instanceof byte[]) {
            return (byte[])o;
        }
        throw new NetSignAgentException(-1019, "The result is not a byte array");
    }

    public String getStringResult(String key) throws NetSignAgentException {
        Object o = this.results.get(key);
        if (o == null) {
            return null;
        }
        if (o instanceof byte[]) {
            return NetSignAgentUtil.encode((byte[])o);
        }
        if (o instanceof String) {
            if (key.equals(ENC_SER_NUMBER) || key.equals(SIGN_SER_NUMBER)) {
                String sn = (String)o;
                switch (NetSignAgentRes.getSNMode()) {
                    case 1: {
                        sn = sn.length() % 2 == 0 ? sn : "0" + sn;
                        return sn;
                    }
                    case 2: {
                        BigInteger snbi = new BigInteger(sn, 16);
                        return snbi.toString(10);
                    }
                }
                return sn;
            }
            if (key.equals(SIGN_SUBJECT) || key.equals(SIGN_ISSUER_SUBJECT) || key.equals(ENC_SUBJECT) || key.equals(ENC_ISSUER_SUBJECT)) {
                return NetSignAgentUtil.getDN((String)o);
            }
            return (String)o;
        }
        throw new NetSignAgentException(-1018, "The result is not a String");
    }

    public X509Certificate getSignCert() {
        return (X509Certificate)this.results.get(SIGN_CERT);
    }

    public String getCertExtensionValue(String OIDValue) throws NetSignAgentException {
        X509Certificate signcert = this.getSignCert();
        if (signcert == null) {
            throw new NetSignAgentException(-1017, "The SignCert is NULl");
        }
        return NetSignResult.getExtern(signcert.getExtensionValue(OIDValue));
    }

    private static String getExtern(byte[] a) throws NetSignAgentException {
        String externvalue = null;
        try {
            String tmp1;
            ByteArrayInputStream bint = new ByteArrayInputStream(a);
            DERInputStream dint = new DERInputStream((InputStream)bint);
            DEROctetString doct = (DEROctetString)dint.readObject();
            byte[] tmp = doct.getOctets();
            bint = new ByteArrayInputStream(tmp);
            dint = new DERInputStream((InputStream)bint);
            DERObject dobj = dint.readObject();
            Class<?> dc = dobj.getClass();
            Class<?> c1 = Class.forName(dc.getName());
            Method m = c1.getMethod("getString", null);
            externvalue = tmp1 = (String)m.invoke((Object)dobj, null);
        }
        catch (Exception ex) {
            throw new NetSignAgentException(-1017, ex.getMessage());
        }
        return externvalue;
    }

    void setResult(String key, Object result) {
        this.results.put(key, result);
    }
}

