/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.agent;

import cn.com.infosec.jce.PKCS7SignedDataFX;
import cn.com.infosec.jce.provider.InfosecProvider;
import cn.com.infosec.netsign.agent.ExtendInfoUtil;
import cn.com.infosec.netsign.agent.NetSignAgentRes;
import cn.com.infosec.netsign.agent.NetSignAgentUtil;
import cn.com.infosec.netsign.agent.NetSignResult;
import cn.com.infosec.netsign.agent.exception.NetSignAgentException;
import cn.com.infosec.netsign.agent.exception.ServerProcessException;
import cn.com.infosec.netsign.agent.newcommunitor.CommunitorManager;
import cn.com.infosec.netsign.base.AbstractMessage;
import cn.com.infosec.netsign.base.BarCodeParameters;
import cn.com.infosec.netsign.base.NSMessage;
import cn.com.infosec.netsign.base.NSMessageOpt;
import cn.com.infosec.netsign.base.PDFParameters;
import cn.com.infosec.netsign.base.util.TimeStampToken;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import cn.com.infosec.oscca.encryption.SM3Digest;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class NetSignAgent {
    private static final String version = "NetSignServer V5.5.40.12 Build201412101800";
    private static PrintWriter _writer = null;
    static CommunitorManager cm;
    public static final String PKCS7_STANDARD_PBCSHLC = "PBCSHLC";
    public static final String ILJ_KEY2G_STANDARD_KLB = "VerifyQLBKeyBusinessProcessor";

    static {
        Security.insertProviderAt((Provider)new InfosecProvider(), 100);
    }

    public static NetSignResult addImage2PDF(PDFParameters para) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("AddImage2PDFProcessor");
        byte[] plainBytes = NetSignAgentUtil.checkAndZip(para.getPdf(), req);
        plainBytes = NetSignAgentUtil.checkAndEncrypt(plainBytes, req);
        req.setPlainText(plainBytes);
        req.setPdfpasswd(para.getOwnerPassword());
        req.setPdfImages(para.getImages());
        NSMessageOpt res = NetSignAgent.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.pdfSignatureResult((NSMessage)res);
        NetSignAgent.freeObjects((AbstractMessage)req, (AbstractMessage)res);
        return result;
    }

    public static NetSignResult attachedAfterwardsVerify(String signedText, boolean needCert) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("AttachedAfterwardsVerifyProcessor");
        byte[] signedBytes = NetSignAgentUtil.decode(signedText);
        signedBytes = NetSignAgentUtil.checkOrZip(signedBytes, req);
        signedBytes = NetSignAgentUtil.checkAndEncrypt(signedBytes, req);
        req.setCryptoText(signedBytes);
        req.setTransCert(needCert);
        NSMessageOpt res = NetSignAgent.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.attachedVerifyResult(res);
        NetSignAgent.freeObjects((AbstractMessage)req, (AbstractMessage)res);
        return result;
    }

    public static NetSignResult attachedSignature(byte[] plainText, String subject, String digestAlg, boolean useTSA) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("AttachedSignProcessor");
        byte[] plainBytes = plainText;
        plainBytes = NetSignAgentUtil.checkAndZip(plainBytes, req);
        plainBytes = NetSignAgentUtil.checkAndEncrypt(plainBytes, req);
        req.setPlainText(plainBytes);
        req.setUsedTSA(useTSA);
        req.setSignCertDN(subject);
        req.setDigestAlg(digestAlg);
        NSMessageOpt res = NetSignAgent.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.signatureResult((NSMessage)res);
        NetSignAgent.freeObjects((AbstractMessage)req, (AbstractMessage)res);
        return result;
    }

    public static NetSignResult attachedVerify(byte[] signedText, String tsaText, boolean needCert) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("AttachedVerifyProcessor");
        byte[] signedBytes = signedText;
        signedBytes = NetSignAgentUtil.checkOrZip(signedBytes, req);
        signedBytes = NetSignAgentUtil.checkAndEncrypt(signedBytes, req);
        req.setCryptoText(signedBytes);
        NetSignAgentUtil.checkAndSetTSA(tsaText, req);
        req.setTransCert(needCert);
        NSMessageOpt res = NetSignAgent.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.attachedVerifyResult(res);
        NetSignAgent.freeObjects((AbstractMessage)req, (AbstractMessage)res);
        return result;
    }

    public static NetSignResult attachedVerify(byte[] signedText, String digestAlg, String tsaText, boolean needCert) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("AttachedVerifyProcessor");
        byte[] signedBytes = signedText;
        signedBytes = NetSignAgentUtil.checkOrZip(signedBytes, req);
        signedBytes = NetSignAgentUtil.checkAndEncrypt(signedBytes, req);
        req.setCryptoText(signedBytes);
        req.setDigestAlg(digestAlg);
        NetSignAgentUtil.checkAndSetTSA(tsaText, req);
        req.setTransCert(needCert);
        NSMessageOpt res = NetSignAgent.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.attachedVerifyResult(res);
        NetSignAgent.freeObjects((AbstractMessage)req, (AbstractMessage)res);
        return result;
    }

    public static NetSignResult attachedVerify(String signedText, String tsaText, boolean needCert) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("AttachedVerifyProcessor");
        byte[] signedBytes = NetSignAgentUtil.decode(signedText);
        signedBytes = NetSignAgentUtil.checkOrZip(signedBytes, req);
        signedBytes = NetSignAgentUtil.checkAndEncrypt(signedBytes, req);
        req.setCryptoText(signedBytes);
        NetSignAgentUtil.checkAndSetTSA(tsaText, req);
        req.setTransCert(needCert);
        NSMessageOpt res = NetSignAgent.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.attachedVerifyResult(res);
        NetSignAgent.freeObjects((AbstractMessage)req, (AbstractMessage)res);
        return result;
    }

    public static NetSignResult attachedVerify(String signedText, String digestAlg, String tsaText, boolean needCert) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("AttachedVerifyProcessor");
        byte[] signedBytes = NetSignAgentUtil.decode(signedText);
        signedBytes = NetSignAgentUtil.checkOrZip(signedBytes, req);
        signedBytes = NetSignAgentUtil.checkAndEncrypt(signedBytes, req);
        req.setCryptoText(signedBytes);
        req.setDigestAlg(digestAlg);
        NetSignAgentUtil.checkAndSetTSA(tsaText, req);
        req.setTransCert(needCert);
        NSMessageOpt res = NetSignAgent.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.attachedVerifyResult(res);
        NetSignAgent.freeObjects((AbstractMessage)req, (AbstractMessage)res);
        return result;
    }

    public static NetSignResult attachedVerify4UKey2G(byte[] signedText, String tsaText, boolean needCert, String standard) throws NetSignAgentException, ServerProcessException {
        PKCS7SignedDataFX p7 = null;
        try {
            p7 = new PKCS7SignedDataFX(signedText, "INFOSEC");
        }
        catch (Exception e) {
            throw new ServerProcessException(-100004, "Unpackage PKCS7SignedData failed");
        }
        byte[] plainText = p7.getContentData();
        X509Certificate cert = p7.getSigningCertificate();
        byte[] signed = NetSignAgentUtil.getSignatureInPKCS7(signedText, cert);
        String digestAlg = p7.getDigestAlgorithm();
        int i = digestAlg.indexOf("with");
        if (i > 0) {
            digestAlg = digestAlg.substring(0, i);
        }
        NetSignResult result = NetSignAgent.RAWVerify4UKey2G(plainText, signed, cert, digestAlg, standard);
        NetSignAgentUtil.setVerifyResult(plainText, cert, needCert, result);
        return result;
    }

    public static NetSignResult attachedVerify4UKey2G(String signedText, String tsaText, boolean needCert, String standard) throws NetSignAgentException, ServerProcessException {
        return NetSignAgent.attachedVerify4UKey2G(NetSignAgentUtil.decode(signedText), tsaText, needCert, standard);
    }

    public static byte[] base64Decode(String b64) {
        if (b64 == null || b64.equals("")) {
            return null;
        }
        try {
            return NetSignAgentUtil.decode(b64);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String base64Encode(byte[] bs) {
        if (bs == null || bs.length == 0) {
            return null;
        }
        return NetSignAgentUtil.encode(bs);
    }

    static void checkResult(AbstractMessage res) throws ServerProcessException {
        if (res.getResult() < 0) {
            if (NetSignAgent.getDebugWriter() != null) {
                NetSignAgent.getDebugWriter().println(new Date() + " Server process failed, " + "the error code is " + res.getResult() + ", the error is " + res.getErrMsg());
            }
            throw new ServerProcessException(res.getResult(), res.getErrMsg());
        }
    }

    public static void clearDebugWriter() {
        if (_writer != null) {
            _writer.close();
        }
        _writer = null;
    }

    public static NetSignResult CMSAttachedSignature(byte[] plainText, String subject, String digestAlg, boolean useTSA) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("CMSAttachedSignProcessor");
        byte[] plainBytes = plainText;
        plainBytes = NetSignAgentUtil.checkAndZip(plainBytes, req);
        plainBytes = NetSignAgentUtil.checkAndEncrypt(plainBytes, req);
        req.setPlainText(plainBytes);
        req.setUsedTSA(useTSA);
        req.setSignCertDN(subject);
        req.setDigestAlg(digestAlg);
        NSMessageOpt res = NetSignAgent.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.signatureResult((NSMessage)res);
        NetSignAgent.freeObjects((AbstractMessage)req, (AbstractMessage)res);
        return result;
    }

    public static NetSignResult CMSDetachedSignature(byte[] plainText, String subject, String digestAlg, boolean useTSA) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("CMSDetachedSignProcessor");
        byte[] plainBytes = plainText;
        plainBytes = NetSignAgentUtil.checkAndZip(plainBytes, req);
        plainBytes = NetSignAgentUtil.checkAndEncrypt(plainBytes, req);
        req.setPlainText(plainBytes);
        req.setUsedTSA(useTSA);
        req.setSignCertDN(subject);
        req.setDigestAlg(digestAlg);
        NSMessageOpt res = NetSignAgent.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.signatureResult((NSMessage)res);
        NetSignAgent.freeObjects((AbstractMessage)req, (AbstractMessage)res);
        return result;
    }

    public static NetSignResult decryptEnvelope(String encText, String subject) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("DecryptoEnvelopedMSGProcessor");
        byte[] encBytes = NetSignAgentUtil.decode(encText);
        encBytes = NetSignAgentUtil.checkAndZip(encBytes, req);
        req.setCryptoText(encBytes);
        req.setEncCertDN(subject);
        NSMessageOpt res = NetSignAgent.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.decryptEnvelopeResult(res);
        NetSignAgent.freeObjects((AbstractMessage)req, (AbstractMessage)res);
        return result;
    }

    public static NetSignResult decryptMSEnvelope(String encText, String subject) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("DecryptoMSEnvelopedMSGProcessor");
        byte[] encBytes = NetSignAgentUtil.decode(encText);
        encBytes = NetSignAgentUtil.checkAndZip(encBytes, req);
        req.setCryptoText(encBytes);
        req.setEncCertDN(subject);
        NSMessageOpt res = NetSignAgent.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.decryptEnvelopeResult(res);
        NetSignAgent.freeObjects((AbstractMessage)req, (AbstractMessage)res);
        return result;
    }

    public static NetSignResult decryptMSEnvelope(String encText, String subject, String digestAlg) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("DecryptoMSEnvelopedMSGProcessor");
        byte[] encBytes = NetSignAgentUtil.decode(encText);
        encBytes = NetSignAgentUtil.checkAndZip(encBytes, req);
        req.setCryptoText(encBytes);
        req.setEncCertDN(subject);
        req.setDigestAlg(digestAlg);
        NSMessageOpt res = NetSignAgent.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.decryptEnvelopeResult(res);
        NetSignAgent.freeObjects((AbstractMessage)req, (AbstractMessage)res);
        return result;
    }

    public static NetSignResult detachedAfterwardsVerify(byte[] plainText, String signedText, boolean needCert) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("DetachedAfterwardsVerifyProcessor");
        byte[] signedBytes = NetSignAgentUtil.decode(signedText);
        byte[] plainBytes = plainText;
        plainBytes = NetSignAgentUtil.checkAndZip(plainBytes, req);
        plainBytes = NetSignAgentUtil.checkAndEncrypt(plainBytes, req);
        req.setCryptoText(signedBytes);
        req.setPlainText(plainBytes);
        req.setTransCert(needCert);
        NSMessageOpt res = NetSignAgent.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.detachedVerifyResult(res);
        NetSignAgent.freeObjects((AbstractMessage)req, (AbstractMessage)res);
        return result;
    }

    public static NetSignResult detachedSignature(byte[] plainText, String subject, String digestAlg, boolean useTSA) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("DetachedSignProcessor");
        byte[] plainBytes = plainText;
        plainBytes = NetSignAgentUtil.checkAndZip(plainBytes, req);
        plainBytes = NetSignAgentUtil.checkAndEncrypt(plainBytes, req);
        req.setPlainText(plainBytes);
        req.setUsedTSA(useTSA);
        req.setSignCertDN(subject);
        req.setDigestAlg(digestAlg);
        NSMessageOpt res = NetSignAgent.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.signatureResult((NSMessage)res);
        NetSignAgent.freeObjects((AbstractMessage)req, (AbstractMessage)res);
        return result;
    }

    public static NetSignResult detachedVerify(byte[] plainText, byte[] signedText, String tsaText, boolean needCert) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("DetachedVerifyProcessor");
        byte[] signedBytes = signedText;
        byte[] plainBytes = plainText;
        plainBytes = NetSignAgentUtil.checkAndZip(plainBytes, req);
        plainBytes = NetSignAgentUtil.checkAndEncrypt(plainBytes, req);
        req.setCryptoText(signedBytes);
        req.setPlainText(plainBytes);
        NetSignAgentUtil.checkAndSetTSA(tsaText, req);
        req.setTransCert(needCert);
        NSMessageOpt res = NetSignAgent.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.detachedVerifyResult(res);
        NetSignAgent.freeObjects((AbstractMessage)req, (AbstractMessage)res);
        return result;
    }

    public static NetSignResult detachedVerify(byte[] plainText, byte[] signedText, String digestAlg, String tsaText, boolean needCert) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("DetachedVerifyProcessor");
        byte[] signedBytes = signedText;
        byte[] plainBytes = plainText;
        plainBytes = NetSignAgentUtil.checkAndZip(plainBytes, req);
        plainBytes = NetSignAgentUtil.checkAndEncrypt(plainBytes, req);
        req.setCryptoText(signedBytes);
        req.setPlainText(plainBytes);
        NetSignAgentUtil.checkAndSetTSA(tsaText, req);
        req.setTransCert(needCert);
        req.setDigestAlg(digestAlg);
        NSMessageOpt res = NetSignAgent.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.detachedVerifyResult(res);
        NetSignAgent.freeObjects((AbstractMessage)req, (AbstractMessage)res);
        return result;
    }

    public static NetSignResult detachedVerify(byte[] plainText, String signedText, String tsaText, boolean needCert) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("DetachedVerifyProcessor");
        byte[] signedBytes = NetSignAgentUtil.decode(signedText);
        byte[] plainBytes = plainText;
        plainBytes = NetSignAgentUtil.checkAndZip(plainBytes, req);
        plainBytes = NetSignAgentUtil.checkAndEncrypt(plainBytes, req);
        req.setCryptoText(signedBytes);
        req.setPlainText(plainBytes);
        NetSignAgentUtil.checkAndSetTSA(tsaText, req);
        req.setTransCert(needCert);
        NSMessageOpt res = NetSignAgent.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.detachedVerifyResult(res);
        NetSignAgent.freeObjects((AbstractMessage)req, (AbstractMessage)res);
        return result;
    }

    public static NetSignResult detachedVerify(byte[] plainText, String signedText, String digestAlg, String tsaText, boolean needCert) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("DetachedVerifyProcessor");
        byte[] signedBytes = NetSignAgentUtil.decode(signedText);
        byte[] plainBytes = plainText;
        plainBytes = NetSignAgentUtil.checkAndZip(plainBytes, req);
        plainBytes = NetSignAgentUtil.checkAndEncrypt(plainBytes, req);
        req.setCryptoText(signedBytes);
        req.setPlainText(plainBytes);
        NetSignAgentUtil.checkAndSetTSA(tsaText, req);
        req.setTransCert(needCert);
        req.setDigestAlg(digestAlg);
        NSMessageOpt res = NetSignAgent.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.detachedVerifyResult(res);
        NetSignAgent.freeObjects((AbstractMessage)req, (AbstractMessage)res);
        return result;
    }

    public static NetSignResult verifyTSASignature(byte[] plaintext, byte[] token) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("VerifyTSASignatureProcessor");
        TimeStampToken stampToken = null;
        try {
            stampToken = new TimeStampToken(token);
        }
        catch (Exception e) {
            throw new NetSignAgentException("Parse stamptoken error.");
        }
        String alg = stampToken.getMessageHashAlg();
        byte[] digestText = null;
        if (alg.equalsIgnoreCase("sm3")) {
            digestText = new byte[32];
            SM3Digest sm3 = new SM3Digest();
            sm3.update(plaintext);
            sm3.digest(digestText);
        } else {
            digestText = NetSignAgentUtil.digest(plaintext, alg);
        }
        digestText = NetSignAgentUtil.checkAndZip(digestText, req);
        digestText = NetSignAgentUtil.checkAndEncrypt(digestText, req);
        req.setCryptoText(token);
        req.setTSAText(digestText);
        NSMessageOpt res = NetSignAgent.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.TSASigVerifyResult(res);
        return result;
    }

    public static NetSignResult detachedVerify4UKey2G(byte[] plainText, byte[] signedText, String tsaText, boolean needCert, String standard) throws NetSignAgentException, ServerProcessException {
        PKCS7SignedDataFX p7 = null;
        try {
            p7 = new PKCS7SignedDataFX(signedText, "INFOSEC");
        }
        catch (Exception e) {
            throw new ServerProcessException(-100004, "Unpackage PKCS7SignedData failed");
        }
        X509Certificate cert = p7.getSigningCertificate();
        byte[] signed = NetSignAgentUtil.getSignatureInPKCS7(signedText, cert);
        String digestAlg = p7.getDigestAlgorithm();
        int i = digestAlg.indexOf("with");
        if (i > 0) {
            digestAlg = digestAlg.substring(0, i);
        }
        NetSignResult result = NetSignAgent.RAWVerify4UKey2G(plainText, signed, cert, digestAlg, standard);
        NetSignAgentUtil.setVerifyResult(null, cert, needCert, result);
        return result;
    }

    public static NetSignResult detachedVerify4UKey2G(byte[] plainText, String signedText, String tsaText, boolean needCert, String standard) throws NetSignAgentException, ServerProcessException {
        return NetSignAgent.detachedVerify4UKey2G(plainText, NetSignAgent.base64Decode(signedText), tsaText, needCert, standard);
    }

    public static void digestVerify(byte[] digest, byte[] signedText, X509Certificate cert) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("DigestSignVerifyProcessor");
        req.setHashValue(digest);
        req.setCert(cert);
        req.setCryptoText(signedText);
        NSMessageOpt res = NetSignAgent.sendMsgAndCheck(req);
        NetSignAgent.freeObjects((AbstractMessage)req, (AbstractMessage)res);
    }

    private static void freeObjects(AbstractMessage req, AbstractMessage resp) {
        req = null;
        resp = null;
    }

    public static NetSignResult generateBarCode128(BarCodeParameters para, String msg) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("GenerateBarCode128Processor");
        byte[] plainBytes = msg.getBytes();
        req.setPlainText(plainBytes);
        req.setBarCodeParameters(para);
        NSMessageOpt res = NetSignAgent.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.barcodeResult(res);
        NetSignAgent.freeObjects((AbstractMessage)req, (AbstractMessage)res);
        return result;
    }

    public static NetSignResult generateBarCode39(BarCodeParameters para, String msg, boolean addCheckSUM, float wideFactor, boolean displayStartStop) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("GenerateBarCode39Processor");
        byte[] plainBytes = msg.getBytes();
        req.setPlainText(plainBytes);
        req.setBarCodeParameters(para);
        req.setBcAddCheckSUM(addCheckSUM);
        req.setBcWideFactor(wideFactor);
        req.setBcDisplayHumanReadableStartStop(displayStartStop);
        NSMessageOpt res = NetSignAgent.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.barcodeResult(res);
        NetSignAgent.freeObjects((AbstractMessage)req, (AbstractMessage)res);
        return result;
    }

    public static NetSignResult generateBarCode417(byte[] msg, boolean isBinary, int errorCorrectLevel, float aspectRatio, float yheight, int returnFormat) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("GenerateBarCodePDF417Processor");
        req.setPlainText(msg);
        req.setBcEncodingMode(isBinary ? 0 : 1);
        req.setBcErrorCorrectingLevel(errorCorrectLevel);
        req.setBcAspectRatio(aspectRatio);
        req.setBcYHeight(yheight);
        req.setBcReturnFormat(returnFormat);
        NSMessageOpt res = NetSignAgent.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.barcodeResult(res);
        NetSignAgent.freeObjects((AbstractMessage)req, (AbstractMessage)res);
        return result;
    }

    public static NetSignResult generateBarCodeCodabar(BarCodeParameters para, String msg, float wideFactor, boolean displayStartStop) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("GenerateBarCodeCodabarProcessor");
        byte[] plainBytes = msg.getBytes();
        req.setPlainText(plainBytes);
        req.setBarCodeParameters(para);
        req.setBcWideFactor(wideFactor);
        req.setBcDisplayHumanReadableStartStop(displayStartStop);
        NSMessageOpt res = NetSignAgent.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.barcodeResult(res);
        NetSignAgent.freeObjects((AbstractMessage)req, (AbstractMessage)res);
        return result;
    }

    public static NetSignResult generateBarCodeInter25(BarCodeParameters para, String msg, boolean addCheckSUM, float wideFactor) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("GenerateBarCodeInter25Processor");
        byte[] plainBytes = msg.getBytes();
        req.setPlainText(plainBytes);
        req.setBarCodeParameters(para);
        req.setBcAddCheckSUM(addCheckSUM);
        req.setBcWideFactor(wideFactor);
        NSMessageOpt res = NetSignAgent.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.barcodeResult(res);
        NetSignAgent.freeObjects((AbstractMessage)req, (AbstractMessage)res);
        return result;
    }

    public static NetSignResult generateBarCodeQRCode(byte[] msg, int encodeMode, int errorCorrecting, int barSize, int returnFormat) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("GenerateBarCodeQRCodeProcessor");
        req.setPlainText(msg);
        req.setBcEncodingMode(encodeMode);
        req.setBcErrorCorrectingLevel(errorCorrecting);
        req.setBcBarSize(barSize);
        req.setBcReturnFormat(returnFormat);
        NSMessageOpt res = NetSignAgent.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.barcodeResult(res);
        NetSignAgent.freeObjects((AbstractMessage)req, (AbstractMessage)res);
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static X509Certificate generateCertificate(byte[] cert) throws Exception {
        ByteArrayInputStream in = null;
        if (cert[0] == 48) {
            int tl = (cert[1] & 0xFF) - 128;
            if (tl <= 0) throw new CertificateException("Illegal code: 30 " + (cert[1] & 0xFF));
            byte[] ltmp = new byte[tl];
            System.arraycopy(cert, 2, ltmp, 0, tl);
            int length = new BigInteger(ltmp).intValue();
            if (length <= 0 || length != cert.length - 2 - tl) throw new CertificateException("Illegal length: " + length);
            in = new ByteArrayInputStream(cert);
        } else {
            String head = "-----BEGIN CERTIFICATE-----";
            String tail = "-----END CERTIFICATE-----";
            String b64Cert = new String(cert);
            if (b64Cert.indexOf(head) > -1) {
                b64Cert = b64Cert.replaceFirst(head, "").replaceFirst(tail, "");
            }
            byte[] certTmp = NetSignAgent.base64Decode(b64Cert.trim());
            in = new ByteArrayInputStream(certTmp);
        }
        CertificateFactory cf = CertificateFactory.getInstance("X.509FX", "INFOSEC");
        return (X509Certificate)cf.generateCertificate(in);
    }

    public static String getCertificateDetail(X509Certificate cert, int type) {
        return new ExtendInfoUtil().getCertificateDetail(cert, type);
    }

    public static PrintWriter getDebugWriter() {
        return _writer;
    }

    public static String GetUserInfoByOid(X509Certificate certificate, String Oid) {
        return new ExtendInfoUtil().GetUserInfoByOid(certificate, Oid);
    }

    public static String getVersion() {
        return version;
    }

    public static void initialize() throws NetSignAgentException {
        NetSignAgentRes.initialize(null);
    }

    public static void initialize(ResourceBundle res) throws NetSignAgentException {
        NetSignAgentRes.initialize(res);
    }

    public static void initialize(String file) throws NetSignAgentException {
        if (!NetSignAgentRes.hasDone) {
            PropertyResourceBundle res = null;
            FileInputStream in = null;
            try {
                try {
                    in = new FileInputStream(file);
                    res = new PropertyResourceBundle(in);
                }
                catch (Exception e) {
                    System.out.println("NetSignAgent initialize failed");
                    e.printStackTrace();
                    throw new NetSignAgentException(-1, e.toString());
                }
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
            }
            NetSignAgentRes.initialize(res);
        }
    }

    public static NetSignResult makeEnvelope(byte[] plainText, String subject, String sAlg) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("MakeEnvelopedMSGProcessor");
        byte[] plainBytes = plainText;
        plainBytes = NetSignAgentUtil.checkAndZip(plainBytes, req);
        plainBytes = NetSignAgentUtil.checkAndEncrypt(plainBytes, req);
        req.setPlainText(plainBytes);
        req.setEncCertDN(subject);
        req.setSymmetricalAlg(sAlg);
        NSMessageOpt res = NetSignAgent.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.envelopeResult((NSMessage)res);
        NetSignAgent.freeObjects((AbstractMessage)req, (AbstractMessage)res);
        return result;
    }

    public static NetSignResult makeEnvelope(X509Certificate encCert, String sAlg, byte[] plainText) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("MakeEnvelopedMSGProcessor");
        byte[] plainBytes = plainText;
        plainBytes = NetSignAgentUtil.checkAndZip(plainBytes, req);
        plainBytes = NetSignAgentUtil.checkAndEncrypt(plainBytes, req);
        req.setPlainText(plainBytes);
        req.setTransCert(true);
        req.setCert(NetSignAgentUtil.transcertificate(encCert));
        req.setSymmetricalAlg(sAlg);
        NSMessageOpt res = NetSignAgent.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.envelopeResult((NSMessage)res);
        NetSignAgent.freeObjects((AbstractMessage)req, (AbstractMessage)res);
        return result;
    }

    public static NetSignResult makeMSEnvelope(byte[] plainText, String signSubject, String encSubject, String digestAlg, String sAlg) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("MakeMSEnvelopedMSGProcessor");
        byte[] plainBytes = plainText;
        plainBytes = NetSignAgentUtil.checkAndZip(plainBytes, req);
        plainBytes = NetSignAgentUtil.checkAndEncrypt(plainBytes, req);
        req.setPlainText(plainBytes);
        req.setEncCertDN(encSubject);
        req.setSignCertDN(signSubject);
        req.setSymmetricalAlg(sAlg);
        req.setDigestAlg(digestAlg);
        NSMessageOpt res = NetSignAgent.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.envelopeResult((NSMessage)res);
        NetSignAgent.freeObjects((AbstractMessage)req, (AbstractMessage)res);
        return result;
    }

    public static NetSignResult makeMSEnvelope(String signSubject, X509Certificate encCert, String digestAlg, String sAlg, byte[] plainText) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("MakeMSEnvelopedMSGProcessor");
        byte[] plainBytes = plainText;
        plainBytes = NetSignAgentUtil.checkAndZip(plainBytes, req);
        plainBytes = NetSignAgentUtil.checkAndEncrypt(plainBytes, req);
        req.setPlainText(plainBytes);
        req.setTransCert(true);
        req.setCert(NetSignAgentUtil.transcertificate(encCert));
        req.setSignCertDN(signSubject);
        req.setSymmetricalAlg(sAlg);
        req.setDigestAlg(digestAlg);
        NSMessageOpt res = NetSignAgent.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.envelopeResult((NSMessage)res);
        NetSignAgent.freeObjects((AbstractMessage)req, (AbstractMessage)res);
        return result;
    }

    public static byte[] makePlainTextWithFile(String fileName, byte[] filecontent) {
        byte[] fileNameBs = null;
        try {
            fileNameBs = fileName.getBytes("GBK");
        }
        catch (Exception e) {
            fileNameBs = fileName.getBytes();
        }
        byte[] str1 = "00000000".getBytes();
        byte[] str2 = "0".getBytes();
        byte[] strForm = "00000000".getBytes();
        int fileLen = filecontent.length;
        int nameLen = fileNameBs.length;
        str2 = Integer.toString(nameLen, 10).getBytes();
        byte[] str3 = Integer.toString(fileLen + nameLen + 8, 10).getBytes();
        byte[] StrFileSubTotal = new byte[16 + nameLen + filecontent.length];
        System.arraycopy(str1, 0, StrFileSubTotal, 0, 8 - str3.length);
        System.arraycopy(str3, 0, StrFileSubTotal, 8 - str3.length, str3.length);
        System.arraycopy(str1, 0, StrFileSubTotal, 8, 8 - str2.length);
        System.arraycopy(str2, 0, StrFileSubTotal, 16 - str2.length, str2.length);
        System.arraycopy(fileNameBs, 0, StrFileSubTotal, 16, fileNameBs.length);
        System.arraycopy(filecontent, 0, StrFileSubTotal, 16 + fileNameBs.length, filecontent.length);
        str2 = Integer.toString(StrFileSubTotal.length, 10).getBytes();
        byte[] strFinal = new byte[16 + StrFileSubTotal.length];
        System.arraycopy(strForm, 0, strFinal, 0, 8);
        System.arraycopy(str1, 0, strFinal, 8, 8 - str2.length);
        System.arraycopy(str2, 0, strFinal, 16 - str2.length, str2.length);
        System.arraycopy(StrFileSubTotal, 0, strFinal, 16, StrFileSubTotal.length);
        return strFinal;
    }

    public static NetSignResult PBCDetachedSignature(byte[] plainText, String subject, byte[] pwd) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("DetachedSignProcessor");
        byte[] plainBytes = plainText;
        plainBytes = NetSignAgentUtil.checkAndZip(plainBytes, req);
        plainBytes = NetSignAgentUtil.checkAndEncrypt(plainBytes, req);
        req.setPlainText(plainBytes);
        req.setUsedTSA(false);
        req.setSignCertDN(subject);
        req.setApiPasswd(pwd);
        NSMessageOpt res = NetSignAgent.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.signatureResult((NSMessage)res);
        NetSignAgent.freeObjects((AbstractMessage)req, (AbstractMessage)res);
        return result;
    }

    public static NetSignResult PBCRAWSignature(byte[] plainText, String subject, byte[] pwd) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("RAWSignProcessor");
        byte[] plainBytes = plainText;
        plainBytes = NetSignAgentUtil.checkAndZip(plainBytes, req);
        plainBytes = NetSignAgentUtil.checkAndEncrypt(plainBytes, req);
        req.setPlainText(plainBytes);
        req.setUsedTSA(false);
        req.setSignCertDN(subject);
        req.setApiPasswd(pwd);
        NSMessageOpt res = NetSignAgent.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.signatureResult((NSMessage)res);
        NetSignAgent.freeObjects((AbstractMessage)req, (AbstractMessage)res);
        return result;
    }

    public static NetSignResult pdfEncrypt(X509Certificate encCert, PDFParameters para) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("EncryptPDFByCertProcessor");
        byte[] plainBytes = NetSignAgentUtil.checkAndZip(para.getPdf(), req);
        plainBytes = NetSignAgentUtil.checkAndEncrypt(plainBytes, req);
        req.setPlainText(plainBytes);
        req.setCert(NetSignAgentUtil.transcertificate(encCert));
        if (para.getOwnerPassword() != null) {
            req.setPdfpasswd(para.getOwnerPassword());
        }
        NSMessageOpt res = NetSignAgent.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.pdfEncryptResult((NSMessage)res);
        NetSignAgent.freeObjects((AbstractMessage)req, (AbstractMessage)res);
        return result;
    }

    public static NetSignResult pdfSignature(PDFParameters para) throws NetSignAgentException, ServerProcessException {
        ArrayList pdfRequests;
        NSMessage req = NetSignAgentUtil.createMessage("PDFSignatureProcessor");
        byte[] plainBytes = NetSignAgentUtil.checkAndZip(para.getPdf(), req);
        plainBytes = NetSignAgentUtil.checkAndEncrypt(plainBytes, req);
        req.setPlainText(plainBytes);
        if (para.getOwnerPassword() != null) {
            req.setPdfpasswd(para.getOwnerPassword());
        }
        if ((pdfRequests = para.getRectangles()) == null || pdfRequests.size() <= 0) {
            throw new NetSignAgentException(-1028, "Pdf signature rectangle is null");
        }
        req.setPDFSignatureRectangles(pdfRequests);
        req.setPdfImages(para.getImages());
        NSMessageOpt res = NetSignAgent.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.pdfSignatureResult((NSMessage)res);
        NetSignAgent.freeObjects((AbstractMessage)req, (AbstractMessage)res);
        return result;
    }

    public static ArrayList pdfVerify(PDFParameters para, boolean needCert) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("PDFVerifyProcessor");
        byte[] plainBytes = NetSignAgentUtil.checkAndZip(para.getPdf(), req);
        plainBytes = NetSignAgentUtil.checkAndEncrypt(plainBytes, req);
        req.setTransCert(needCert);
        req.setPlainText(plainBytes);
        if (para.getOwnerPassword() != null) {
            req.setPdfpasswd(para.getOwnerPassword());
        }
        NSMessageOpt res = NetSignAgent.sendMsgAndCheck(req);
        ArrayList result = NetSignAgentUtil.pdfVerifyResult(res);
        NetSignAgent.freeObjects((AbstractMessage)req, (AbstractMessage)res);
        return result;
    }

    public static NetSignResult rawAfterwardsVerify(byte[] plainText, String signedText, X509Certificate cert) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("RAWAfterwardsVerifyProcessor");
        byte[] signedBytes = NetSignAgentUtil.decode(signedText);
        plainText = NetSignAgentUtil.checkAndZip(plainText, req);
        plainText = NetSignAgentUtil.checkAndEncrypt(plainText, req);
        req.setCryptoText(signedBytes);
        req.setPlainText(plainText);
        req.setCert(NetSignAgentUtil.transcertificate(cert));
        NSMessageOpt res = NetSignAgent.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.rawVerifyResult(res);
        NetSignAgent.freeObjects((AbstractMessage)req, (AbstractMessage)res);
        return result;
    }

    public static NetSignResult rawAfterwardsVerify(byte[] plainText, String signedText, String digestAlg, X509Certificate cert) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("RAWAfterwardsVerifyProcessor");
        byte[] signedBytes = NetSignAgentUtil.decode(signedText);
        plainText = NetSignAgentUtil.checkAndZip(plainText, req);
        plainText = NetSignAgentUtil.checkAndEncrypt(plainText, req);
        req.setCryptoText(signedBytes);
        req.setPlainText(plainText);
        req.setCert(NetSignAgentUtil.transcertificate(cert));
        if (digestAlg != null && !"".equals(digestAlg)) {
            req.setDigestAlg(digestAlg);
        }
        NSMessageOpt res = NetSignAgent.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.rawVerifyResult(res);
        NetSignAgent.freeObjects((AbstractMessage)req, (AbstractMessage)res);
        return result;
    }

    public static NetSignResult rawSignature(byte[] plainText, String subject, boolean useTSA) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("RAWSignProcessor");
        byte[] plainBytes = plainText;
        plainBytes = NetSignAgentUtil.checkAndZip(plainBytes, req);
        plainBytes = NetSignAgentUtil.checkAndEncrypt(plainBytes, req);
        req.setPlainText(plainBytes);
        req.setUsedTSA(useTSA);
        req.setSignCertDN(subject);
        NSMessageOpt res = NetSignAgent.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.signatureResult((NSMessage)res);
        NetSignAgent.freeObjects((AbstractMessage)req, (AbstractMessage)res);
        return result;
    }

    public static NetSignResult rawSignature(byte[] plainText, String subject, String digestAlg, boolean useTSA) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("RAWSignProcessor");
        byte[] plainBytes = plainText;
        plainBytes = NetSignAgentUtil.checkAndZip(plainBytes, req);
        plainBytes = NetSignAgentUtil.checkAndEncrypt(plainBytes, req);
        req.setPlainText(plainBytes);
        req.setUsedTSA(useTSA);
        if (digestAlg != null && !"".equals(digestAlg)) {
            req.setDigestAlg(digestAlg);
        }
        req.setSignCertDN(subject);
        NSMessageOpt res = NetSignAgent.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.signatureResult((NSMessage)res);
        NetSignAgent.freeObjects((AbstractMessage)req, (AbstractMessage)res);
        return result;
    }

    public static NetSignResult rawVerify(byte[] plainText, byte[] signedBytes, String tsaText, PublicKey publickey) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("RAWVerifyProcessor");
        plainText = NetSignAgentUtil.checkAndZip(plainText, req);
        plainText = NetSignAgentUtil.checkAndEncrypt(plainText, req);
        req.setCryptoText(signedBytes);
        req.setPlainText(plainText);
        NetSignAgentUtil.checkAndSetTSA(tsaText, req);
        req.setPublicKey(NetSignAgentUtil.transpublickey(publickey));
        NSMessageOpt res = NetSignAgent.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.rawVerifyResult(res);
        NetSignAgent.freeObjects((AbstractMessage)req, (AbstractMessage)res);
        return result;
    }

    public static NetSignResult rawVerify(byte[] plainText, byte[] signedText, String tsaText, String certDN) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("RAWVerifyProcessor");
        plainText = NetSignAgentUtil.checkAndZip(plainText, req);
        plainText = NetSignAgentUtil.checkAndEncrypt(plainText, req);
        byte[] signedBytes = signedText;
        req.setCryptoText(signedBytes);
        req.setPlainText(plainText);
        NetSignAgentUtil.checkAndSetTSA(tsaText, req);
        req.setSignCertDN(certDN);
        NSMessageOpt res = NetSignAgent.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.rawVerifyResult(res);
        NetSignAgent.freeObjects((AbstractMessage)req, (AbstractMessage)res);
        return result;
    }

    public static NetSignResult rawVerify(byte[] plainText, byte[] signedBytes, String digestAlg, String tsaText, X509Certificate cert) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("RAWVerifyProcessor");
        plainText = NetSignAgentUtil.checkAndZip(plainText, req);
        plainText = NetSignAgentUtil.checkAndEncrypt(plainText, req);
        req.setCryptoText(signedBytes);
        if (digestAlg != null && !"".equals(digestAlg)) {
            req.setDigestAlg(digestAlg);
        }
        req.setPlainText(plainText);
        NetSignAgentUtil.checkAndSetTSA(tsaText, req);
        req.setCert(NetSignAgentUtil.transcertificate(cert));
        NSMessageOpt res = NetSignAgent.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.rawVerifyResult(res);
        NetSignAgent.freeObjects((AbstractMessage)req, (AbstractMessage)res);
        return result;
    }

    public static NetSignResult rawVerify(byte[] plainText, byte[] signedBytes, String tsaText, X509Certificate cert) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("RAWVerifyProcessor");
        plainText = NetSignAgentUtil.checkAndZip(plainText, req);
        plainText = NetSignAgentUtil.checkAndEncrypt(plainText, req);
        req.setCryptoText(signedBytes);
        req.setPlainText(plainText);
        NetSignAgentUtil.checkAndSetTSA(tsaText, req);
        req.setCert(NetSignAgentUtil.transcertificate(cert));
        NSMessageOpt res = NetSignAgent.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.rawVerifyResult(res);
        NetSignAgent.freeObjects((AbstractMessage)req, (AbstractMessage)res);
        return result;
    }

    public static NetSignResult rawVerify(byte[] plainText, String signedText, String tsaText, PublicKey publickey) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("RAWVerifyProcessor");
        plainText = NetSignAgentUtil.checkAndZip(plainText, req);
        plainText = NetSignAgentUtil.checkAndEncrypt(plainText, req);
        byte[] signedBytes = NetSignAgentUtil.decode(signedText);
        req.setCryptoText(signedBytes);
        req.setPlainText(plainText);
        NetSignAgentUtil.checkAndSetTSA(tsaText, req);
        req.setPublicKey(NetSignAgentUtil.transpublickey(publickey));
        NSMessageOpt res = NetSignAgent.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.rawVerifyResult(res);
        NetSignAgent.freeObjects((AbstractMessage)req, (AbstractMessage)res);
        return result;
    }

    public static NetSignResult rawVerify(byte[] plainText, String signedText, String tsaText, String certDN) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("RAWVerifyProcessor");
        plainText = NetSignAgentUtil.checkAndZip(plainText, req);
        plainText = NetSignAgentUtil.checkAndEncrypt(plainText, req);
        byte[] signedBytes = NetSignAgentUtil.decode(signedText);
        req.setCryptoText(signedBytes);
        req.setPlainText(plainText);
        NetSignAgentUtil.checkAndSetTSA(tsaText, req);
        req.setSignCertDN(certDN);
        NSMessageOpt res = NetSignAgent.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.rawVerifyResult(res);
        NetSignAgent.freeObjects((AbstractMessage)req, (AbstractMessage)res);
        return result;
    }

    public static NetSignResult rawVerify(byte[] plainText, String signedText, String digestAlg, String tsaText, X509Certificate cert) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("RAWVerifyProcessor");
        byte[] signedBytes = NetSignAgentUtil.decode(signedText);
        plainText = NetSignAgentUtil.checkAndZip(plainText, req);
        plainText = NetSignAgentUtil.checkAndEncrypt(plainText, req);
        req.setCryptoText(signedBytes);
        req.setPlainText(plainText);
        req.setDigestAlg(digestAlg);
        NetSignAgentUtil.checkAndSetTSA(tsaText, req);
        req.setCert(NetSignAgentUtil.transcertificate(cert));
        NSMessageOpt res = NetSignAgent.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.rawVerifyResult(res);
        NetSignAgent.freeObjects((AbstractMessage)req, (AbstractMessage)res);
        return result;
    }

    public static NetSignResult rawVerify(byte[] plainText, String signedText, String tsaText, X509Certificate cert) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("RAWVerifyProcessor");
        byte[] signedBytes = NetSignAgentUtil.decode(signedText);
        plainText = NetSignAgentUtil.checkAndZip(plainText, req);
        plainText = NetSignAgentUtil.checkAndEncrypt(plainText, req);
        req.setCryptoText(signedBytes);
        req.setPlainText(plainText);
        NetSignAgentUtil.checkAndSetTSA(tsaText, req);
        req.setCert(NetSignAgentUtil.transcertificate(cert));
        NSMessageOpt res = NetSignAgent.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.rawVerifyResult(res);
        NetSignAgent.freeObjects((AbstractMessage)req, (AbstractMessage)res);
        return result;
    }

    public static NetSignResult rawVerify4QLBKB(byte[] plainText, String signedText, String digestAlg, X509Certificate cert) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage(ILJ_KEY2G_STANDARD_KLB);
        plainText = NetSignAgentUtil.checkAndZip(plainText, req);
        plainText = NetSignAgentUtil.checkAndEncrypt(plainText, req);
        req.setCryptoText(NetSignAgent.base64Decode(signedText));
        req.setDigestAlg(digestAlg);
        req.setPlainText(plainText);
        req.setCert(NetSignAgentUtil.transcertificate(cert));
        req.setTransCert(true);
        NSMessageOpt res = NetSignAgent.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.rawVerifyResult(res);
        NetSignAgent.freeObjects((AbstractMessage)req, (AbstractMessage)res);
        return result;
    }

    public static NetSignResult RAWVerify4UKey2G(byte[] plainText, byte[] signed, X509Certificate cert, String digestAlg, String standard) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage(standard);
        plainText = NetSignAgentUtil.checkAndZip(plainText, req);
        plainText = NetSignAgentUtil.checkAndEncrypt(plainText, req);
        req.setCryptoText(signed);
        req.setDigestAlg(digestAlg);
        req.setPlainText(plainText);
        req.setCert(NetSignAgentUtil.transcertificate(cert));
        req.setTransCert(true);
        NSMessageOpt res = NetSignAgent.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.rawVerifyResult(res);
        NetSignAgent.freeObjects((AbstractMessage)req, (AbstractMessage)res);
        return result;
    }

    public static NetSignResult RAWVerify4UKey2G(byte[] plainText, String signedText, X509Certificate cert, String digestAlg, String standard) throws NetSignAgentException, ServerProcessException {
        return NetSignAgent.RAWVerify4UKey2G(plainText, NetSignAgent.base64Decode(signedText), cert, digestAlg, standard);
    }

    static NSMessageOpt sendMsgAndCheck(NSMessage req) throws NetSignAgentException, ServerProcessException {
        NSMessageOpt resp = null;
        try {
            resp = NetSignAgentRes.isUseConnectionPool() ? cm.sendMessageUsingLongConnection(req) : cm.sendMessageUsingShrotConnection(req);
        }
        catch (Exception e) {
            ConsoleLogger.logException((Throwable)e);
            if (e instanceof NetSignAgentException) {
                throw (NetSignAgentException)e;
            }
            NetSignAgentException nsae = new NetSignAgentException(-1006, e.toString());
            throw nsae;
        }
        NetSignAgent.checkResult((AbstractMessage)resp);
        return resp;
    }

    public static void setDebugWriter(PrintWriter writer) {
        _writer = writer;
    }

    public static NetSignResult unstandardDetachedSignature(byte[] plainText, String subject, boolean useTSA, String standard) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage(String.valueOf(standard) + "DetachedSignProcessor");
        byte[] plainBytes = plainText;
        plainBytes = NetSignAgentUtil.checkAndZip(plainBytes, req);
        plainBytes = NetSignAgentUtil.checkAndEncrypt(plainBytes, req);
        req.setPlainText(plainBytes);
        req.setUsedTSA(useTSA);
        req.setSignCertDN(subject);
        NSMessageOpt res = NetSignAgent.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.signatureResult((NSMessage)res);
        NetSignAgent.freeObjects((AbstractMessage)req, (AbstractMessage)res);
        return result;
    }

    public static NetSignResult unstandardDetachedVerify(byte[] plainText, String signedText, String tsaText, boolean needCert, String standard) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage(String.valueOf(standard) + "DetachedVerifyProcessor");
        byte[] signedBytes = NetSignAgentUtil.decode(signedText);
        byte[] plainBytes = plainText;
        plainBytes = NetSignAgentUtil.checkAndZip(plainBytes, req);
        plainBytes = NetSignAgentUtil.checkAndEncrypt(plainBytes, req);
        req.setCryptoText(signedBytes);
        req.setPlainText(plainBytes);
        NetSignAgentUtil.checkAndSetTSA(tsaText, req);
        req.setTransCert(needCert);
        NSMessageOpt res = NetSignAgent.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.detachedVerifyResult(res);
        NetSignAgent.freeObjects((AbstractMessage)req, (AbstractMessage)res);
        return result;
    }

    public static String VerifyCertChainProcessor(String certDN) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("VerifyCertChainProcessor");
        req.setSignCertDN(certDN);
        NSMessageOpt resp = NetSignAgent.sendMsgAndCheck(req);
        StringBuffer sb = new StringBuffer();
        sb.append(resp.getSignIssuerSubject()).append(",");
        sb.append(resp.getSignEndtime()).append(",");
        sb.append(resp.getSignSerNumber()).append(",");
        sb.append(resp.getSignStartTime()).append(",");
        sb.append(resp.getCert()).append(",");
        sb.append(resp.getResult());
        return sb.toString();
    }

    public static NetSignResult verifyCertificate(X509Certificate cert) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("VerifyCertProcessor");
        req.setTransCert(true);
        req.setCert(cert);
        NSMessageOpt res = NetSignAgent.sendMsgAndCheck(req);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Sign_Subject", res.getSignSubject());
        map.put("Sign_Ser_Number", res.getSignSerNumber());
        map.put("Sign_Issuer_Subject", res.getSignIssuerSubject());
        map.put("Sign_Start_Time", res.getSignStartTime());
        map.put("Sign_End_Time", res.getSignEndtime());
        return new NetSignResult(map);
    }

    public static NetSignResult XMLAlipaySign(byte[] xml, String subjectDN) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("XMLAlipaySignProcessor");
        xml = NetSignAgentUtil.checkAndZip(xml, req);
        xml = NetSignAgentUtil.checkAndEncrypt(xml, req);
        req.setPlainText(xml);
        if (subjectDN != null && !subjectDN.equals("")) {
            req.setSignCertDN(subjectDN);
        }
        NSMessageOpt resp = NetSignAgent.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.xmlSignatureResult((NSMessage)resp);
        NetSignAgent.freeObjects((AbstractMessage)req, (AbstractMessage)resp);
        xml = null;
        return result;
    }

    public static ArrayList XMLAlipayVerify(byte[] xml, X509Certificate cert) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("XMLAlipayVerifyProcessor");
        xml = NetSignAgentUtil.checkAndZip(xml, req);
        xml = NetSignAgentUtil.checkAndEncrypt(xml, req);
        req.setPlainText(xml);
        req.setCert(cert);
        NSMessageOpt resp = NetSignAgent.sendMsgAndCheck(req);
        ArrayList result = NetSignAgentUtil.xmlVerifyResult(resp);
        NetSignAgent.freeObjects((AbstractMessage)req, (AbstractMessage)resp);
        xml = null;
        return result;
    }

    public static NetSignResult XMLDetachedSign(byte[] xml, boolean needCanonial, String tbsID, String signCertSubject, String sigID) throws NetSignAgentException, ServerProcessException {
        if (needCanonial) {
            try {
                xml = NetSignAgentUtil.xmlCanonical(xml);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new NetSignAgentException(-1029, e.toString());
            }
        }
        NSMessage req = NetSignAgentUtil.createMessage("XMLDatechedSignProcessor");
        xml = NetSignAgentUtil.checkAndZip(xml, req);
        xml = NetSignAgentUtil.checkAndEncrypt(xml, req);
        req.setPlainText(xml);
        if (signCertSubject != null && !signCertSubject.equals("")) {
            req.setSignCertDN(signCertSubject);
        }
        if (sigID != null && !sigID.equals("")) {
            req.setXmlSigID(sigID);
        }
        req.setXmlReferenceURI(tbsID);
        NSMessageOpt resp = NetSignAgent.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.xmlSignatureResult((NSMessage)resp);
        NetSignAgent.freeObjects((AbstractMessage)req, (AbstractMessage)resp);
        xml = null;
        return result;
    }

    public static NetSignResult XMLDetachedSign(byte[] xml, boolean needCanonial, String[] tbsID, String signCertSubject, String sigID) throws NetSignAgentException, ServerProcessException {
        if (needCanonial) {
            try {
                xml = NetSignAgentUtil.xmlCanonical(xml);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new NetSignAgentException(-1029, e.toString());
            }
        }
        NSMessage req = NetSignAgentUtil.createMessage("XMLDatechedSignProcessor");
        xml = NetSignAgentUtil.checkAndZip(xml, req);
        xml = NetSignAgentUtil.checkAndEncrypt(xml, req);
        req.setPlainText(xml);
        if (signCertSubject != null && !signCertSubject.equals("")) {
            req.setSignCertDN(signCertSubject);
        }
        if (sigID != null && !sigID.equals("")) {
            req.setXmlSigID(sigID);
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < tbsID.length) {
            sb.append(tbsID[i]);
            if (i < tbsID.length - 1) {
                sb.append(",");
            }
            ++i;
        }
        req.setXmlReferenceURI(sb.toString());
        NSMessageOpt resp = NetSignAgent.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.xmlSignatureResult((NSMessage)resp);
        NetSignAgent.freeObjects((AbstractMessage)req, (AbstractMessage)resp);
        xml = null;
        return result;
    }

    public static NetSignResult XMLEnvelopedSign(byte[] xml, boolean needCanonial, String signCertSubject, String sigID) throws NetSignAgentException, ServerProcessException {
        if (needCanonial) {
            try {
                xml = NetSignAgentUtil.xmlCanonical(xml);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new NetSignAgentException(-1029, e.toString());
            }
        }
        NSMessage req = NetSignAgentUtil.createMessage("XMLEnvelopedSignProcessor");
        req.setNeedCanonial(needCanonial);
        xml = NetSignAgentUtil.checkAndZip(xml, req);
        xml = NetSignAgentUtil.checkAndEncrypt(xml, req);
        req.setPlainText(xml);
        if (signCertSubject != null && !signCertSubject.equals("")) {
            req.setSignCertDN(signCertSubject);
        }
        if (sigID != null && !sigID.equals("")) {
            req.setXmlSigID(sigID);
        }
        NSMessageOpt resp = NetSignAgent.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.xmlSignatureResult((NSMessage)resp);
        NetSignAgent.freeObjects((AbstractMessage)req, (AbstractMessage)resp);
        xml = null;
        return result;
    }

    public static NetSignResult XMLEnvelopingSign(byte[] xml, boolean needCanonial, String signCertSubject, String sigID) throws NetSignAgentException, ServerProcessException {
        if (needCanonial) {
            try {
                xml = NetSignAgentUtil.xmlCanonical(xml);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new NetSignAgentException(-1029, e.toString());
            }
        }
        NSMessage req = NetSignAgentUtil.createMessage("XMLEnvelopingSignProcessor");
        xml = NetSignAgentUtil.checkAndZip(xml, req);
        xml = NetSignAgentUtil.checkAndEncrypt(xml, req);
        req.setPlainText(xml);
        if (signCertSubject != null && !signCertSubject.equals("")) {
            req.setSignCertDN(signCertSubject);
        }
        if (sigID != null && !sigID.equals("")) {
            req.setXmlSigID(sigID);
        }
        NSMessageOpt resp = NetSignAgent.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.xmlSignatureResult((NSMessage)resp);
        NetSignAgent.freeObjects((AbstractMessage)req, (AbstractMessage)resp);
        xml = null;
        return result;
    }

    public static ArrayList XMLSignatureAfterwardsVerify(byte[] xml, boolean needCanonical, boolean needCert) throws NetSignAgentException, ServerProcessException {
        if (needCanonical) {
            try {
                xml = NetSignAgentUtil.xmlCanonical(xml);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new NetSignAgentException(-1029, e.toString());
            }
        }
        NSMessage req = NetSignAgentUtil.createMessage("XMLSignatureAfterwardsVerifyProcessor");
        xml = NetSignAgentUtil.checkAndZip(xml, req);
        xml = NetSignAgentUtil.checkAndEncrypt(xml, req);
        req.setPlainText(xml);
        req.setTransCert(needCert);
        req.setNeedCanonial(needCanonical);
        NSMessageOpt resp = NetSignAgent.sendMsgAndCheck(req);
        ArrayList result = NetSignAgentUtil.xmlVerifyResult(resp);
        NetSignAgent.freeObjects((AbstractMessage)req, (AbstractMessage)resp);
        xml = null;
        return result;
    }

    public static ArrayList XMLSignatureVerify(byte[] xml, boolean needCanonical, boolean needCert) throws NetSignAgentException, ServerProcessException {
        if (needCanonical) {
            try {
                xml = NetSignAgentUtil.xmlCanonical(xml);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new NetSignAgentException(-1029, e.toString());
            }
        }
        NSMessage req = NetSignAgentUtil.createMessage("XMLSignatureVerifyProcessor");
        xml = NetSignAgentUtil.checkAndZip(xml, req);
        xml = NetSignAgentUtil.checkAndEncrypt(xml, req);
        req.setPlainText(xml);
        req.setTransCert(needCert);
        req.setNeedCanonial(needCanonical);
        NSMessageOpt resp = NetSignAgent.sendMsgAndCheck(req);
        ArrayList result = NetSignAgentUtil.xmlVerifyResult(resp);
        NetSignAgent.freeObjects((AbstractMessage)req, (AbstractMessage)resp);
        xml = null;
        return result;
    }

    public static NetSignResult XMLTenPaySign(byte[] xml, String tbsID, String signCertSubject, String sigID) throws NetSignAgentException, ServerProcessException {
        NSMessage req = NetSignAgentUtil.createMessage("XMLTenPaySignProcessor");
        xml = NetSignAgentUtil.checkAndZip(xml, req);
        xml = NetSignAgentUtil.checkAndEncrypt(xml, req);
        req.setPlainText(xml);
        if (signCertSubject != null && !signCertSubject.equals("")) {
            req.setSignCertDN(signCertSubject);
        }
        if (sigID != null && !sigID.equals("")) {
            req.setXmlSigID(sigID);
        }
        req.setXmlReferenceURI(tbsID);
        NSMessageOpt resp = NetSignAgent.sendMsgAndCheck(req);
        NetSignResult result = NetSignAgentUtil.xmlSignatureResult((NSMessage)resp);
        NetSignAgent.freeObjects((AbstractMessage)req, (AbstractMessage)resp);
        xml = null;
        return result;
    }
}

