/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable.pinyin;

import com.fr.stable.StringUtils;
import com.fr.stable.pinyin.PinyinResource;
import java.util.Map;
import java.util.Properties;

public class ChineseHelper {
    private static final Properties CHINESETABLE = PinyinResource.getChineseTable();

    public static char convertToSimplifiedChinese(char c) {
        if (ChineseHelper.isTraditionalChinese(c)) {
            return CHINESETABLE.getProperty(String.valueOf(c)).charAt(0);
        }
        return c;
    }

    public static char convertToTraditionalChinese(char c) {
        String string = String.valueOf(c);
        if (CHINESETABLE.containsValue(string)) {
            for (Map.Entry<Object, Object> entry : CHINESETABLE.entrySet()) {
                if (!entry.getValue().toString().equals(string)) continue;
                return entry.getKey().toString().charAt(0);
            }
        }
        return c;
    }

    public static String convertToSimplifiedChinese(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            stringBuilder.append(ChineseHelper.convertToSimplifiedChinese(c));
        }
        return stringBuilder.toString();
    }

    public static String convertToTraditionalChinese(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            stringBuilder.append(ChineseHelper.convertToTraditionalChinese(c));
        }
        return stringBuilder.toString();
    }

    public static boolean isTraditionalChinese(char c) {
        return CHINESETABLE.containsKey(String.valueOf(c));
    }

    public static boolean isChinese(char c) {
        return c >= '\u4e00' && c <= '\u9fa5';
    }

    public static boolean containChinese(String string) {
        if (StringUtils.isBlank(string)) {
            return false;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (!ChineseHelper.isChinese(string.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean isChinese(String string) {
        if (StringUtils.isBlank(string)) {
            return false;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (ChineseHelper.isChinese(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static final boolean isChineseCharacter(char c) {
        Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(c);
        return unicodeBlock == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || unicodeBlock == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || unicodeBlock == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || unicodeBlock == Character.UnicodeBlock.GENERAL_PUNCTUATION || unicodeBlock == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || unicodeBlock == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS;
    }
}

