/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable.html;

import com.fr.json.JSONObject;
import com.fr.stable.CodeUtils;
import com.fr.stable.StableUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.html.Html;
import com.fr.stable.html.TextHtml;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Tag
extends Html {
    private String tagName;
    private List id;
    private List classes;
    private Map styles;
    private Map attributes;
    private List subHtmlList;
    private List siblingHtmlList;

    public Tag() {
        this(null);
    }

    public Tag(String string) {
        this.tagName = string;
    }

    public String getTagName() {
        return this.tagName;
    }

    public Tag cls(String string) {
        if (this.classes == null) {
            this.classes = new ArrayList();
        }
        this.classes.add(string);
        return this;
    }

    public Tag ids(String string) {
        if (this.id == null) {
            this.id = new ArrayList();
        }
        this.id.add(string);
        return this;
    }

    public Tag css(String string, String string2) {
        if (this.styles == null) {
            this.styles = new HashMap();
        }
        this.styles.put(string, string2);
        return this;
    }

    public String getCss(String string) {
        return this.styles == null ? "" : (String)this.styles.get(string);
    }

    public Tag css(Map map) {
        if (this.styles == null) {
            this.styles = new HashMap();
        }
        this.styles.putAll(map);
        return this;
    }

    public Tag attr(String string, String string2) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(string, string2);
        return this;
    }

    public String getAttr(String string) {
        return this.attributes.get(string) == null ? null : this.attributes.get(string).toString();
    }

    public Tag sub(Html html) {
        if (this.subHtmlList == null) {
            this.subHtmlList = new ArrayList();
        }
        this.subHtmlList.add(html);
        return this;
    }

    public List getSubHtmlList() {
        return this.subHtmlList;
    }

    public boolean isEmpty() {
        return this.subHtmlList == null || this.subHtmlList.isEmpty();
    }

    public Tag sub(String string) {
        return this.sub(new TextHtml(string));
    }

    public Tag sibling(Html html) {
        if (this.siblingHtmlList == null) {
            this.siblingHtmlList = new ArrayList();
        }
        this.siblingHtmlList.add(html);
        return this;
    }

    public void writeHtml(PrintWriter printWriter) {
        if (this.tagName == null) {
            this.writeAllSubTag(printWriter);
            return;
        }
        this.writeBegin(printWriter);
        if (this.shouldCloseAtBegin()) {
            return;
        }
        this.writeAllSubTag(printWriter);
        this.writeEnd(printWriter);
        if (this.siblingHtmlList != null) {
            int n = this.siblingHtmlList.size();
            for (int i = 0; i < n; ++i) {
                ((Html)this.siblingHtmlList.get(i)).writeHtml(printWriter);
            }
        }
    }

    public void writeAllSubTag(PrintWriter printWriter) {
        int n;
        int n2 = n = this.subHtmlList == null ? 0 : this.subHtmlList.size();
        for (int i = 0; i < n; ++i) {
            ((Html)this.subHtmlList.get(i)).writeHtml(printWriter);
        }
    }

    public void writeEnd(PrintWriter printWriter) {
        printWriter.write(new StringBuffer().append("</").append(this.tagName).append('>').toString());
    }

    public void writeBegin(PrintWriter printWriter) {
        printWriter.write(new StringBuffer().append('<').append(this.tagName).toString());
        printWriter.write(this.idBuffer().toString());
        printWriter.write(this.classBuffer().toString());
        printWriter.write(this.styleBuffer().toString());
        printWriter.write(this.attributeBuffer().toString());
        if (this.shouldCloseAtBegin()) {
            printWriter.write(" />");
        } else {
            printWriter.write(">");
        }
    }

    private boolean shouldCloseAtBegin() {
        return this.tagName.equalsIgnoreCase("COL") && (this.subHtmlList == null || this.subHtmlList.isEmpty());
    }

    public StringBuffer classBuffer() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getClassList().toString();
        if (StringUtils.isNotEmpty(string)) {
            stringBuffer.append(" class=\"");
            stringBuffer.append(string);
            stringBuffer.append('\"');
        }
        return stringBuffer;
    }

    public StringBuffer idBuffer() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getIDList().toString();
        if (StringUtils.isNotEmpty(string)) {
            stringBuffer.append(" id=\"");
            stringBuffer.append(string);
            stringBuffer.append('\"');
        }
        return stringBuffer;
    }

    public StringBuffer getClassList() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.classes != null && this.classes.size() > 0) {
            int n = this.classes.size();
            for (int i = 0; i < n - 1; ++i) {
                stringBuffer.append(this.classes.get(i));
                stringBuffer.append(' ');
            }
            stringBuffer.append(this.classes.get(n - 1));
        }
        return stringBuffer;
    }

    public StringBuffer getIDList() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.id != null && this.id.size() > 0) {
            int n = this.id.size();
            for (int i = 0; i < n - 1; ++i) {
                stringBuffer.append(this.id.get(i));
                stringBuffer.append(' ');
            }
            stringBuffer.append(this.id.get(n - 1));
        }
        return stringBuffer;
    }

    protected StringBuffer styleBuffer() {
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2 = new StringBuffer();
        if (this.styles != null && (stringBuffer = this.getStyleList()).length() > 0) {
            stringBuffer2.append(" style=\"").append(stringBuffer).append('\"');
        }
        return stringBuffer2;
    }

    public JSONObject getStyleJson() {
        return new JSONObject(this.styles);
    }

    public StringBuffer getStyleList() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.styles == null) {
            return stringBuffer;
        }
        for (Map.Entry entry : this.styles.entrySet()) {
            if ("background-size".equalsIgnoreCase(entry.getKey().toString())) continue;
            stringBuffer.append(entry.getKey()).append(':').append(entry.getValue()).append(';');
        }
        if (this.styles.containsKey("background-size")) {
            stringBuffer.append("background-size").append(':').append(this.styles.get("background-size").toString());
        }
        return stringBuffer;
    }

    private StringBuffer attributeBuffer() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.attributes != null) {
            for (Map.Entry entry : this.attributes.entrySet()) {
                stringBuffer.append(' ').append(entry.getKey()).append("=\"").append(CodeUtils.attributeHtmlEncode(entry.getValue().toString())).append('\"');
            }
        }
        return stringBuffer;
    }

    public String toString() {
        return this.toHtml();
    }

    public Object clone() throws CloneNotSupportedException {
        Tag tag = (Tag)super.clone();
        tag.attributes = this.cloneMap(this.attributes);
        tag.styles = this.cloneMap(this.styles);
        List list = this.getSubHtmlList();
        this.subHtmlList = new ArrayList();
        if (list != null) {
            for (Object object : list) {
                if (object instanceof Tag) {
                    object = ((Tag)object).clone();
                }
                this.subHtmlList.add(object);
            }
        }
        return tag;
    }

    private Map cloneMap(Map map) throws CloneNotSupportedException {
        if (map == null) {
            return null;
        }
        try {
            Method method = StableUtils.getDeclaredMethod(map.getClass(), "clone", new Class[0]);
            method.setAccessible(true);
            return (Map)method.invoke((Object)map, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

