/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable.collections.array;

import com.fr.stable.collections.utils.MathUtils;
import java.util.Arrays;

public class FloatArray {
    public float[] items;
    public int size;
    public boolean ordered;

    public FloatArray() {
        this(true, 16);
    }

    public FloatArray(int n) {
        this(true, n);
    }

    public FloatArray(boolean bl, int n) {
        this.ordered = bl;
        this.items = new float[n];
    }

    public FloatArray(FloatArray floatArray) {
        this.ordered = floatArray.ordered;
        this.size = floatArray.size;
        this.items = new float[this.size];
        System.arraycopy(floatArray.items, 0, this.items, 0, this.size);
    }

    public FloatArray(float[] fArray) {
        this(true, fArray, 0, fArray.length);
    }

    public FloatArray(boolean bl, float[] fArray, int n, int n2) {
        this(bl, n2);
        this.size = n2;
        System.arraycopy(fArray, n, this.items, 0, n2);
    }

    public void add(float f) {
        float[] fArray = this.items;
        if (this.size == fArray.length) {
            fArray = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        fArray[this.size++] = f;
    }

    public void addAll(FloatArray floatArray) {
        this.addAll(floatArray, 0, floatArray.size);
    }

    public void addAll(FloatArray floatArray, int n, int n2) {
        if (n + n2 > floatArray.size) {
            throw new IllegalArgumentException("offset + length must be <= size: " + n + " + " + n2 + " <= " + floatArray.size);
        }
        this.addAll(floatArray.items, n, n2);
    }

    public void addAll(float ... fArray) {
        this.addAll(fArray, 0, fArray.length);
    }

    public void addAll(float[] fArray, int n, int n2) {
        int n3 = this.size + n2;
        float[] fArray2 = this.items;
        if (n3 > fArray2.length) {
            fArray2 = this.resize(Math.max(8, (int)((float)n3 * 1.75f)));
        }
        System.arraycopy(fArray, n, fArray2, this.size, n2);
        this.size += n2;
    }

    public float get(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + n + " >= " + this.size);
        }
        return this.items[n];
    }

    public void set(int n, float f) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + n + " >= " + this.size);
        }
        this.items[n] = f;
    }

    public void incr(int n, float f) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + n + " >= " + this.size);
        }
        int n2 = n;
        this.items[n2] = this.items[n2] + f;
    }

    public void mul(int n, float f) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + n + " >= " + this.size);
        }
        int n2 = n;
        this.items[n2] = this.items[n2] * f;
    }

    public void insert(int n, float f) {
        if (n > this.size) {
            throw new IndexOutOfBoundsException("index can't be > size: " + n + " > " + this.size);
        }
        float[] fArray = this.items;
        if (this.size == fArray.length) {
            fArray = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        if (this.ordered) {
            System.arraycopy(fArray, n, fArray, n + 1, this.size - n);
        } else {
            fArray[this.size] = fArray[n];
        }
        ++this.size;
        fArray[n] = f;
    }

    public void swap(int n, int n2) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException("first can't be >= size: " + n + " >= " + this.size);
        }
        if (n2 >= this.size) {
            throw new IndexOutOfBoundsException("second can't be >= size: " + n2 + " >= " + this.size);
        }
        float[] fArray = this.items;
        float f = fArray[n];
        fArray[n] = fArray[n2];
        fArray[n2] = f;
    }

    public boolean contains(float f) {
        int n = this.size - 1;
        float[] fArray = this.items;
        while (n >= 0) {
            if (fArray[n--] != f) continue;
            return true;
        }
        return false;
    }

    public int indexOf(float f) {
        float[] fArray = this.items;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            if (fArray[i] != f) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(char c) {
        float[] fArray = this.items;
        for (int i = this.size - 1; i >= 0; --i) {
            if (fArray[i] != (float)c) continue;
            return i;
        }
        return -1;
    }

    public boolean removeValue(float f) {
        float[] fArray = this.items;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            if (fArray[i] != f) continue;
            this.removeIndex(i);
            return true;
        }
        return false;
    }

    public float removeIndex(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + n + " >= " + this.size);
        }
        float[] fArray = this.items;
        float f = fArray[n];
        --this.size;
        if (this.ordered) {
            System.arraycopy(fArray, n + 1, fArray, n, this.size - n);
        } else {
            fArray[n] = fArray[this.size];
        }
        return f;
    }

    public void removeRange(int n, int n2) {
        if (n2 >= this.size) {
            throw new IndexOutOfBoundsException("end can't be >= size: " + n2 + " >= " + this.size);
        }
        if (n > n2) {
            throw new IndexOutOfBoundsException("start can't be > end: " + n + " > " + n2);
        }
        float[] fArray = this.items;
        int n3 = n2 - n + 1;
        if (this.ordered) {
            System.arraycopy(fArray, n + n3, fArray, n, this.size - (n + n3));
        } else {
            int n4 = this.size - 1;
            for (int i = 0; i < n3; ++i) {
                fArray[n + i] = fArray[n4 - i];
            }
        }
        this.size -= n3;
    }

    public boolean removeAll(FloatArray floatArray) {
        int n;
        int n2 = n = this.size;
        float[] fArray = this.items;
        int n3 = floatArray.size;
        block0: for (int i = 0; i < n3; ++i) {
            float f = floatArray.get(i);
            for (int j = 0; j < n; ++j) {
                if (f != fArray[j]) continue;
                this.removeIndex(j);
                --n;
                continue block0;
            }
        }
        return n != n2;
    }

    public float pop() {
        return this.items[--this.size];
    }

    public float peek() {
        return this.items[this.size - 1];
    }

    public float first() {
        if (this.size == 0) {
            throw new IllegalStateException("Array is empty.");
        }
        return this.items[0];
    }

    public void clear() {
        this.size = 0;
    }

    public float[] shrink() {
        if (this.items.length != this.size) {
            this.resize(this.size);
        }
        return this.items;
    }

    public float[] ensureCapacity(int n) {
        int n2 = this.size + n;
        if (n2 > this.items.length) {
            this.resize(Math.max(8, n2));
        }
        return this.items;
    }

    public float[] setSize(int n) {
        if (n > this.items.length) {
            this.resize(Math.max(8, n));
        }
        this.size = n;
        return this.items;
    }

    protected float[] resize(int n) {
        float[] fArray = new float[n];
        float[] fArray2 = this.items;
        System.arraycopy(fArray2, 0, fArray, 0, Math.min(this.size, fArray.length));
        this.items = fArray;
        return fArray;
    }

    public void sort() {
        Arrays.sort(this.items, 0, this.size);
    }

    public void reverse() {
        float[] fArray = this.items;
        int n = this.size - 1;
        int n2 = this.size / 2;
        for (int i = 0; i < n2; ++i) {
            int n3 = n - i;
            float f = fArray[i];
            fArray[i] = fArray[n3];
            fArray[n3] = f;
        }
    }

    public void shuffle() {
        float[] fArray = this.items;
        for (int i = this.size - 1; i >= 0; --i) {
            int n = MathUtils.random(i);
            float f = fArray[i];
            fArray[i] = fArray[n];
            fArray[n] = f;
        }
    }

    public void truncate(int n) {
        if (this.size > n) {
            this.size = n;
        }
    }

    public float random() {
        if (this.size == 0) {
            return 0.0f;
        }
        return this.items[MathUtils.random(0, this.size - 1)];
    }

    public float[] toArray() {
        float[] fArray = new float[this.size];
        System.arraycopy(this.items, 0, fArray, 0, this.size);
        return fArray;
    }

    public int hashCode() {
        if (!this.ordered) {
            return super.hashCode();
        }
        float[] fArray = this.items;
        int n = 1;
        int n2 = this.size;
        for (int i = 0; i < n2; ++i) {
            n = n * 31 + Float.floatToIntBits(fArray[i]);
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!this.ordered) {
            return false;
        }
        if (!(object instanceof FloatArray)) {
            return false;
        }
        FloatArray floatArray = (FloatArray)object;
        if (!floatArray.ordered) {
            return false;
        }
        int n = this.size;
        if (n != floatArray.size) {
            return false;
        }
        float[] fArray = this.items;
        float[] fArray2 = floatArray.items;
        for (int i = 0; i < n; ++i) {
            if (fArray[i] == fArray2[i]) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object object, float f) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FloatArray)) {
            return false;
        }
        FloatArray floatArray = (FloatArray)object;
        int n = this.size;
        if (n != floatArray.size) {
            return false;
        }
        if (!this.ordered) {
            return false;
        }
        if (!floatArray.ordered) {
            return false;
        }
        float[] fArray = this.items;
        float[] fArray2 = floatArray.items;
        for (int i = 0; i < n; ++i) {
            if (!(Math.abs(fArray[i] - fArray2[i]) > f)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        float[] fArray = this.items;
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('[');
        stringBuilder.append(fArray[0]);
        for (int i = 1; i < this.size; ++i) {
            stringBuilder.append(", ");
            stringBuilder.append(fArray[i]);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public String toString(String string) {
        if (this.size == 0) {
            return "";
        }
        float[] fArray = this.items;
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append(fArray[0]);
        for (int i = 1; i < this.size; ++i) {
            stringBuilder.append(string);
            stringBuilder.append(fArray[i]);
        }
        return stringBuilder.toString();
    }

    public static FloatArray with(float ... fArray) {
        return new FloatArray(fArray);
    }
}

