/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable.collections.array;

import com.fr.stable.collections.utils.MathUtils;
import java.util.Arrays;

public class ByteArray {
    public byte[] items;
    public int size;
    public boolean ordered;

    public ByteArray() {
        this(true, 16);
    }

    public ByteArray(int n) {
        this(true, n);
    }

    public ByteArray(boolean bl, int n) {
        this.ordered = bl;
        this.items = new byte[n];
    }

    public ByteArray(ByteArray byteArray) {
        this.ordered = byteArray.ordered;
        this.size = byteArray.size;
        this.items = new byte[this.size];
        System.arraycopy(byteArray.items, 0, this.items, 0, this.size);
    }

    public ByteArray(byte[] byArray) {
        this(true, byArray, 0, byArray.length);
    }

    public ByteArray(boolean bl, byte[] byArray, int n, int n2) {
        this(bl, n2);
        this.size = n2;
        System.arraycopy(byArray, n, this.items, 0, n2);
    }

    public void add(byte by) {
        byte[] byArray = this.items;
        if (this.size == byArray.length) {
            byArray = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        byArray[this.size++] = by;
    }

    public void addAll(ByteArray byteArray) {
        this.addAll(byteArray, 0, byteArray.size);
    }

    public void addAll(ByteArray byteArray, int n, int n2) {
        if (n + n2 > byteArray.size) {
            throw new IllegalArgumentException("offset + length must be <= size: " + n + " + " + n2 + " <= " + byteArray.size);
        }
        this.addAll(byteArray.items, n, n2);
    }

    public void addAll(byte ... byArray) {
        this.addAll(byArray, 0, byArray.length);
    }

    public void addAll(byte[] byArray, int n, int n2) {
        int n3 = this.size + n2;
        byte[] byArray2 = this.items;
        if (n3 > byArray2.length) {
            byArray2 = this.resize(Math.max(8, (int)((float)n3 * 1.75f)));
        }
        System.arraycopy(byArray, n, byArray2, this.size, n2);
        this.size += n2;
    }

    public byte get(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + n + " >= " + this.size);
        }
        return this.items[n];
    }

    public void set(int n, byte by) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + n + " >= " + this.size);
        }
        this.items[n] = by;
    }

    public void incr(int n, byte by) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + n + " >= " + this.size);
        }
        int n2 = n;
        this.items[n2] = (byte)(this.items[n2] + by);
    }

    public void mul(int n, byte by) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + n + " >= " + this.size);
        }
        int n2 = n;
        this.items[n2] = (byte)(this.items[n2] * by);
    }

    public void insert(int n, byte by) {
        if (n > this.size) {
            throw new IndexOutOfBoundsException("index can't be > size: " + n + " > " + this.size);
        }
        byte[] byArray = this.items;
        if (this.size == byArray.length) {
            byArray = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        if (this.ordered) {
            System.arraycopy(byArray, n, byArray, n + 1, this.size - n);
        } else {
            byArray[this.size] = byArray[n];
        }
        ++this.size;
        byArray[n] = by;
    }

    public void swap(int n, int n2) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException("first can't be >= size: " + n + " >= " + this.size);
        }
        if (n2 >= this.size) {
            throw new IndexOutOfBoundsException("second can't be >= size: " + n2 + " >= " + this.size);
        }
        byte[] byArray = this.items;
        byte by = byArray[n];
        byArray[n] = byArray[n2];
        byArray[n2] = by;
    }

    public boolean contains(byte by) {
        int n = this.size - 1;
        byte[] byArray = this.items;
        while (n >= 0) {
            if (byArray[n--] != by) continue;
            return true;
        }
        return false;
    }

    public int indexOf(byte by) {
        byte[] byArray = this.items;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            if (byArray[i] != by) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(byte by) {
        byte[] byArray = this.items;
        for (int i = this.size - 1; i >= 0; --i) {
            if (byArray[i] != by) continue;
            return i;
        }
        return -1;
    }

    public boolean removeValue(byte by) {
        byte[] byArray = this.items;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            if (byArray[i] != by) continue;
            this.removeIndex(i);
            return true;
        }
        return false;
    }

    public int removeIndex(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + n + " >= " + this.size);
        }
        byte[] byArray = this.items;
        byte by = byArray[n];
        --this.size;
        if (this.ordered) {
            System.arraycopy(byArray, n + 1, byArray, n, this.size - n);
        } else {
            byArray[n] = byArray[this.size];
        }
        return by;
    }

    public void removeRange(int n, int n2) {
        if (n2 >= this.size) {
            throw new IndexOutOfBoundsException("end can't be >= size: " + n2 + " >= " + this.size);
        }
        if (n > n2) {
            throw new IndexOutOfBoundsException("start can't be > end: " + n + " > " + n2);
        }
        byte[] byArray = this.items;
        int n3 = n2 - n + 1;
        if (this.ordered) {
            System.arraycopy(byArray, n + n3, byArray, n, this.size - (n + n3));
        } else {
            int n4 = this.size - 1;
            for (int i = 0; i < n3; ++i) {
                byArray[n + i] = byArray[n4 - i];
            }
        }
        this.size -= n3;
    }

    public boolean removeAll(ByteArray byteArray) {
        int n;
        int n2 = n = this.size;
        byte[] byArray = this.items;
        int n3 = byteArray.size;
        block0: for (int i = 0; i < n3; ++i) {
            byte by = byteArray.get(i);
            for (int j = 0; j < n; ++j) {
                if (by != byArray[j]) continue;
                this.removeIndex(j);
                --n;
                continue block0;
            }
        }
        return n != n2;
    }

    public byte pop() {
        return this.items[--this.size];
    }

    public byte peek() {
        return this.items[this.size - 1];
    }

    public byte first() {
        if (this.size == 0) {
            throw new IllegalStateException("Array is empty.");
        }
        return this.items[0];
    }

    public void clear() {
        this.size = 0;
    }

    public byte[] shrink() {
        if (this.items.length != this.size) {
            this.resize(this.size);
        }
        return this.items;
    }

    public byte[] ensureCapacity(int n) {
        int n2 = this.size + n;
        if (n2 > this.items.length) {
            this.resize(Math.max(8, n2));
        }
        return this.items;
    }

    public byte[] setSize(int n) {
        if (n > this.items.length) {
            this.resize(Math.max(8, n));
        }
        this.size = n;
        return this.items;
    }

    protected byte[] resize(int n) {
        byte[] byArray = new byte[n];
        byte[] byArray2 = this.items;
        System.arraycopy(byArray2, 0, byArray, 0, Math.min(this.size, byArray.length));
        this.items = byArray;
        return byArray;
    }

    public void sort() {
        Arrays.sort(this.items, 0, this.size);
    }

    public void reverse() {
        byte[] byArray = this.items;
        int n = this.size - 1;
        int n2 = this.size / 2;
        for (int i = 0; i < n2; ++i) {
            int n3 = n - i;
            byte by = byArray[i];
            byArray[i] = byArray[n3];
            byArray[n3] = by;
        }
    }

    public void shuffle() {
        byte[] byArray = this.items;
        for (int i = this.size - 1; i >= 0; --i) {
            int n = MathUtils.random(i);
            byte by = byArray[i];
            byArray[i] = byArray[n];
            byArray[n] = by;
        }
    }

    public void truncate(int n) {
        if (this.size > n) {
            this.size = n;
        }
    }

    public byte random() {
        if (this.size == 0) {
            return 0;
        }
        return this.items[MathUtils.random(0, this.size - 1)];
    }

    public byte[] toArray() {
        byte[] byArray = new byte[this.size];
        System.arraycopy(this.items, 0, byArray, 0, this.size);
        return byArray;
    }

    public int hashCode() {
        if (!this.ordered) {
            return super.hashCode();
        }
        byte[] byArray = this.items;
        int n = 1;
        int n2 = this.size;
        for (int i = 0; i < n2; ++i) {
            n = n * 31 + byArray[i];
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!this.ordered) {
            return false;
        }
        if (!(object instanceof ByteArray)) {
            return false;
        }
        ByteArray byteArray = (ByteArray)object;
        if (!byteArray.ordered) {
            return false;
        }
        int n = this.size;
        if (n != byteArray.size) {
            return false;
        }
        byte[] byArray = this.items;
        byte[] byArray2 = byteArray.items;
        for (int i = 0; i < n; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        byte[] byArray = this.items;
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('[');
        stringBuilder.append(byArray[0]);
        for (int i = 1; i < this.size; ++i) {
            stringBuilder.append(", ");
            stringBuilder.append(byArray[i]);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public String toString(String string) {
        if (this.size == 0) {
            return "";
        }
        byte[] byArray = this.items;
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append(byArray[0]);
        for (int i = 1; i < this.size; ++i) {
            stringBuilder.append(string);
            stringBuilder.append(byArray[i]);
        }
        return stringBuilder.toString();
    }

    public static ByteArray with(byte ... byArray) {
        return new ByteArray(byArray);
    }
}

