/*
 * Decompiled with CFR 0.152.
 */
package com.fr.form.ui;

import com.fr.base.BaseXMLUtils;
import com.fr.base.FRContext;
import com.fr.form.ui.CustomToolBarButton;
import com.fr.form.ui.Widget;
import com.fr.form.ui.WidgetXmlUtils;
import com.fr.general.Background;
import com.fr.general.ComparatorUtils;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.privilege.PrivilegeManager;
import com.fr.privilege.finegrain.AbstractPrivilegeControl;
import com.fr.script.Calculator;
import com.fr.stable.core.NodeVisitor;
import com.fr.stable.web.Repository;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLReadable;
import com.fr.stable.xml.XMLableReader;
import com.fr.web.BaseHTMLWriterUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ToolBar
extends Widget {
    protected List widgets = new ArrayList();
    private boolean isDefault = true;
    private Background background = null;

    public ToolBar() {
    }

    public ToolBar(Widget[] widgetArray) {
        if (widgetArray != null) {
            this.widgets.addAll(Arrays.asList(widgetArray));
        }
    }

    public String getXType() {
        return "toolbar";
    }

    public boolean isEditor() {
        return false;
    }

    public String[] supportedEvents() {
        return new String[0];
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setDefault(boolean bl) {
        this.isDefault = bl;
    }

    public Background getBackground() {
        return this.background;
    }

    public void setBackground(Background background) {
        this.background = background;
    }

    public int getWidgetSize() {
        return this.widgets == null ? 0 : this.widgets.size();
    }

    public Widget getWidget(int n) {
        return (Widget)this.widgets.get(n);
    }

    public void addWidget(Widget widget) {
        if (this.widgets == null) {
            this.widgets = new ArrayList();
        }
        this.widgets.add(widget);
    }

    public void addWidgetAhead(Widget widget) {
        if (this.widgets == null) {
            this.widgets = new ArrayList();
        }
        if (this.widgets.contains(widget)) {
            return;
        }
        this.widgets.add(0, widget);
    }

    public Widget removeWidget(int n) {
        if (this.widgets == null || this.widgets.size() <= n) {
            return null;
        }
        return (Widget)this.widgets.remove(n);
    }

    public void clearWidgets() {
        if (this.widgets != null) {
            this.widgets.clear();
        }
    }

    public JSONObject createJSONConfig(Repository repository, Calculator calculator, NodeVisitor nodeVisitor) throws JSONException {
        JSONObject jSONObject = super.createJSONConfig(repository, calculator, nodeVisitor);
        jSONObject.put("disabled", this.isEnabled() ? "true" : "false");
        jSONObject.put("items", this.createJSONComponents(repository, calculator, nodeVisitor));
        if (!this.isDefault) {
            if (this.background != null) {
                jSONObject.put("toolbarbg", BaseHTMLWriterUtils.jsonBackground(this.background, repository));
            } else {
                jSONObject.put("toolbarbg", "none");
            }
        }
        return jSONObject;
    }

    private JSONArray createJSONComponents(Repository repository, Calculator calculator, NodeVisitor nodeVisitor) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        int n = this.widgets.size();
        for (int i = 0; i < n; ++i) {
            Widget widget = null;
            try {
                XMLReadable xMLReadable;
                widget = (Widget)((Widget)this.widgets.get(i)).clone();
                Calculator.createCalculator();
                String[] stringArray = PrivilegeManager.getRoleFromCalculator(calculator);
                if (stringArray.length > 0) {
                    xMLReadable = widget.getWidgetPrivilegeControl();
                    if (widget.isVisible()) {
                        widget.setVisible(!((AbstractPrivilegeControl)xMLReadable).checkInvisible(stringArray));
                    }
                    if (!widget.isVisible()) continue;
                }
                if (widget instanceof CustomToolBarButton && (xMLReadable = ((CustomToolBarButton)widget).getJSImpl()) != null) {
                    xMLReadable.setShouldRecalculate(true);
                }
                jSONArray.put(widget.createJSONConfig(repository, calculator, nodeVisitor));
                continue;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                FRContext.getLogger().error(cloneNotSupportedException.getMessage());
            }
        }
        return jSONArray;
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("ToolBar");
        int n = this.getWidgetSize();
        for (int i = 0; i < n; ++i) {
            WidgetXmlUtils.writeXMLWidget(xMLPrintWriter, this.getWidget(i));
        }
        if (!this.isDefault()) {
            xMLPrintWriter.startTAG("IsDefault").textNode(String.valueOf(this.isDefault)).end();
            if (this.background != null) {
                BaseXMLUtils.writeBackground(xMLPrintWriter, this.background);
            }
        }
        xMLPrintWriter.end();
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isAttr()) {
            this.clearWidgets();
        }
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if (string.equals("Widget")) {
                this.addWidget(WidgetXmlUtils.readWidget(xMLableReader));
            } else if ("Background".equals(string)) {
                this.setBackground(BaseXMLUtils.readBackground(xMLableReader));
            } else if ("IsDefault".equals(string)) {
                String string2 = null;
                string2 = xMLableReader.getElementValue();
                if (string2 != null) {
                    this.setDefault(Boolean.valueOf(string2));
                }
            }
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ToolBar)) {
            return false;
        }
        ToolBar toolBar = (ToolBar)object;
        return super.equals(object) && ComparatorUtils.equals((Object)this.widgets, (Object)toolBar.widgets) && this.isDefault == toolBar.isDefault && ComparatorUtils.equals(this.background, toolBar.background);
    }

    public Object clone() throws CloneNotSupportedException {
        ToolBar toolBar = (ToolBar)super.clone();
        if (this.widgets != null) {
            toolBar.widgets = new ArrayList(this.widgets.size());
            int n = this.widgets.size();
            for (int i = 0; i < n; ++i) {
                toolBar.widgets.add(((Widget)this.widgets.get(i)).clone());
            }
        }
        if (this.background != null) {
            toolBar.background = (Background)this.background.clone();
        }
        return toolBar;
    }
}

