/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.impl;

import com.fr.base.TableData;
import com.fr.data.AbstractParameterTableData;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.general.GeneralUtils;
import com.fr.general.data.DataModel;
import com.fr.script.Calculator;
import com.fr.stable.ArrayUtils;
import com.fr.stable.ParameterProvider;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;

public class ClassTableData
extends AbstractParameterTableData
implements XMLable {
    private String className;
    private TableData _tableData = null;

    public ClassTableData() {
    }

    public ClassTableData(String string) {
        this.setClassName(string);
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String string) {
        this.className = string;
    }

    private TableData createTableData() {
        if (this._tableData == null) {
            try {
                this._tableData = (TableData)GeneralUtils.classForName(this.getClassName()).newInstance();
                Calculator calculator = Calculator.createCalculator();
                Object[] objectArray = this._tableData.getParameters(calculator);
                if (ArrayUtils.isEmpty(objectArray)) {
                    this._tableData.setParameters(super.getParameters(calculator));
                }
            }
            catch (Exception exception) {
                FRLogger.getLogger().error("ClassName: " + this.getClassName());
                FRLogger.getLogger().error(exception.getMessage(), exception);
                this._tableData = TableData.EMPTY_TABLEDATA;
            }
            catch (Error error) {
                FRLogger.getLogger().error("ClassName: " + this.getClassName());
                FRLogger.getLogger().error(error.getMessage(), error);
                this._tableData = TableData.EMPTY_TABLEDATA;
            }
        }
        return this._tableData;
    }

    public DataModel createDataModel(Calculator calculator) {
        return this.createTableData().createDataModel(calculator);
    }

    public ParameterProvider[] getParameters(Calculator calculator) {
        return this.createTableData().getParameters(calculator);
    }

    public String toString() {
        return "ClassTableData[Class:" + this.getClassName() + "]";
    }

    public boolean equals(Object object) {
        return object instanceof ClassTableData && super.equals(object) && ComparatorUtils.equals(this.className, ((ClassTableData)object).className);
    }

    public Object clone() throws CloneNotSupportedException {
        ClassTableData classTableData = new ClassTableData(this.getClassName());
        classTableData.setDefaultParameters(this.getParameters(Calculator.createCalculator()));
        return classTableData;
    }

    public void readXML(XMLableReader xMLableReader) {
        String string;
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode() && xMLableReader.getTagName().equals("ClassTableDataAttr") && (string = xMLableReader.getAttrAsString("className", null)) != null) {
            this.setClassName(string);
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        xMLPrintWriter.startTAG("ClassTableDataAttr").attr("className", this.getClassName()).end();
    }
}

