/*
 * Decompiled with CFR 0.152.
 */
package com.fr.data.dao;

import com.fr.data.core.db.TableName;
import com.fr.data.core.db.dml.Table;
import com.fr.data.dao.DAOUtils;
import com.fr.data.dao.DataInitJob;
import com.fr.data.dao.FieldColumnMapper;
import com.fr.data.dao.UniqueKey;
import com.fr.general.ComparatorUtils;
import com.fr.general.FRLogger;
import com.fr.stable.fun.Level;
import com.fr.stable.fun.impl.AbstractProvider;
import com.fr.stable.fun.mark.API;
import com.fr.stable.fun.mark.Mutable;
import java.io.Serializable;
import java.util.ArrayList;

@API(level=1)
public class ObjectTableMapper
extends AbstractProvider
implements Cloneable,
Serializable,
Level,
Mutable {
    public static final String MARK_STRING = "ObjectTableMapper";
    public static final String PREFIX_NAME = "FR_T_";
    public static final int CURRENT_LEVEL = 1;
    protected Table table;
    protected FieldColumnMapper[] fieldMappers;
    protected Class clazz;
    protected String[][] uniqueColumns;
    protected DataInitJob job = null;
    protected boolean checkTable = true;
    protected int checkTableExistLevel = 1;

    public ObjectTableMapper() {
    }

    public int currentAPILevel() {
        return 1;
    }

    public String mark4Provider() {
        return this.table == null ? "Empty" : this.table.getName();
    }

    public ObjectTableMapper(Table table, FieldColumnMapper[] fieldColumnMapperArray, String[][] stringArray) {
        this(null, table, fieldColumnMapperArray, stringArray, null);
    }

    public ObjectTableMapper(Class clazz, FieldColumnMapper[] fieldColumnMapperArray) {
        this(clazz, fieldColumnMapperArray, (String[][])null);
    }

    public ObjectTableMapper(Class clazz, FieldColumnMapper[] fieldColumnMapperArray, String[][] stringArray) {
        this(clazz, fieldColumnMapperArray, stringArray, null);
    }

    public ObjectTableMapper(Class clazz, TableName tableName, FieldColumnMapper[] fieldColumnMapperArray, String[][] stringArray) {
        this(clazz, tableName.getName(), fieldColumnMapperArray, stringArray, null);
    }

    private ObjectTableMapper(Class clazz, String string, FieldColumnMapper[] fieldColumnMapperArray, String[][] stringArray, DataInitJob dataInitJob) {
        this(clazz, new Table(PREFIX_NAME + string), fieldColumnMapperArray, stringArray, dataInitJob);
    }

    public ObjectTableMapper(Class clazz, FieldColumnMapper[] fieldColumnMapperArray, String[][] stringArray, DataInitJob dataInitJob) {
        this(clazz, new Table(PREFIX_NAME + DAOUtils.getClassNameWithOutPath(clazz)), fieldColumnMapperArray, stringArray, dataInitJob);
    }

    public ObjectTableMapper(Table table, Class clazz, FieldColumnMapper[] fieldColumnMapperArray, String[][] stringArray, DataInitJob dataInitJob) {
        this(clazz, table, fieldColumnMapperArray, stringArray, dataInitJob);
    }

    public ObjectTableMapper(Class clazz, Table table, FieldColumnMapper[] fieldColumnMapperArray) {
        this(clazz, table, fieldColumnMapperArray, (String[][])null, null);
    }

    public ObjectTableMapper(Class clazz, Table table, FieldColumnMapper[] fieldColumnMapperArray, String[][] stringArray) {
        this(clazz, table, fieldColumnMapperArray, stringArray, null);
    }

    public ObjectTableMapper(Class clazz, Table table, FieldColumnMapper[] fieldColumnMapperArray, String[][] stringArray, DataInitJob dataInitJob) {
        this.setObjectClass(clazz);
        this.setTable(table);
        this.setFieldColumnMappers(fieldColumnMapperArray);
        this.uniqueColumns = stringArray;
        this.job = dataInitJob;
    }

    public ObjectTableMapper(Class clazz, Table table, FieldColumnMapper[] fieldColumnMapperArray, int n) {
        this(clazz, table, fieldColumnMapperArray, (String[][])null, null);
        this.checkTableExistLevel = n;
    }

    public ObjectTableMapper(Class clazz, TableName tableName, FieldColumnMapper[] fieldColumnMapperArray, int n) {
        this(clazz, new Table(tableName.getName()), fieldColumnMapperArray, (String[][])null, null);
        this.checkTableExistLevel = n;
    }

    public ObjectTableMapper(Class clazz, FieldColumnMapper[] fieldColumnMapperArray, String[][] stringArray, int n) {
        this(clazz, fieldColumnMapperArray, stringArray, null);
        this.checkTableExistLevel = n;
    }

    public ObjectTableMapper(Class clazz, TableName tableName, FieldColumnMapper[] fieldColumnMapperArray, String[][] stringArray, int n) {
        this(clazz, tableName.getName(), fieldColumnMapperArray, stringArray, null);
        this.checkTableExistLevel = n;
    }

    public ObjectTableMapper(Class clazz, TableName tableName, FieldColumnMapper[] fieldColumnMapperArray, String[][] stringArray, DataInitJob dataInitJob) {
        this(clazz, tableName.getName(), fieldColumnMapperArray, stringArray, dataInitJob);
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public Table getTable() {
        return this.table;
    }

    public void setFieldColumnMappers(FieldColumnMapper[] fieldColumnMapperArray) {
        this.fieldMappers = fieldColumnMapperArray;
    }

    public FieldColumnMapper[] getFieldColumnMappers() {
        return this.fieldMappers;
    }

    public void setObjectClass(Class clazz) {
        this.clazz = clazz;
    }

    public Class getObjectClass() {
        return this.clazz;
    }

    public int getFieldColumnMapperCount() {
        return this.fieldMappers.length;
    }

    public DataInitJob getDataInitJob() {
        return this.job;
    }

    public void setCheckTableExistLevel(int n) {
        this.checkTableExistLevel = n;
    }

    public FieldColumnMapper getPrimaryKey() {
        for (int i = 0; i < this.fieldMappers.length; ++i) {
            if (!this.fieldMappers[i].isPrimaryKey()) continue;
            return this.fieldMappers[i];
        }
        return null;
    }

    public UniqueKey[] getUniqueKeys() {
        if (this.uniqueColumns == null) {
            return null;
        }
        ArrayList<UniqueKey> arrayList = new ArrayList<UniqueKey>();
        for (int i = 0; i < this.uniqueColumns.length; ++i) {
            String[] stringArray = this.uniqueColumns[i];
            if (stringArray == null) continue;
            UniqueKey uniqueKey = new UniqueKey();
            for (int j = 0; j < stringArray.length; ++j) {
                FieldColumnMapper fieldColumnMapper = this.findFCMapperByColumnName(stringArray[j]);
                uniqueKey.addColumn(fieldColumnMapper.createTableColumn());
            }
            arrayList.add(uniqueKey);
        }
        return arrayList.toArray(new UniqueKey[arrayList.size()]);
    }

    public FieldColumnMapper findFCMapperByColumnName(String string) {
        if (string == null) {
            return null;
        }
        for (int i = 0; i < this.fieldMappers.length; ++i) {
            if (!ComparatorUtils.equals(string, this.fieldMappers[i].getColumnName())) continue;
            return this.fieldMappers[i];
        }
        return null;
    }

    public FieldColumnMapper findFCMapperByFieldName(String string) {
        if (string == null) {
            return null;
        }
        for (int i = 0; i < this.fieldMappers.length; ++i) {
            if (!ComparatorUtils.equals(string, this.fieldMappers[i].getFieldName())) continue;
            return this.fieldMappers[i];
        }
        return null;
    }

    public String findColumnNameByFieldName(String string) {
        FieldColumnMapper fieldColumnMapper = this.findFCMapperByFieldName(string);
        return fieldColumnMapper == null ? null : fieldColumnMapper.getColumnName();
    }

    public boolean shouleCheckTable() {
        return this.checkTable;
    }

    public boolean isCheckTable() {
        return this.checkTable;
    }

    public ObjectTableMapper applyNoCheckTableObjectCase() {
        try {
            ObjectTableMapper objectTableMapper = (ObjectTableMapper)this.clone();
            objectTableMapper.checkTable = false;
            return objectTableMapper;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            FRLogger.getLogger().error(cloneNotSupportedException.getMessage(), cloneNotSupportedException);
            return null;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

