/*
 * Decompiled with CFR 0.152.
 */
package com.fr.cluster.rpc;

import com.fr.cluster.rpc.Parameter;
import com.fr.cluster.rpc.RPCSkeleton;
import com.fr.cluster.rpc.RPCUtil;
import com.fr.cluster.rpc.Result;
import com.fr.cluster.rpc.ResultFactory;
import com.fr.general.FRLogger;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class RPCSkeletonsService {
    BIRPCStunManager birpcStunManager = new BIRPCStunManager();

    RPCSkeletonsService() {
    }

    public void dealWith(String string, String string2, ObjectOutputStream objectOutputStream, Serializable[] serializableArray) throws Exception {
        RPCSkeleton rPCSkeleton = this.birpcStunManager.getObj(string);
        if (rPCSkeleton == null) {
            throw new Exception("Class:" + string + " didn't is remote obj");
        }
        string = RPCUtil.decodeClassName(string);
        Object[] objectArray = this.checkParameterType(serializableArray);
        Object object = null;
        try {
            object = rPCSkeleton.invoke(string, string2, objectArray);
            if (object != null) {
                RPCSkeletonsService.isSerializable(object.getClass());
            }
        }
        catch (NotSerializableException notSerializableException) {
            throw notSerializableException;
        }
        catch (InvocationTargetException invocationTargetException) {
            RPCSkeletonsService.isSerializable(invocationTargetException.getTargetException().getClass());
            object = invocationTargetException.getTargetException();
        }
        Result result = this.generateResult(object, (Parameter[])objectArray);
        RPCSkeletonsService.writeObject(result, objectOutputStream);
    }

    private static boolean isSerializable(Class clazz) throws NotSerializableException {
        Class<?>[] classArray;
        if (RPCUtil.equalsTool(clazz, Object.class) || !clazz.getName().contains("com.fr")) {
            return true;
        }
        for (Class<?> clazz2 : classArray = clazz.getInterfaces()) {
            if (!RPCUtil.equalsTool(clazz2, Serializable.class)) continue;
            return RPCSkeletonsService.isSerializable(clazz.getSuperclass());
        }
        if (RPCSkeletonsService.isSerializable(clazz.getSuperclass())) {
            return true;
        }
        throw new NotSerializableException("Class:" + clazz.getName() + "need to be serializable");
    }

    protected Result generateResult(Object object, Parameter[] parameterArray) {
        return ResultFactory.generateResult(object, parameterArray);
    }

    private Parameter[] checkParameterType(Serializable[] serializableArray) {
        Parameter[] parameterArray = new Parameter[serializableArray.length];
        try {
            for (int i = 0; i < serializableArray.length; ++i) {
                ((Parameter)serializableArray[i]).recover();
                parameterArray[i] = (Parameter)serializableArray[i];
            }
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage());
        }
        return parameterArray;
    }

    public void register(String string, Object object) {
        this.birpcStunManager.register(string, object);
    }

    public static void writeObject(Serializable object, ObjectOutputStream objectOutputStream) {
        if (object == null) {
            object = "object_null";
        }
        if (objectOutputStream == null) {
            return;
        }
        try {
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
        }
        catch (IOException iOException) {
            FRLogger.getLogger().error(iOException.getMessage());
        }
    }

    private class BIRPCStunManager {
        private Map<String, RPCSkeleton> container = new ConcurrentHashMap<String, RPCSkeleton>();

        private BIRPCStunManager() {
        }

        public void register(String string, Object object) {
            RPCSkeleton rPCSkeleton = new RPCSkeleton(object);
            this.container.put(string, rPCSkeleton);
        }

        public boolean exists(String string) {
            return this.container.containsKey(string);
        }

        public RPCSkeleton getObj(String string) {
            return this.container.get(string);
        }
    }
}

