/*
 * Decompiled with CFR 0.152.
 */
package com.fr.cluster.rpc;

import com.fr.cluster.rpc.CacheContainer;
import com.fr.cluster.rpc.RPCClient;
import com.fr.cluster.rpc.SkeletonLocalization;
import com.fr.cluster.rpc.annotation.InvalidAllCaches;
import com.fr.cluster.rpc.annotation.InvalidCache;
import com.fr.cluster.rpc.annotation.SynchronizedMethod;
import com.fr.cluster.rpc.exception.CacheUnavailableException;
import com.fr.cluster.rpc.exception.SkeletonIsNullException;
import com.fr.general.FRLogger;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DeltaSkeletonLocalization
extends SkeletonLocalization {
    private ArrayList<String> synchronizedMethodList;
    private BlockingQueue<Message> synchronizedQueue = new LinkedBlockingQueue<Message>(20480);
    private ArrayList<String> invalidCacheMethodList;
    private ArrayList<String> invalidAllCachesMethodList;

    public DeltaSkeletonLocalization(RPCClient rPCClient, ArrayList<String> arrayList) {
        this(rPCClient, arrayList, 2048L, 0);
    }

    public DeltaSkeletonLocalization(RPCClient rPCClient, ArrayList<String> arrayList, Long l, int n) {
        super(rPCClient, arrayList, l, n);
        new Thread(new MessageSender()).start();
        this.synchronizedMethodList = this.getSynchronizedAnnotationMethods();
        this.invalidCacheMethodList = this.getInvalidCacheAnnotationMethods();
        this.invalidAllCachesMethodList = this.getInvalidAllCachesAnnotationMethods();
    }

    private ArrayList<String> getSynchronizedAnnotationMethods() {
        return this.getAnnotationMethods(this.getSkeletonClass(), SynchronizedMethod.class);
    }

    private ArrayList<String> getInvalidCacheAnnotationMethods() {
        return this.getAnnotationMethods(this.getSkeletonClass(), InvalidCache.class);
    }

    private ArrayList<String> getInvalidAllCachesAnnotationMethods() {
        return this.getAnnotationMethods(this.getSkeletonClass(), InvalidAllCaches.class);
    }

    protected ArrayList<String> getAnnotationMethods(Class clazz, Class clazz2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            Method[] methodArray;
            Class clazz3 = clazz;
            for (Method method : methodArray = clazz3.getMethods()) {
                if (!method.isAnnotationPresent(clazz2)) continue;
                arrayList.add(method.getName());
            }
        }
        catch (Exception exception) {
            FRLogger.getLogger().error(exception.getMessage());
        }
        return arrayList;
    }

    private void sendMessage(Method method, Object[] objectArray) {
        try {
            this.synchronizedQueue.put(new Message(method, objectArray));
        }
        catch (Exception exception) {
            FRLogger.getLogger().info(exception.getMessage());
        }
    }

    private boolean isSynchronizedMethod(Method method) {
        return this.synchronizedMethodList.contains(method.getName());
    }

    private boolean isInvalidCacheMethod(Method method) {
        return this.invalidCacheMethodList.contains(method.getName());
    }

    private boolean isInvalidAllCachesMethod(Method method) {
        return this.invalidAllCachesMethodList.contains(method.getName());
    }

    @Override
    public boolean isAvailable(Method method, Object[] objectArray) throws Throwable {
        return super.isAvailable(method, objectArray) && !this.isInvalidAllCachesMethod(method) && !this.isInvalidCacheMethod(method);
    }

    @Override
    public void subsequentProcess(Method method, Object[] objectArray) {
        this.checkInvalidCache(method);
    }

    @Override
    public Object fetch(Method method, Object[] objectArray) throws CacheUnavailableException, SkeletonIsNullException {
        if (this.isSynchronizedMethod(method)) {
            this.sendMessage(method, objectArray);
        }
        Object object = super.fetch(method, objectArray);
        return object;
    }

    private void checkInvalidCache(Method method) {
        if (this.isInvalidCacheMethod(method)) {
            this.refreshCache();
        }
        if (this.isInvalidAllCachesMethod(method)) {
            CacheContainer.getInstance().invalid();
        }
    }

    private class MessageSender
    implements Runnable {
        private MessageSender() {
        }

        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    Message message = (Message)DeltaSkeletonLocalization.this.synchronizedQueue.take();
                    Object[] objectArray = message.getArgs();
                    FRLogger.getLogger().info("SendMessage:" + message.getMethod());
                    if (objectArray == null) {
                        DeltaSkeletonLocalization.this.getRPCClient().perceive(message.getMethod());
                        continue;
                    }
                    DeltaSkeletonLocalization.this.getRPCClient().perceive(message.getMethod(), objectArray);
                }
                catch (Exception exception) {
                    FRLogger.getLogger().info(exception.getMessage());
                }
            }
        }
    }

    private class Message {
        private Method method;
        private Object[] args;

        public Message(Method method, Object[] objectArray) {
            this.method = method;
            this.args = objectArray;
        }

        public Method getMethod() {
            return this.method;
        }

        public Object[] getArgs() {
            return this.args;
        }
    }
}

