/*
 * Decompiled with CFR 0.152.
 */
package com.fr.cache.list;

import com.fr.cache.list.MappedByteBufferList;
import com.fr.general.FRLogger;
import com.fr.general.Inter;
import com.fr.general.ManagerFactory;
import com.fr.stable.StableUtils;
import java.io.File;
import java.util.List;

public class MappedByteBufferTable {
    private File diskDirectory = null;
    private transient List[] mappedByteBufferLists = null;
    private int MEM_SIZE = ManagerFactory.getCacheProvider().getMaxMemSize();

    public MappedByteBufferTable(int n) {
        this.mappedByteBufferLists = new MappedByteBufferList[n];
        this.diskDirectory = this.getCacheDirectory();
        int n2 = 0x2FFFFF;
        if (n > 0) {
            n2 = this.MEM_SIZE / n;
        }
        for (int i = 0; i < this.mappedByteBufferLists.length; ++i) {
            String string = "MBB_Column";
            File file = new File(this.diskDirectory, string + "_" + System.currentTimeMillis() + "_" + (int)(Math.random() * 1000.0));
            int n3 = 0;
            while (file.exists()) {
                file = new File(this.diskDirectory, string + "_" + System.currentTimeMillis() + "_" + (int)(Math.random() * 1000.0) + n3);
                ++n3;
            }
            file.deleteOnExit();
            this.mappedByteBufferLists[i] = new MappedByteBufferList(file, n2);
        }
    }

    public int getAssignLength(int n) {
        return this.mappedByteBufferLists[n].size();
    }

    public void addValueAt(int n, Object object) {
        this.mappedByteBufferLists[n].add(object);
    }

    public Object getValueAt(int n, int n2) {
        if (n > this.columnCount() && n >= 0) {
            FRLogger.getLogger().error("Index out of bounds");
            return null;
        }
        return this.mappedByteBufferLists[n].get(n2);
    }

    public int columnCount() {
        return this.mappedByteBufferLists.length;
    }

    public int rowCount() {
        return this.mappedByteBufferLists[0].size();
    }

    public void clear() {
        if (this.mappedByteBufferLists != null) {
            for (int i = 0; i < this.mappedByteBufferLists.length; ++i) {
                if (this.mappedByteBufferLists[i] == null) continue;
                this.mappedByteBufferLists[i].clear();
            }
        }
        System.gc();
        if (this.diskDirectory != null && !StableUtils.deleteFile(this.diskDirectory)) {
            FRLogger.getLogger().error(Inter.getLocText("WARNING-Fail_to_Delete_Cache_File"));
        }
    }

    private File getCacheDirectory() {
        if (this.diskDirectory == null) {
            this.diskDirectory = new File(ManagerFactory.getCacheProvider().getCacheDirectory(), "DATA_" + System.currentTimeMillis() + "_" + (int)(Math.random() * 1000.0));
            int n = 0;
            while (this.diskDirectory.exists()) {
                this.diskDirectory = new File(ManagerFactory.getCacheProvider().getCacheDirectory(), "DATA_" + System.currentTimeMillis() + "_" + (int)(Math.random() * 1000.0) + n);
                ++n;
            }
            StableUtils.mkdirs(this.diskDirectory);
            this.diskDirectory.deleteOnExit();
        }
        return this.diskDirectory;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.clear();
    }
}

