/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base.core;

import com.fr.base.BaseUtils;
import com.fr.base.FRContext;
import com.fr.base.Style;
import com.fr.general.Background;
import com.fr.general.ComparatorUtils;
import com.fr.general.DefaultValues;
import com.fr.general.FRFont;
import java.awt.Color;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;

public class StyleUtils {
    private StyleUtils() {
    }

    public static Style applyCellStyle(Style style, Style style2, Style style3) {
        if (style3 == null) {
            return style3;
        }
        if (style == null) {
            style = Style.DEFAULT_STYLE;
        }
        if (style2 == null) {
            style2 = Style.DEFAULT_STYLE;
        }
        if (!ComparatorUtils.equals(style2.getFormat(), style.getFormat())) {
            style3 = style2.getFormat() == null ? style3.deriveFormat(null) : style3.deriveFormat((Format)style2.getFormat().clone());
        }
        if (!ComparatorUtils.equals(style2.getFRFont(), style.getFRFont())) {
            FRFont fRFont = style2.getFRFont();
            FRFont fRFont2 = style.getFRFont();
            if (fRFont == null) {
                style3 = style3.deriveFRFont(null);
            } else if (fRFont2 == null) {
                style3 = style3.deriveFRFont(fRFont);
            } else {
                if (!ComparatorUtils.equals(fRFont.getFontName(), fRFont2.getFontName())) {
                    style3 = StyleUtils.setReportFontName(style3, fRFont.getFontName());
                }
                if (fRFont.getStyle() != fRFont2.getStyle()) {
                    style3 = StyleUtils.setReportFontStyle(style3, fRFont.getStyle());
                }
                if (fRFont.getSize() != fRFont2.getSize()) {
                    style3 = StyleUtils.setReportFontSize(style3, fRFont.getSize2D());
                }
                if (!ComparatorUtils.equals(fRFont.getForeground(), fRFont2.getForeground())) {
                    style3 = StyleUtils.setReportFontForeground(style3, fRFont.getForeground());
                }
                if (fRFont.getUnderline() != fRFont2.getUnderline()) {
                    style3 = StyleUtils.setReportFontUnderline2(style3, fRFont.getUnderline());
                }
                if (fRFont.isStrikethrough() != fRFont2.isStrikethrough()) {
                    style3 = StyleUtils.setReportFontStrikethrough(style3, fRFont.isStrikethrough());
                }
                if (fRFont.isShadow() != fRFont2.isShadow()) {
                    style3 = StyleUtils.setReportFontShadow(style3, fRFont.isShadow());
                }
                if (fRFont.isSuperscript() != fRFont2.isSuperscript()) {
                    style3 = StyleUtils.setReportSuperscript(style3, fRFont.isSuperscript());
                }
                if (fRFont.isSubscript() != fRFont2.isSubscript()) {
                    style3 = StyleUtils.setReportSubscript(style3, fRFont.isSubscript());
                }
            }
        }
        if (!ComparatorUtils.equals(style2.getBackground(), style.getBackground())) {
            if (style2.getBackground() == null) {
                style3 = style3.deriveBackground(null);
            } else {
                try {
                    style3 = style3.deriveBackground((Background)style2.getBackground().clone());
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    FRContext.getLogger().error(cloneNotSupportedException.getMessage(), cloneNotSupportedException);
                }
            }
        }
        int n = style3.getBorderTop();
        int n2 = style3.getBorderBottom();
        int n3 = style3.getBorderLeft();
        int n4 = style3.getBorderRight();
        Color color = style3.getBorderTopColor();
        Color color2 = style3.getBorderBottomColor();
        Color color3 = style3.getBorderLeftColor();
        Color color4 = style3.getBorderRightColor();
        boolean bl = false;
        if (style2.getBorderTop() != style.getBorderTop()) {
            n = style2.getBorderTop();
            bl = true;
        }
        if (style2.getBorderLeft() != style.getBorderLeft()) {
            n3 = style2.getBorderLeft();
            bl = true;
        }
        if (style2.getBorderBottom() != style.getBorderBottom()) {
            n2 = style2.getBorderBottom();
            bl = true;
        }
        if (style2.getBorderRight() != style.getBorderRight()) {
            n4 = style2.getBorderRight();
            bl = true;
        }
        if (!ComparatorUtils.equals(style2.getBorderTopColor(), style.getBorderTopColor())) {
            color = style2.getBorderTopColor();
            bl = true;
        }
        if (!ComparatorUtils.equals(style2.getBorderLeftColor(), style.getBorderLeftColor())) {
            color3 = style2.getBorderLeftColor();
            bl = true;
        }
        if (!ComparatorUtils.equals(style2.getBorderBottomColor(), style.getBorderBottomColor())) {
            color2 = style2.getBorderBottomColor();
            bl = true;
        }
        if (!ComparatorUtils.equals(style2.getBorderRightColor(), style.getBorderRightColor())) {
            color4 = style2.getBorderRightColor();
            bl = true;
        }
        if (bl) {
            style3 = style3.deriveBorder(n, color, n2, color2, n3, color3, n4, color4);
        }
        if (BaseUtils.getAlignment4Horizontal(style2) != BaseUtils.getAlignment4Horizontal(style)) {
            style3 = style3.deriveHorizontalAlignment(BaseUtils.getAlignment4Horizontal(style2));
        }
        if (style2.getVerticalAlignment() != style.getVerticalAlignment()) {
            style3 = style3.deriveVerticalAlignment(style2.getVerticalAlignment());
        }
        if (style2.getTextStyle() != style.getTextStyle()) {
            style3 = style3.deriveTextStyle(style2.getTextStyle());
        }
        if (style2.getImageLayout() != style.getImageLayout()) {
            style3 = style3.deriveImageLayout(style2.getImageLayout());
        }
        if (style2.getVerticalText() != style.getVerticalText()) {
            style3 = style3.deriveVerticalText(style2.getVerticalText());
        }
        if (style2.getTextDirection() != style.getTextDirection()) {
            style3 = style3.deriveTextDirection(style2.getTextDirection());
        }
        if (style2.getRotation() != style.getRotation()) {
            style3 = style3.deriveRotation(style2.getRotation());
        }
        if (style2.getPaddingLeft() != style.getPaddingLeft()) {
            style3 = style3.derivePaddingLeft(style2.getPaddingLeft());
        }
        if (style2.getPaddingRight() != style.getPaddingRight()) {
            style3 = style3.derivePaddingRight(style2.getPaddingRight());
        }
        if (style2.getSpacingBefore() != style.getSpacingBefore()) {
            style3 = style3.deriveSpacingBefore(style2.getSpacingBefore());
        }
        if (style2.getSpacingAfter() != style.getSpacingAfter()) {
            style3 = style3.deriveSpacingAfter(style2.getSpacingAfter());
        }
        if (style2.getLineSpacing() != style.getLineSpacing()) {
            style3 = style3.deriveLineSpacing(style2.getLineSpacing());
        }
        return style3;
    }

    public static Style setReportFontName(Style style, String string) {
        Cloneable cloneable;
        FRFont fRFont = style.getFRFont();
        if (fRFont == null) {
            cloneable = FRContext.getDefaultValues();
            fRFont = cloneable.getFRFont();
        }
        cloneable = fRFont.applyName(string);
        return style.deriveFRFont((FRFont)cloneable);
    }

    public static Style setReportFontStyle(Style style, int n) {
        Cloneable cloneable;
        FRFont fRFont = style.getFRFont();
        if (fRFont == null) {
            cloneable = FRContext.getDefaultValues();
            fRFont = cloneable.getFRFont();
        }
        cloneable = fRFont.applyStyle(n);
        return style.deriveFRFont((FRFont)cloneable);
    }

    public static Style boldReportFont(Style style) {
        return StyleUtils.innerBoldCellFont(style, true);
    }

    public static Style unBoldReportFont(Style style) {
        return StyleUtils.innerBoldCellFont(style, false);
    }

    private static Style innerBoldCellFont(Style style, boolean bl) {
        FRFont fRFont = style.getFRFont();
        if (fRFont == null) {
            DefaultValues defaultValues = FRContext.getDefaultValues();
            fRFont = defaultValues.getFRFont();
        }
        int n = fRFont.getStyle();
        n = bl ? (n |= 1) : (n &= 0xFFFFFFFE);
        FRFont fRFont2 = fRFont.applyStyle(n);
        return style.deriveFRFont(fRFont2);
    }

    public static Style italicReportFont(Style style) {
        return StyleUtils.innerItalicCellFont(style, true);
    }

    public static Style unItalicReportFont(Style style) {
        return StyleUtils.innerItalicCellFont(style, false);
    }

    private static Style innerItalicCellFont(Style style, boolean bl) {
        FRFont fRFont = style.getFRFont();
        if (fRFont == null) {
            DefaultValues defaultValues = FRContext.getDefaultValues();
            fRFont = defaultValues.getFRFont();
        }
        int n = fRFont.getStyle();
        n = bl ? (n |= 2) : (n &= 0xFFFFFFFD);
        FRFont fRFont2 = fRFont.applyStyle(n);
        return style.deriveFRFont(fRFont2);
    }

    public static Style setReportFontStrikethrough(Style style, boolean bl) {
        FRFont fRFont = style.getFRFont();
        if (fRFont == null) {
            DefaultValues defaultValues = FRContext.getDefaultValues();
            fRFont = defaultValues.getFRFont();
        } else {
            fRFont = fRFont.applyStrikethrough(bl);
        }
        return style.deriveFRFont(fRFont);
    }

    public static Style setReportFontShadow(Style style, boolean bl) {
        FRFont fRFont = style.getFRFont();
        if (fRFont == null) {
            DefaultValues defaultValues = FRContext.getDefaultValues();
            fRFont = defaultValues.getFRFont();
        } else {
            fRFont = fRFont.applyShadow(bl);
        }
        return style.deriveFRFont(fRFont);
    }

    public static Style setReportSuperscript(Style style, boolean bl) {
        FRFont fRFont = style.getFRFont();
        if (fRFont == null) {
            DefaultValues defaultValues = FRContext.getDefaultValues();
            fRFont = defaultValues.getFRFont();
        } else {
            fRFont = fRFont.applySuperscript(bl);
        }
        return style.deriveFRFont(fRFont);
    }

    public static Style setReportSubscript(Style style, boolean bl) {
        FRFont fRFont = style.getFRFont();
        if (fRFont == null) {
            DefaultValues defaultValues = FRContext.getDefaultValues();
            fRFont = defaultValues.getFRFont();
        } else {
            fRFont = fRFont.applySubscript(bl);
        }
        return style.deriveFRFont(fRFont);
    }

    public static Style setReportFontUnderline(Style style, boolean bl) {
        FRFont fRFont = style.getFRFont();
        if (fRFont == null) {
            DefaultValues defaultValues = FRContext.getDefaultValues();
            fRFont = defaultValues.getFRFont();
        } else {
            fRFont = bl ? fRFont.applyUnderline(1) : fRFont.applyUnderline(0);
        }
        return style.deriveFRFont(fRFont);
    }

    public static Style setReportFontUnderline2(Style style, int n) {
        FRFont fRFont = style.getFRFont();
        if (fRFont == null) {
            DefaultValues defaultValues = FRContext.getDefaultValues();
            fRFont = defaultValues.getFRFont();
        } else {
            fRFont = fRFont.applyUnderline(n);
        }
        return style.deriveFRFont(fRFont);
    }

    public static Style setReportFontSize(Style style, float f) {
        Cloneable cloneable;
        FRFont fRFont = style.getFRFont();
        if (fRFont == null) {
            cloneable = FRContext.getDefaultValues();
            fRFont = cloneable.getFRFont();
        }
        cloneable = fRFont.applySize(f);
        return style.deriveFRFont((FRFont)cloneable);
    }

    public static Style setReportFontForeground(Style style, Color color) {
        FRFont fRFont = style.getFRFont();
        if (fRFont == null) {
            DefaultValues defaultValues = FRContext.getDefaultValues();
            fRFont = defaultValues.getFRFont();
        } else {
            fRFont = fRFont.applyForeground(color);
        }
        return style.deriveFRFont(fRFont);
    }

    public static String formatToPattern(Format format) {
        if (format == null) {
            return "";
        }
        if (format instanceof SimpleDateFormat) {
            return ((SimpleDateFormat)format).toPattern();
        }
        if (format instanceof DecimalFormat) {
            return ((DecimalFormat)format).toPattern();
        }
        return "";
    }

    public static String frFontToString(FRFont fRFont) {
        if (fRFont == null) {
            return "";
        }
        return "[" + fRFont.getFamily() + "," + fRFont.getStyleName() + "," + fRFont.getSize() + "]";
    }
}

