/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base;

import com.fr.general.FRLogger;
import com.fr.script.Calculator;
import com.fr.script.CalculatorMap;
import com.fr.stable.DeathCycleException;
import com.fr.stable.FormulaProvider;
import com.fr.stable.ParameterProvider;
import com.fr.stable.UtilEvalError;
import com.fr.stable.script.AbstractNameSpace;
import com.fr.stable.script.CalculatorKey;
import com.fr.stable.script.CalculatorProvider;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ParameterMapNameSpace
extends AbstractNameSpace {
    protected Calculator nativeCalculator = Calculator.createCalculator();
    private CalculatorMap nativeParameterMap;
    private static final CalculatorKey CUR_VAR = CalculatorKey.createKey("CURRENT_VAR");

    public static ParameterMapNameSpace create(ParameterProvider[] parameterProviderArray) {
        return ParameterMapNameSpace.create(CalculatorMap.create(parameterProviderArray));
    }

    public static ParameterMapNameSpace create(Map map) {
        return new ParameterMapNameSpace(map);
    }

    protected ParameterMapNameSpace(Map map) {
        this.nativeParameterMap = CalculatorMap.create(map);
        this.nativeCalculator.pushNameSpace(this);
        this.nativeCalculator.setAttribute(CUR_VAR, new HashSet());
    }

    public Object getVariable(Object object, CalculatorProvider calculatorProvider) {
        Object object2;
        if (object == null) {
            return null;
        }
        Set set = (Set)this.nativeCalculator.getAttribute(CUR_VAR);
        if (set.contains(object.toString())) {
            throw new DeathCycleException("Death cycle exists at calculating " + (String)object);
        }
        set.add(object.toString());
        String string = object.toString();
        if (string.startsWith("$")) {
            string = string.substring(1);
        }
        if ((object2 = this.nativeParameterMap.get(string)) instanceof FormulaProvider) {
            String string2 = ((FormulaProvider)object2).getContent();
            try {
                object2 = this.nativeCalculator.evalValue(string2.substring(1));
            }
            catch (UtilEvalError utilEvalError) {
                FRLogger.getLogger().error("Attention: Parameter formula getVariable", utilEvalError);
                object2 = string2;
            }
            this.nativeParameterMap.put(string, object2);
        }
        set.remove(object.toString());
        return object2;
    }
}

