/*
 * Decompiled with CFR 0.152.
 */
package com.fr.base;

import com.fr.base.FRContext;
import com.fr.base.MailAuthenticator;
import com.fr.base.platform.PlatformProvider;
import com.fr.general.Inter;
import com.fr.json.JSONArray;
import com.fr.json.JSONException;
import com.fr.json.JSONObject;
import com.fr.plugin.ExtraClassManager;
import com.fr.stable.CodeUtils;
import com.fr.stable.StringUtils;
import com.fr.stable.bridge.StableFactory;
import com.fr.stable.fun.EmailProcessor;
import com.fr.stable.fun.FunctionProcessor;
import com.fr.stable.fun.impl.AbstractEmailProcessor;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLable;
import com.fr.stable.xml.XMLableReader;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;

public class EmailManager
implements XMLable {
    private String mailHost = null;
    private String user = null;
    private String password = null;
    private String fromEmailAddress = null;
    private String port = "25";
    private String encryption = "TLS";
    private String contactsTableDataName = null;
    private String contactsNameCol = null;
    private String contactsAddressCol = null;
    private String contactsFullNameCol = null;
    private static final String DEFAULT_NAME = "templateImage";
    private static final int SMTP_LENGTH = 4;
    private transient Properties mailProperties;
    private static EmailManager emailManager = new EmailManager();

    public static EmailManager getInstance() {
        return emailManager;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String string) {
        this.port = string;
    }

    public String getEncryptionMethod() {
        return this.encryption;
    }

    public void setEncryptionMethod(String string) {
        this.encryption = string;
    }

    public String getMailHost() {
        return this.mailHost;
    }

    public void setMailHost(String string) {
        if (string.indexOf("SMTP") != -1) {
            this.mailHost = string;
        } else {
            String string2 = string.toUpperCase();
            int n = string2.indexOf("SMTP");
            this.mailHost = string.length() > n + 4 && n != -1 ? string.replaceAll(string.substring(n, n + 4), string.substring(n, n + 4).toUpperCase()) : string;
        }
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getFromEmailAddress() {
        return this.fromEmailAddress;
    }

    public void setFromEmailAddress(String string) {
        this.fromEmailAddress = string;
    }

    public String getContactsTableDataName() {
        return this.contactsTableDataName;
    }

    public void setContactsTableDataName(String string) {
        this.contactsTableDataName = string;
    }

    public String getContactsNameCol() {
        return this.contactsNameCol;
    }

    public void setContactsNameCol(String string) {
        this.contactsNameCol = string;
    }

    public String getContactsAddressCol() {
        return this.contactsAddressCol;
    }

    public void setContactsAddressCol(String string) {
        this.contactsAddressCol = string;
    }

    public boolean isEmailConfigValid() {
        return StringUtils.isNotBlank(this.user);
    }

    public void sendTestMail(String string) throws MessagingException {
        this.send(string, "Email Test", Inter.getLocText("ReportServerP-Congratulation_Email_Test_Success"));
    }

    public void send(String string, String string2, String string3) throws MessagingException {
        this.send(string, null, null, string2, string3, null);
    }

    public void send(String string, String string2, String string3, String string4) throws MessagingException {
        this.send(string, null, null, null, string2, string3, null, string4, null);
    }

    public void send(String string, String string2, String string3, String string4, String string5, Object object) throws MessagingException {
        this.send(string, string2, string3, null, string4, string5, object, null);
    }

    public void send(String string, String string2, String string3, String string4, String string5, String string6, Object object, Object object2) throws MessagingException {
        this.send(string, string2, string3, string4, string5, string6, object, null, object2);
    }

    private void checkValidate(Message message, String string, String string2, String string3, String string4, String string5, String string6, String string7) throws AddressException, MessagingException {
        if (StringUtils.isNotBlank(string)) {
            message.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)string));
        }
        if (StringUtils.isNotBlank(string2)) {
            message.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)string2));
        }
        if (StringUtils.isNotBlank(string3)) {
            message.setRecipients(Message.RecipientType.BCC, (Address[])InternetAddress.parse((String)string3));
        }
        if (StringUtils.isBlank(string4) && StringUtils.isBlank(string4 = this.fromEmailAddress)) {
            string4 = Inter.getLocText("HTML-Report_Mail_Server");
        }
        try {
            message.setFrom((Address)new InternetAddress(string4, this.encodeContent(this.user)));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            FRContext.getLogger().error(unsupportedEncodingException.getMessage(), unsupportedEncodingException);
            message.setFrom((Address)new InternetAddress(string4));
        }
    }

    private void dealWithAttach(Object object, Multipart multipart) throws MessagingException {
        block6: {
            block5: {
                if (!(object instanceof File)) break block5;
                File file = (File)object;
                if (file == null || !file.exists()) break block6;
                MimeBodyPart mimeBodyPart = new MimeBodyPart();
                FileDataSource fileDataSource = new FileDataSource(file);
                mimeBodyPart.setDataHandler(new DataHandler((DataSource)fileDataSource));
                String string = this.encodeContent(file.getName());
                mimeBodyPart.setFileName(string);
                multipart.addBodyPart((BodyPart)mimeBodyPart);
                break block6;
            }
            if (object instanceof File[]) {
                File[] fileArray = (File[])object;
                for (int i = 0; i < fileArray.length; ++i) {
                    MimeBodyPart mimeBodyPart = new MimeBodyPart();
                    FileDataSource fileDataSource = new FileDataSource(fileArray[i]);
                    mimeBodyPart.setDataHandler(new DataHandler((DataSource)fileDataSource));
                    mimeBodyPart.setFileName(this.encodeContent(fileArray[i].getName()));
                    multipart.addBodyPart((BodyPart)mimeBodyPart);
                }
            } else if (object instanceof String[]) {
                String[] stringArray = (String[])object;
                for (int i = 0; i < stringArray.length; ++i) {
                    MimeBodyPart mimeBodyPart = new MimeBodyPart();
                    FileDataSource fileDataSource = new FileDataSource(stringArray[i]);
                    mimeBodyPart.setDataHandler(new DataHandler((DataSource)fileDataSource));
                    mimeBodyPart.setFileName(stringArray[i]);
                    multipart.addBodyPart((BodyPart)mimeBodyPart);
                }
            }
        }
    }

    private void dealWithMailContentAttach(Object object, MimeMultipart mimeMultipart, String string, String string2) throws MessagingException {
        String string3 = StringUtils.isEmpty(string2) ? "text/html;charset=utf-8" : "text/html;" + string2;
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        String string4 = string;
        if (object instanceof List) {
            int n;
            List list = (List)object;
            for (n = 0; n < list.size(); ++n) {
                string4 = string4 + "<br /> <img src=\"cid:templateImage" + n + "\">";
                mimeBodyPart.setContent((Object)string4, string3);
            }
            mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
            for (n = 0; n < list.size(); ++n) {
                this.addImagePart(mimeMultipart, (File)list.get(n), DEFAULT_NAME + n);
            }
        } else if (object instanceof File) {
            File file = (File)object;
            string4 = string + "<br /> <img src=\"cid:" + DEFAULT_NAME + "\">";
            mimeBodyPart.setContent((Object)string4, string3);
            mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
            this.addImagePart(mimeMultipart, file, DEFAULT_NAME);
        }
    }

    private void addImagePart(MimeMultipart mimeMultipart, File file, String string) throws MessagingException {
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        FileDataSource fileDataSource = new FileDataSource(file);
        mimeBodyPart.setDataHandler(new DataHandler((DataSource)fileDataSource));
        mimeBodyPart.setHeader("Content-ID", "<" + string + ">");
        mimeBodyPart.setFileName(string + ".png");
        mimeBodyPart.setDisposition("inline");
        mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
    }

    public void send(String string, String string2, String string3, String string4, String string5, String string6, Object object, String string7, Object object2) throws MessagingException {
        Address[] addressArray;
        Address[] addressArray2;
        Address[] addressArray3;
        MimeBodyPart mimeBodyPart;
        Properties properties = this.asMailProperties();
        Session session = Session.getInstance((Properties)properties, (Authenticator)new MailAuthenticator(properties.getProperty("mail.user"), properties.getProperty("mail.password")));
        MimeMessage mimeMessage = new MimeMessage(session);
        this.checkValidate((Message)mimeMessage, string, string2, string3, string4, string5, string6, string7);
        mimeMessage.setSubject(this.encodeContent(string5));
        mimeMessage.setSentDate(new Date());
        MimeMultipart mimeMultipart = new MimeMultipart();
        mimeMessage.setContent((Multipart)mimeMultipart);
        if (object2 == null) {
            mimeBodyPart = new MimeBodyPart();
            addressArray3 = StringUtils.isEmpty(string7) ? "text/html;charset=utf-8" : "text/html;" + string7;
            mimeBodyPart.setContent((Object)string6.replaceAll("\\n", "<br>"), (String)addressArray3);
            mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
        } else {
            this.dealWithMailContentAttach(object2, mimeMultipart, string6, string7);
        }
        this.dealWithAttach(object, (Multipart)mimeMultipart);
        mimeMessage.saveChanges();
        mimeBodyPart = session.getTransport("smtp");
        this.connect((Transport)mimeBodyPart);
        addressArray3 = mimeMessage.getRecipients(Message.RecipientType.TO);
        if (addressArray3 == null) {
            addressArray3 = new Address[]{};
        }
        if ((addressArray2 = mimeMessage.getRecipients(Message.RecipientType.CC)) == null) {
            addressArray2 = new Address[]{};
        }
        if ((addressArray = mimeMessage.getRecipients(Message.RecipientType.BCC)) == null) {
            addressArray = new Address[]{};
        }
        Address[] addressArray4 = new Address[addressArray3.length + addressArray2.length + addressArray.length];
        System.arraycopy(addressArray3, 0, addressArray4, 0, addressArray3.length);
        System.arraycopy(addressArray2, 0, addressArray4, addressArray3.length, addressArray2.length);
        System.arraycopy(addressArray, 0, addressArray4, addressArray3.length + addressArray2.length, addressArray.length);
        mimeBodyPart.sendMessage((Message)mimeMessage, addressArray4);
        mimeBodyPart.close();
        FunctionProcessor functionProcessor = ExtraClassManager.getInstance().getFunctionProcessor();
        if (functionProcessor != null) {
            functionProcessor.recordFunction(FunctionProcessor.EMAIL);
        }
    }

    private String encodeContent(String string) {
        EmailProcessor emailProcessor = (EmailProcessor)ExtraClassManager.getInstance().getSingle("EmailProcessor");
        if (emailProcessor != null) {
            return emailProcessor.encodeEmailText(string);
        }
        try {
            return MimeUtility.encodeText((String)string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            FRContext.getLogger().error(unsupportedEncodingException.getMessage());
            return string;
        }
    }

    private void connect(Transport transport) throws MessagingException {
        try {
            transport.connect();
        }
        catch (Exception exception) {
            transport.connect(this.mailHost, this.user, this.password);
        }
    }

    private Properties asMailProperties() {
        if (this.mailProperties == null) {
            this.mailProperties = new Properties();
            EmailProcessor emailProcessor = (EmailProcessor)ExtraClassManager.getInstance().getSingle("EmailProcessor");
            if (emailProcessor == null) {
                emailProcessor = DefaultEmailProcessor.getInstance();
            }
            this.mailProperties.putAll(emailProcessor.loadMailProperties(this.mailHost, this.encryption, this.port, this.fromEmailAddress, this.password));
        }
        return this.mailProperties;
    }

    public void resetMailProperties() {
        this.mailProperties = null;
    }

    public JSONObject createJSON() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("serverName", this.mailHost);
        jSONObject.put("serverPort", this.port);
        jSONObject.put("encryptionMethod", this.encryption);
        jSONObject.put("fromAddress", this.fromEmailAddress);
        jSONObject.put("userName", this.user);
        jSONObject.put("passWord", this.password);
        jSONObject.put("contactsTableDataName", this.contactsTableDataName);
        jSONObject.put("contactsNameCol", this.contactsNameCol);
        jSONObject.put("contactsAddressCol", this.contactsAddressCol);
        jSONObject.put("contactsFullNameCol", this.contactsFullNameCol);
        return jSONObject;
    }

    public JSONArray getAllMailUsers(Boolean bl) {
        PlatformProvider platformProvider = StableFactory.getMarkedObject("PlatformProvider", PlatformProvider.class);
        JSONArray jSONArray = new JSONArray();
        if (platformProvider != null) {
            jSONArray = platformProvider.getAllMailUsers(bl);
        }
        return jSONArray;
    }

    public JSONArray getAllMailUsers() {
        return this.getAllMailUsers(false);
    }

    public Map getAllUsersMap() {
        JSONArray jSONArray = this.getAllMailUsers();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (jSONArray.length() == 0) {
            return hashMap;
        }
        for (int i = 0; i < jSONArray.length(); ++i) {
            try {
                JSONObject jSONObject = jSONArray.getJSONObject(i);
                String string = String.valueOf(jSONObject.get("text"));
                String string2 = String.valueOf(jSONObject.get("value"));
                hashMap.put(string, string2);
                continue;
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return hashMap;
    }

    public String getAddress(String string) {
        return String.valueOf(this.getAllUsersMap().get(string));
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        xMLPrintWriter.startTAG("EmailManager");
        xMLPrintWriter.attr("mailHost", this.getMailHost()).attr("password", CodeUtils.passwordEncode(this.getPassword())).attr("user", this.getUser()).attr("fromEmailAddress", this.getFromEmailAddress()).attr("contactsTableDataName", this.getContactsTableDataName()).attr("contactsNameCol", this.getContactsNameCol()).attr("contactsAddressCol", this.getContactsAddressCol()).attr("contactsFullNameCol", this.getContactsFullNameCol()).attr("port", this.getPort()).attr("encryption", this.getEncryptionMethod());
        xMLPrintWriter.end();
    }

    public void readXML(XMLableReader xMLableReader) {
        if (xMLableReader.isAttr()) {
            String string = xMLableReader.getAttrAsString("mailHost", null);
            if (string != null) {
                this.setMailHost(string);
            }
            if ((string = xMLableReader.getAttrAsString("fromEmailAddress", null)) != null) {
                this.setFromEmailAddress(string);
            }
            if ((string = xMLableReader.getAttrAsString("password", null)) != null) {
                this.setPassword(CodeUtils.passwordDecode(string));
            }
            if ((string = xMLableReader.getAttrAsString("user", null)) != null) {
                this.setUser(string);
            }
            if ((string = xMLableReader.getAttrAsString("contactsTableDataName", null)) != null) {
                this.setContactsTableDataName(string);
            }
            if ((string = xMLableReader.getAttrAsString("contactsNameCol", null)) != null) {
                this.setContactsNameCol(string);
            }
            if ((string = xMLableReader.getAttrAsString("contactsAddressCol", null)) != null) {
                this.setContactsAddressCol(string);
            }
            if ((string = xMLableReader.getAttrAsString("contactsFullNameCol", null)) != null) {
                this.setContactsFullNameCol(string);
            }
            if ((string = xMLableReader.getAttrAsString("port", null)) != null) {
                this.setPort(string);
            }
            if ((string = xMLableReader.getAttrAsString("encryption", null)) != null) {
                this.setEncryptionMethod(string);
            }
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String getContactsFullNameCol() {
        return this.contactsFullNameCol;
    }

    public void setContactsFullNameCol(String string) {
        this.contactsFullNameCol = string;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultEmailProcessor
    extends AbstractEmailProcessor {
        private static DefaultEmailProcessor instance = null;

        public static synchronized DefaultEmailProcessor getInstance() {
            if (instance == null) {
                instance = new DefaultEmailProcessor();
            }
            return instance;
        }

        @Override
        public Map<String, Object> loadMailProperties(String string, String string2, String string3, String string4, String string5) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("mail.smtp.host", string);
            if ("TLS".equalsIgnoreCase(string2)) {
                hashMap.put("mail.smtp.starttls.enable", "true");
            } else if ("SSL".equalsIgnoreCase(string2)) {
                hashMap.put("mail.smtp.socketFactory.port", string3);
                hashMap.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
                hashMap.put("mail.smtp.port", string3);
            }
            hashMap.put("mail.user", string4);
            hashMap.put("mail.password", string5);
            hashMap.put("mail.smtp.port", string3);
            hashMap.put("mail.transport.protocol", "smtp");
            hashMap.put("mail.smtp.auth", "true");
            hashMap.put("mail.smtp.localhost", "127.0.0.1");
            return hashMap;
        }
    }
}

