/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.jce.provider;

import cn.com.infosec.crypto.AsymmetricBlockCipher;
import cn.com.infosec.crypto.CryptoException;
import cn.com.infosec.crypto.Digest;
import cn.com.infosec.crypto.digests.SHA1Digest;
import cn.com.infosec.crypto.digests.SHA224Digest;
import cn.com.infosec.crypto.digests.SHA256Digest;
import cn.com.infosec.crypto.digests.SHA384Digest;
import cn.com.infosec.crypto.digests.SHA512Digest;
import cn.com.infosec.crypto.engines.RSABlindedEngine;
import cn.com.infosec.crypto.params.ParametersWithRandom;
import cn.com.infosec.crypto.signers.PSSSigner;
import cn.com.infosec.jce.provider.RSAUtil;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.PSSParameterSpec;

public class JDKPSSSigner
extends Signature {
    private AsymmetricBlockCipher signer;
    private Digest digest;
    private int saltLength;
    private AlgorithmParameters engineParams;
    private PSSSigner pss;

    protected JDKPSSSigner(String name, AsymmetricBlockCipher signer, Digest digest) {
        super(name);
        this.signer = signer;
        this.digest = digest;
        this.saltLength = digest != null ? digest.getDigestSize() : 20;
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof RSAPublicKey)) {
            throw new InvalidKeyException("Supplied key is not a RSAPublicKey instance");
        }
        this.pss = new PSSSigner(this.signer, this.digest, this.saltLength);
        this.pss.init(false, RSAUtil.generatePublicKeyParameter((RSAPublicKey)publicKey));
    }

    protected void engineInitSign(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException {
        if (!(privateKey instanceof RSAPrivateKey)) {
            throw new InvalidKeyException("Supplied key is not a RSAPrivateKey instance");
        }
        this.pss = new PSSSigner(this.signer, this.digest, this.saltLength);
        this.pss.init(true, new ParametersWithRandom(RSAUtil.generatePrivateKeyParameter((RSAPrivateKey)privateKey), random));
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof RSAPrivateKey)) {
            throw new InvalidKeyException("Supplied key is not a RSAPrivateKey instance");
        }
        this.pss = new PSSSigner(this.signer, this.digest, this.saltLength);
        this.pss.init(true, RSAUtil.generatePrivateKeyParameter((RSAPrivateKey)privateKey));
    }

    protected void engineUpdate(byte b) throws SignatureException {
        this.pss.update(b);
    }

    protected void engineUpdate(byte[] b, int off, int len) throws SignatureException {
        this.pss.update(b, off, len);
    }

    protected byte[] engineSign() throws SignatureException {
        try {
            return this.pss.generateSignature();
        }
        catch (CryptoException e) {
            throw new SignatureException(e.getMessage());
        }
    }

    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        return this.pss.verifySignature(sigBytes);
    }

    protected void engineSetParameter(AlgorithmParameterSpec params) throws InvalidParameterException {
        if (!(params instanceof PSSParameterSpec)) {
            throw new InvalidParameterException("Only PSSParameterSpec supported");
        }
        this.saltLength = ((PSSParameterSpec)params).getSaltLength();
    }

    protected AlgorithmParameters engineGetParameters() {
        if (this.engineParams == null) {
            try {
                this.engineParams = AlgorithmParameters.getInstance("PSS", "INFOSEC");
                this.engineParams.init(new PSSParameterSpec(this.saltLength));
            }
            catch (Exception e) {
                throw new RuntimeException(e.toString());
            }
        }
        return this.engineParams;
    }

    protected void engineSetParameter(String param, Object value) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    protected Object engineGetParameter(String param) {
        throw new UnsupportedOperationException("engineGetParameter unsupported");
    }

    public static class PSSwithRSA
    extends JDKPSSSigner {
        public PSSwithRSA() {
            super("SHA1withRSAandMGF1", new RSABlindedEngine(), null);
        }
    }

    public static class SHA1withRSA
    extends JDKPSSSigner {
        public SHA1withRSA() {
            super("SHA1withRSAandMGF1", new RSABlindedEngine(), new SHA1Digest());
        }
    }

    public static class SHA224withRSA
    extends JDKPSSSigner {
        public SHA224withRSA() {
            super("SHA224withRSAandMGF1", new RSABlindedEngine(), new SHA224Digest());
        }
    }

    public static class SHA256withRSA
    extends JDKPSSSigner {
        public SHA256withRSA() {
            super("SHA256withRSAandMGF1", new RSABlindedEngine(), new SHA256Digest());
        }
    }

    public static class SHA384withRSA
    extends JDKPSSSigner {
        public SHA384withRSA() {
            super("SHA384withRSAandMGF1", new RSABlindedEngine(), new SHA384Digest());
        }
    }

    public static class SHA512withRSA
    extends JDKPSSSigner {
        public SHA512withRSA() {
            super("SHA512withRSAandMGF1", new RSABlindedEngine(), new SHA512Digest());
        }
    }
}

