/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.jce.provider;

import cn.com.infosec.asn1.ASN1InputStream;
import cn.com.infosec.asn1.ASN1OctetString;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.DERBitString;
import cn.com.infosec.asn1.DERNull;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.DERObjectIdentifier;
import cn.com.infosec.asn1.DEROctetString;
import cn.com.infosec.asn1.cryptopro.CryptoProObjectIdentifiers;
import cn.com.infosec.asn1.cryptopro.ECGOST3410NamedCurves;
import cn.com.infosec.asn1.cryptopro.GOST3410PublicKeyAlgParameters;
import cn.com.infosec.asn1.x509.AlgorithmIdentifier;
import cn.com.infosec.asn1.x509.SubjectPublicKeyInfo;
import cn.com.infosec.asn1.x9.X962Parameters;
import cn.com.infosec.asn1.x9.X9ECParameters;
import cn.com.infosec.asn1.x9.X9ECPoint;
import cn.com.infosec.asn1.x9.X9IntegerConverter;
import cn.com.infosec.asn1.x9.X9ObjectIdentifiers;
import cn.com.infosec.crypto.params.ECDomainParameters;
import cn.com.infosec.crypto.params.ECPublicKeyParameters;
import cn.com.infosec.jce.ECGOST3410NamedCurveTable;
import cn.com.infosec.jce.interfaces.ECPointEncoder;
import cn.com.infosec.jce.interfaces.ECPublicKey;
import cn.com.infosec.jce.provider.ECUtil;
import cn.com.infosec.jce.provider.ProviderUtil;
import cn.com.infosec.jce.spec.ECNamedCurveParameterSpec;
import cn.com.infosec.jce.spec.ECParameterSpec;
import cn.com.infosec.jce.spec.ECPublicKeySpec;
import cn.com.infosec.math.ec.ECCurve;
import cn.com.infosec.math.ec.ECPoint;
import java.io.IOException;
import java.math.BigInteger;

public class JCEECPublicKey
implements ECPublicKey,
ECPointEncoder {
    private String algorithm = "EC";
    private ECPoint q;
    private ECParameterSpec ecSpec;
    private boolean withCompression;
    private GOST3410PublicKeyAlgParameters gostParams;

    JCEECPublicKey(String algorithm, JCEECPublicKey key) {
        this.algorithm = algorithm;
        this.q = key.q;
        this.ecSpec = key.ecSpec;
        this.withCompression = key.withCompression;
        this.gostParams = key.gostParams;
    }

    JCEECPublicKey(String algorithm, ECPublicKeySpec spec) {
        this.algorithm = algorithm;
        this.q = spec.getQ();
        if (spec.getParams() != null) {
            this.ecSpec = spec.getParams();
        } else {
            if (this.q.getCurve() == null) {
                ECParameterSpec s = ProviderUtil.getEcImplicitlyCa();
                this.q = s.getCurve().createPoint(this.q.getX().toBigInteger(), this.q.getY().toBigInteger(), false);
            }
            this.ecSpec = null;
        }
    }

    JCEECPublicKey(String algorithm, ECPublicKeyParameters params, ECParameterSpec spec) {
        ECDomainParameters dp = params.getParameters();
        this.algorithm = algorithm;
        this.q = params.getQ();
        this.ecSpec = spec == null ? new ECParameterSpec(dp.getCurve(), dp.getG(), dp.getN(), dp.getH(), dp.getSeed()) : spec;
    }

    JCEECPublicKey(String algorithm, ECPublicKeyParameters params) {
        this.algorithm = algorithm;
        this.q = params.getQ();
        this.ecSpec = null;
    }

    JCEECPublicKey(ECPublicKey key) {
        this.q = key.getQ();
        this.algorithm = key.getAlgorithm();
        this.ecSpec = key.getParameters();
    }

    JCEECPublicKey(String algorithm, ECPoint q, ECParameterSpec ecSpec) {
        this.algorithm = algorithm;
        this.q = q;
        this.ecSpec = ecSpec;
    }

    JCEECPublicKey(SubjectPublicKeyInfo info) {
        if (info.getAlgorithmId().getObjectId().equals(CryptoProObjectIdentifiers.gostR3410_2001)) {
            ASN1OctetString key;
            DERBitString bits = info.getPublicKeyData();
            this.algorithm = "ECGOST3410";
            try {
                ASN1InputStream aIn = new ASN1InputStream(bits.getBytes());
                key = (ASN1OctetString)aIn.readObject();
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("error recovering public key");
            }
            byte[] keyEnc = key.getOctets();
            byte[] x = new byte[32];
            byte[] y = new byte[32];
            int i = 0;
            while (i != y.length) {
                x[i] = keyEnc[31 - i];
                ++i;
            }
            i = 0;
            while (i != x.length) {
                y[i] = keyEnc[63 - i];
                ++i;
            }
            this.gostParams = new GOST3410PublicKeyAlgParameters((ASN1Sequence)info.getAlgorithmId().getParameters());
            ECNamedCurveParameterSpec spec = ECGOST3410NamedCurveTable.getParameterSpec(ECGOST3410NamedCurves.getName(this.gostParams.getPublicKeyParamSet()));
            this.ecSpec = spec;
            this.q = spec.getCurve().createPoint(new BigInteger(1, x), new BigInteger(1, y), false);
        } else {
            int qLength;
            ECCurve curve;
            X962Parameters params = new X962Parameters((DERObject)info.getAlgorithmId().getParameters());
            if (params.isNamedCurve()) {
                DERObjectIdentifier oid = (DERObjectIdentifier)params.getParameters();
                X9ECParameters ecP = ECUtil.getNamedCurveByOid(oid);
                this.ecSpec = new ECNamedCurveParameterSpec(ECUtil.getCurveName(oid), ecP.getCurve(), ecP.getG(), ecP.getN(), ecP.getH(), ecP.getSeed());
                curve = this.ecSpec.getCurve();
            } else if (params.isImplicitlyCA()) {
                this.ecSpec = null;
                curve = ProviderUtil.getEcImplicitlyCa().getCurve();
            } else {
                X9ECParameters ecP = new X9ECParameters((ASN1Sequence)params.getParameters());
                this.ecSpec = new ECParameterSpec(ecP.getCurve(), ecP.getG(), ecP.getN(), ecP.getH(), ecP.getSeed());
                curve = this.ecSpec.getCurve();
            }
            DERBitString bits = info.getPublicKeyData();
            byte[] data = bits.getBytes();
            ASN1OctetString key = new DEROctetString(data);
            if (data[0] == 4 && data[1] == data.length - 2 && (data[2] == 2 || data[2] == 3) && (qLength = new X9IntegerConverter().getByteLength(curve)) >= data.length - 3) {
                try {
                    ASN1InputStream aIn = new ASN1InputStream(data);
                    key = (ASN1OctetString)aIn.readObject();
                }
                catch (IOException ex) {
                    throw new IllegalArgumentException("error recovering public key");
                }
            }
            X9ECPoint derQ = new X9ECPoint(curve, key);
            this.q = derQ.getPoint();
        }
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getFormat() {
        return "X.509";
    }

    public byte[] getEncoded() {
        SubjectPublicKeyInfo info;
        if (this.algorithm.equals("ECGOST3410")) {
            GOST3410PublicKeyAlgParameters params = null;
            params = this.gostParams != null ? this.gostParams : new GOST3410PublicKeyAlgParameters(ECGOST3410NamedCurves.getOID(((ECNamedCurveParameterSpec)this.ecSpec).getName()), CryptoProObjectIdentifiers.gostR3411_94_CryptoProParamSet);
            ECPoint qq = this.getQ();
            ECPoint point = qq.getCurve().createPoint(qq.getX().toBigInteger(), qq.getY().toBigInteger(), false);
            ASN1OctetString p = (ASN1OctetString)new X9ECPoint(point).getDERObject();
            BigInteger bX = this.q.getX().toBigInteger();
            BigInteger bY = this.q.getY().toBigInteger();
            byte[] encKey = new byte[64];
            byte[] val = bX.toByteArray();
            int i = 0;
            while (i != 32) {
                encKey[i] = val[val.length - 1 - i];
                ++i;
            }
            val = bY.toByteArray();
            i = 0;
            while (i != 32) {
                encKey[32 + i] = val[val.length - 1 - i];
                ++i;
            }
            info = new SubjectPublicKeyInfo(new AlgorithmIdentifier(CryptoProObjectIdentifiers.gostR3410_2001, params.getDERObject()), new DEROctetString(encKey));
        } else {
            X962Parameters params = null;
            if (this.ecSpec instanceof ECNamedCurveParameterSpec) {
                DERObjectIdentifier curveOid = ECUtil.getNamedCurveOid(((ECNamedCurveParameterSpec)this.ecSpec).getName());
                params = new X962Parameters(curveOid);
            } else if (this.ecSpec == null) {
                params = new X962Parameters(DERNull.INSTANCE);
            } else {
                ECParameterSpec p = this.ecSpec;
                ECCurve curve = p.getG().getCurve();
                ECPoint generator = curve.createPoint(p.getG().getX().toBigInteger(), p.getG().getY().toBigInteger(), this.withCompression);
                X9ECParameters ecP = new X9ECParameters(p.getCurve(), generator, p.getN(), p.getH(), p.getSeed());
                params = new X962Parameters(ecP);
            }
            ECCurve curve = this.engineGetQ().getCurve();
            ECPoint point = curve.createPoint(this.getQ().getX().toBigInteger(), this.getQ().getY().toBigInteger(), this.withCompression);
            ASN1OctetString p = (ASN1OctetString)new X9ECPoint(point).getDERObject();
            info = new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, params.getDERObject()), p.getOctets());
        }
        return info.getDEREncoded();
    }

    public ECParameterSpec getParams() {
        return this.ecSpec;
    }

    public ECParameterSpec getParameters() {
        return this.ecSpec;
    }

    public ECPoint getQ() {
        if (this.ecSpec == null) {
            if (this.q instanceof ECPoint.Fp) {
                return new ECPoint.Fp(null, this.q.getX(), this.q.getY());
            }
            return new ECPoint.F2m(null, this.q.getX(), this.q.getY());
        }
        return this.q;
    }

    ECPoint engineGetQ() {
        return this.q;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        String nl = System.getProperty("line.separator");
        buf.append("EC Public Key").append(nl);
        buf.append("            X: ").append(this.getQ().getX().toBigInteger().toString(16)).append(nl);
        buf.append("            Y: ").append(this.getQ().getY().toBigInteger().toString(16)).append(nl);
        return buf.toString();
    }

    public void setPointFormat(String style) {
        this.withCompression = !"UNCOMPRESSED".equalsIgnoreCase(style);
    }

    ECParameterSpec engineGetSpec() {
        if (this.ecSpec != null) {
            return this.ecSpec;
        }
        return ProviderUtil.getEcImplicitlyCa();
    }

    public boolean equals(Object o) {
        if (!(o instanceof JCEECPublicKey)) {
            return false;
        }
        JCEECPublicKey other = (JCEECPublicKey)o;
        return this.getQ().equals(other.getQ()) && this.engineGetSpec().equals(other.engineGetSpec());
    }

    public int hashCode() {
        return this.getQ().hashCode() ^ this.engineGetSpec().hashCode();
    }
}

