/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.asn1.isismtt.ocsp;

import cn.com.infosec.asn1.ASN1Encodable;
import cn.com.infosec.asn1.ASN1EncodableVector;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.DEROctetString;
import cn.com.infosec.asn1.DERSequence;
import cn.com.infosec.asn1.x509.AlgorithmIdentifier;

public class CertHash
extends ASN1Encodable {
    private AlgorithmIdentifier hashAlgorithm;
    private byte[] certificateHash;

    public static CertHash getInstance(Object obj) {
        if (obj == null || obj instanceof CertHash) {
            return (CertHash)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new CertHash((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    private CertHash(ASN1Sequence seq) {
        if (seq.size() != 2) {
            throw new IllegalArgumentException("Bad sequence size: " + seq.size());
        }
        this.hashAlgorithm = AlgorithmIdentifier.getInstance(seq.getObjectAt(0));
        this.certificateHash = DEROctetString.getInstance(seq.getObjectAt(1)).getOctets();
    }

    public CertHash(AlgorithmIdentifier hashAlgorithm, byte[] certificateHash) {
        this.hashAlgorithm = hashAlgorithm;
        this.certificateHash = new byte[certificateHash.length];
        System.arraycopy(certificateHash, 0, this.certificateHash, 0, certificateHash.length);
    }

    public AlgorithmIdentifier getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public byte[] getCertificateHash() {
        return this.certificateHash;
    }

    public DERObject toASN1Object() {
        ASN1EncodableVector vec = new ASN1EncodableVector();
        vec.add(this.hashAlgorithm);
        vec.add(new DEROctetString(this.certificateHash));
        return new DERSequence(vec);
    }
}

