/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.swxa;

import cn.com.infosec.netsign.logger.ConsoleLogger;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SWXAUtil {
    public static KeyPair getHsmKeyPair(String keyLable, String pro) {
        KeyPairGenerator kpg = null;
        try {
            kpg = KeyPairGenerator.getInstance("RSA", pro);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (NoSuchProviderException e) {
            e.printStackTrace();
        }
        int keynum = 0;
        Pattern p = Pattern.compile("([a-zA-Z]{3,4})(\\d{1,2}$)");
        Matcher m = p.matcher(keyLable);
        if (m.matches()) {
            keynum = Integer.parseInt(m.group(2));
            String tmpstr = m.group(1);
            if ("Sign".equals(tmpstr)) {
                keynum = keynum * 2 - 1;
            } else if ("Enc".equals(tmpstr)) {
                keynum *= 2;
            }
            kpg.initialize(keynum << 16);
            KeyPair kp = kpg.genKeyPair();
            if (kp == null) {
                ConsoleLogger.logStringForce((String)"Generate keypair failed in genP10inHsm");
                return null;
            }
            return kp;
        }
        ConsoleLogger.logStringForce((String)"The key lable does not start with Sign or Enc and ends with number");
        return null;
    }

    public static X509Certificate getCertificate(String keyLable) {
        return SWXAUtil.getCertificate("", keyLable);
    }

    public static X509Certificate getCertificate(String basePath, String keyLable) {
        String file = String.valueOf(basePath) + "cert/tokencert/" + keyLable + ".cer";
        CertificateFactory cf = null;
        try {
            cf = CertificateFactory.getInstance("X.509", "INFOSEC");
        }
        catch (CertificateException e) {
            ConsoleLogger.logException((Throwable)e);
            e.printStackTrace();
        }
        catch (NoSuchProviderException e) {
            e.printStackTrace();
        }
        X509Certificate cert = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
        }
        catch (FileNotFoundException e1) {
            ConsoleLogger.logException((Throwable)e1);
            e1.printStackTrace();
        }
        try {
            try {
                cert = (X509Certificate)cf.generateCertificate(fis);
            }
            catch (CertificateException e) {
                e.printStackTrace();
                try {
                    fis.close();
                }
                catch (IOException e2) {
                    ConsoleLogger.logException((Throwable)e2);
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException e) {
                ConsoleLogger.logException((Throwable)e);
                e.printStackTrace();
            }
        }
        return cert;
    }
}

