/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.pkcs;

import cn.com.infosec.netsign.asn1.util.DerUtil;
import cn.com.infosec.pkcs.IssuerAndSerialNumber;
import cn.com.infosec.pkcs.Item;

public class SignerInfo {
    private Item version;
    private Item issuerAndSerialNumber;
    private IssuerAndSerialNumber oIssuerAndSerialNumber;
    private Item digestAlgorithm;
    private Item aaSet;
    private Item aaSequence;
    private Item digestEncryptionAlgorithm;
    private Item encryptedDigest;
    private Item uaSet;
    private Item uaSequence;
    private Item unauthenticatedAttributes;
    private Item authenticatedAttributes;
    private int signerInfoVersion = 0;

    public SignerInfo() {
    }

    public SignerInfo(byte[] input, int offset, int length) {
        this.parse(input, offset, length);
    }

    public SignerInfo(byte[] input, Item it) {
        this.parse(input, it.offset, it.length);
    }

    public final Item getIssuerAndSerialNumber() {
        return this.issuerAndSerialNumber;
    }

    public final Item getIssuerAndSerialNumberObject() {
        return this.issuerAndSerialNumber;
    }

    public final Item getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public final Item getAaSet() {
        return this.aaSet;
    }

    public final Item getAaSequence() {
        return this.aaSequence;
    }

    public final Item getDigestEncryptionAlgorithm() {
        return this.digestEncryptionAlgorithm;
    }

    public final Item getEncryptedDigest() {
        return this.encryptedDigest;
    }

    public final Item getUaSet() {
        return this.uaSet;
    }

    public final Item getUaSequence() {
        return this.uaSequence;
    }

    public final Item getUnauthenticatedAttributes() {
        return this.unauthenticatedAttributes;
    }

    public final Item getAuthenticatedAttributes() {
        return this.authenticatedAttributes;
    }

    public final int getSignerInfoVersion() {
        return this.signerInfoVersion;
    }

    public void parse(byte[] input, int offset, int length) {
        Item tmpitem = new Item();
        int position = 0;
        DerUtil.computeOffset(input, tmpitem, offset, position);
        position = tmpitem.offset;
        DerUtil.computeOffset(input, tmpitem, offset, position);
        position = tmpitem.offset + tmpitem.length;
        tmpitem.offset += offset;
        this.version = new Item(tmpitem);
        this.signerInfoVersion = DerUtil.toInt(input, this.version.offset, this.version.length);
        if (DerUtil.debug) {
            System.out.println("version is " + this.signerInfoVersion);
        }
        DerUtil.computeOffset(input, tmpitem, offset, position);
        position = tmpitem.offset + tmpitem.length;
        tmpitem.offset += offset;
        this.issuerAndSerialNumber = new Item(tmpitem);
        if (DerUtil.debug) {
            System.out.println("issuerAndSerialNumber:");
            DerUtil.printItem(input, this.issuerAndSerialNumber);
        }
        DerUtil.computeOffset(input, tmpitem, offset, position);
        position = tmpitem.offset + tmpitem.length;
        tmpitem.offset += offset;
        this.digestAlgorithm = new Item(tmpitem);
        if (DerUtil.debug) {
            System.out.println("digestAlgorithm:");
            DerUtil.printItem(input, this.digestAlgorithm);
        }
        if (position < length && (input[position + offset] & 0xA0) == 160) {
            DerUtil.computeOffset(input, tmpitem, offset, position);
            position = tmpitem.offset + tmpitem.length;
            tmpitem.offset += offset;
            this.authenticatedAttributes = new Item(tmpitem);
        }
        DerUtil.computeOffset(input, tmpitem, offset, position);
        position = tmpitem.offset + tmpitem.length;
        tmpitem.offset += offset;
        this.digestEncryptionAlgorithm = new Item(tmpitem);
        if (DerUtil.debug) {
            System.out.println("digestEncryptionAlgorithm:");
            DerUtil.printItem(input, this.digestEncryptionAlgorithm);
        }
        if (position + 2 > length) {
            return;
        }
        DerUtil.computeOffset(input, tmpitem, offset, position);
        position = tmpitem.offset + tmpitem.length;
        tmpitem.offset += offset;
        this.encryptedDigest = new Item(tmpitem);
        if (DerUtil.debug) {
            System.out.println("encryptedDigest:");
            DerUtil.printItem(input, this.encryptedDigest);
        }
        if (position + 2 < length && (input[position + offset] & 0xA0) == 161) {
            position = tmpitem.offset + tmpitem.length;
            DerUtil.computeOffset(input, tmpitem, offset, position);
            tmpitem.offset += offset;
            this.unauthenticatedAttributes = new Item(tmpitem);
        }
    }
}

