/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.pkcs;

import cn.com.infosec.asn1.ASN1OctetString;
import cn.com.infosec.asn1.ASN1Set;
import cn.com.infosec.asn1.DERConstructedSequence;
import cn.com.infosec.asn1.DERConstructedSet;
import cn.com.infosec.asn1.DEREncodable;
import cn.com.infosec.asn1.DERInputStream;
import cn.com.infosec.asn1.DERInteger;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.DERObjectIdentifier;
import cn.com.infosec.asn1.DEROctetString;
import cn.com.infosec.asn1.DEROutputStream;
import cn.com.infosec.asn1.DERTaggedObject;
import cn.com.infosec.asn1.pkcs.ContentInfo;
import cn.com.infosec.asn1.pkcs.IssuerAndSerialNumber;
import cn.com.infosec.asn1.pkcs.PKCSObjectIdentifiers;
import cn.com.infosec.asn1.pkcs.SignedData;
import cn.com.infosec.asn1.pkcs.SignerInfo;
import cn.com.infosec.asn1.x509.AlgorithmIdentifier;
import cn.com.infosec.jce.X509Principal;
import cn.com.infosec.netsign.asn1.x509.InfosecCertificate;
import cn.com.infosec.netsign.crypto.util.CryptoUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class PKCS7SignedData
implements PKCSObjectIdentifiers {
    private int version;
    private int signerversion;
    private Set digestalgos;
    private Collection certs;
    private InfosecCertificate signCert;
    private byte[] digest;
    private String digestAlgorithm;
    private String digestEncryptionAlgorithm;
    private byte[] contentData;
    private byte[] signCertTBS;
    DERObject[] certChainEncoded;
    private final String ID_PKCS7_DATA = "1.2.840.113549.1.7.1";
    private final String ID_PKCS7_SIGNED_DATA = "1.2.840.113549.1.7.2";
    private final String ID_SM3 = "1.2.156.197.1.401";
    private final String ID_SM2 = "1.2.156.197.1.301.1";
    private int keyIndex;
    private String passwd;
    private IssuerAndSerialNumber issuerAndSN;

    public PKCS7SignedData(byte[] in) throws SecurityException, CRLException, InvalidKeyException, CertificateException, NoSuchAlgorithmException, IOException {
        DERObject pkcs;
        DERInputStream din = new DERInputStream((InputStream)new ByteArrayInputStream(in));
        try {
            pkcs = din.readObject();
        }
        catch (IOException e) {
            throw new SecurityException("can't decode PKCS7SignedData object");
        }
        if (!(pkcs instanceof DERConstructedSequence)) {
            throw new SecurityException("Not a valid PKCS#7 object - not a sequence");
        }
        ContentInfo content = ContentInfo.getInstance((Object)pkcs);
        if (!content.getContentType().equals((Object)signedData)) {
            throw new SecurityException("Not a valid PKCS#7 signed-data object - wrong header " + content.getContentType().getId());
        }
        SignedData data = SignedData.getInstance((Object)content.getContent());
        this.certs = new ArrayList();
        if (data.getCertificates() != null) {
            Enumeration ec = ASN1Set.getInstance((Object)data.getCertificates()).getObjects();
            while (ec.hasMoreElements()) {
                DERObject certObj = (DERObject)ec.nextElement();
                ByteArrayInputStream bais = new ByteArrayInputStream(certObj.getEncoded());
                this.certs.add(InfosecCertificate.getInstance(bais));
            }
        }
        CryptoUtil.debug("Size of certs:" + this.certs.size());
        this.version = data.getVersion().getValue().intValue();
        ContentInfo dataContentInfo = data.getContentInfo();
        DEREncodable derEnc = dataContentInfo.getContent();
        if (derEnc != null) {
            ASN1OctetString asn1octet = (ASN1OctetString)derEnc;
            this.contentData = asn1octet.getOctets();
        } else {
            this.contentData = null;
        }
        this.digestalgos = new HashSet();
        Enumeration e = data.getDigestAlgorithms().getObjects();
        while (e.hasMoreElements()) {
            DERConstructedSequence s = (DERConstructedSequence)e.nextElement();
            DERObjectIdentifier o = (DERObjectIdentifier)s.getObjectAt(0);
            this.digestalgos.add(o.getId());
        }
        DERConstructedSet signerinfos = (DERConstructedSet)data.getSignerInfos();
        if (signerinfos.getSize() != 1) {
            throw new SecurityException("This PKCS#7 object has multiple SignerInfos - only one is supported at this time");
        }
        SignerInfo signerInfo = SignerInfo.getInstance((Object)signerinfos.getObjectAt(0));
        this.signerversion = signerInfo.getVersion().getValue().intValue();
        IssuerAndSerialNumber isAnds = signerInfo.getIssuerAndSerialNumber();
        BigInteger serialNumber = isAnds.getCertificateSerialNumber().getValue();
        X509Principal issuer = new X509Principal(isAnds.getName());
        Iterator iter = this.certs.iterator();
        while (iter.hasNext()) {
            InfosecCertificate cert = (InfosecCertificate)iter.next();
            if (!serialNumber.equals(cert.getSerialNumber()) || !issuer.toString().equals(cert.getIssuerDNStr())) continue;
            this.signCert = cert;
            break;
        }
        if (this.signCert == null) {
            throw new SecurityException("Can't find signing certificate with  " + issuer + " " + serialNumber.toString(16));
        }
        this.digestAlgorithm = signerInfo.getDigestAlgorithm().getObjectId().getId();
        this.digest = signerInfo.getEncryptedDigest().getOctets();
        this.digestEncryptionAlgorithm = signerInfo.getDigestEncryptionAlgorithm().getObjectId().getId();
        this.signCertTBS = this.signCert.getTBSCertificate();
    }

    public byte[] getSignCertTBS() {
        return this.signCertTBS;
    }

    public PKCS7SignedData(int keyIndex, String passwd, InfosecCertificate[] certChain, DERObject[] certChainEncoded, IssuerAndSerialNumber issuerAndSN) throws SecurityException, InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException {
        this.digestAlgorithm = "1.2.156.197.1.401";
        this.signerversion = 1;
        this.version = 1;
        this.certs = new ArrayList();
        this.digestalgos = new HashSet();
        this.digestalgos.add(this.digestAlgorithm);
        this.signCert = certChain[0];
        int i = 0;
        while (i < certChain.length) {
            this.certs.add(certChain[i]);
            ++i;
        }
        this.certChainEncoded = certChainEncoded;
        this.digestEncryptionAlgorithm = "1.2.156.197.1.301.1";
        this.keyIndex = keyIndex;
        this.passwd = passwd;
        this.issuerAndSN = issuerAndSN;
    }

    public String getDigestAlgorithm() {
        String da = this.digestAlgorithm;
        String dea = this.digestEncryptionAlgorithm;
        if (this.digestAlgorithm.equals("1.2.156.197.1.401")) {
            da = "SM3";
        }
        if (this.digestEncryptionAlgorithm.equals("1.2.156.197.1.301.1")) {
            dea = "ECC";
        }
        return String.valueOf(da) + "/" + dea;
    }

    public InfosecCertificate[] getCertificates() {
        return this.certs.toArray(new InfosecCertificate[0]);
    }

    public InfosecCertificate getSigningCertificate() {
        return this.signCert;
    }

    public int getVersion() {
        return this.version;
    }

    public int getSigningInfoVersion() {
        return this.signerversion;
    }

    public byte[] getContentData() {
        return this.contentData;
    }

    public boolean verify() throws SignatureException {
        return false;
    }

    public byte[] getSignature() {
        return this.digest;
    }

    private DERObject getIssuer(byte[] enc) {
        try {
            DERInputStream in = new DERInputStream((InputStream)new ByteArrayInputStream(enc));
            DERConstructedSequence seq = (DERConstructedSequence)in.readObject();
            return (DERObject)seq.getObjectAt(seq.getObjectAt(0) instanceof DERTaggedObject ? 3 : 2);
        }
        catch (IOException e) {
            throw new Error("IOException reading from ByteArray: " + e);
        }
    }

    public byte[] getEncoded() {
        return this.getEncoded(null);
    }

    public void update(byte[] plainText) {
        this.contentData = plainText;
    }

    public byte[] getEncoded(byte[] _contentData) {
        try {
            DERConstructedSet algos = new DERConstructedSet();
            Iterator i = this.digestalgos.iterator();
            while (i.hasNext()) {
                AlgorithmIdentifier a = new AlgorithmIdentifier(new DERObjectIdentifier((String)i.next()), null);
                algos.addObject((DEREncodable)a);
            }
            DERConstructedSequence contentinfo = new DERConstructedSequence();
            contentinfo.addObject((DEREncodable)new DERObjectIdentifier("1.2.840.113549.1.7.1"));
            if (_contentData != null) {
                DEROctetString octets = new DEROctetString(_contentData);
                DERTaggedObject tagged = new DERTaggedObject(0, (DEREncodable)octets);
                contentinfo.addObject((DEREncodable)tagged);
            }
            DERConstructedSet dercertificates = new DERConstructedSet();
            int i2 = 0;
            int length = this.certChainEncoded.length;
            while (i2 < length) {
                dercertificates.addObject((DEREncodable)this.certChainEncoded[i2]);
                ++i2;
            }
            DERConstructedSequence signerinfo = new DERConstructedSequence();
            signerinfo.addObject((DEREncodable)new DERInteger(this.signerversion));
            signerinfo.addObject((DEREncodable)this.issuerAndSN);
            signerinfo.addObject((DEREncodable)new AlgorithmIdentifier(new DERObjectIdentifier(this.digestAlgorithm), null));
            signerinfo.addObject((DEREncodable)new AlgorithmIdentifier(new DERObjectIdentifier(this.digestEncryptionAlgorithm), null));
            signerinfo.addObject((DEREncodable)new DEROctetString(this.digest));
            DERConstructedSequence body = new DERConstructedSequence();
            body.addObject((DEREncodable)new DERInteger(this.version));
            body.addObject((DEREncodable)algos);
            body.addObject((DEREncodable)contentinfo);
            body.addObject((DEREncodable)new DERTaggedObject(false, 0, (DEREncodable)dercertificates));
            DERConstructedSet signerinfos = new DERConstructedSet();
            signerinfos.addObject((DEREncodable)signerinfo);
            body.addObject((DEREncodable)signerinfos);
            DERConstructedSequence whole = new DERConstructedSequence();
            whole.addObject((DEREncodable)new DERObjectIdentifier("1.2.840.113549.1.7.2"));
            whole.addObject((DEREncodable)new DERTaggedObject(0, (DEREncodable)body));
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            DEROutputStream dout = new DEROutputStream((OutputStream)bOut);
            dout.writeObject((Object)whole);
            dout.close();
            return bOut.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.toString());
        }
    }
}

