/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.oscca.sm2;

import cn.com.infosec.netsign.crypto.util.CryptoUtil;
import cn.com.infosec.netsign.crypto.util.SM3;
import cn.com.infosec.netsign.der.util.DERSegment;
import cn.com.infosec.netsign.der.util.DERUtil;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import cn.com.infosec.oscca.sm2.SM2;
import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.BigIntegers;

public class SM2Util {
    public static final int SM2_SIZE = 32;
    public static final BigInteger gmp = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFF", 16);
    public static final BigInteger gma = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFC", 16);
    public static final BigInteger gmb = new BigInteger("28E9FA9E9D9F5E344D5A9E4BCF6509A7F39789F515AB8F92DDBCBD414D940E93", 16);
    public static final ECCurve gmec256 = new ECCurve.Fp(gmp, gma, gmb);
    public static final BigInteger gmgx = new BigInteger("32C4AE2C1F1981195F9904466A39C9948FE30BBFF2660BE1715A4589334C74C7", 16);
    public static final BigInteger gmgy = new BigInteger("BC3736A2F4F6779C59BDCEE36B692153D0A9877CC62A474002DF32E52139F0A0", 16);
    public static final ECPoint gmg = gmec256.createPoint(gmgx, gmgy, false);
    public static final BigInteger gmn = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFF7203DF6B21C6052B53BBF40939D54123", 16);

    public static byte[] getZA(byte[] id, byte[] pubkey) {
        byte[] msg = new byte[2 + id.length + 192];
        int pos = 0;
        System.arraycopy(SM2Util.getENTLa(id), 0, msg, pos, 2);
        System.arraycopy(id, 0, msg, pos += 2, id.length);
        System.arraycopy(gma.toByteArray(), 0, msg, pos += id.length, 32);
        System.arraycopy(gmb.toByteArray(), 0, msg, pos += 32, 32);
        System.arraycopy(gmgx.toByteArray(), 0, msg, pos += 32, 32);
        System.arraycopy(gmgy.toByteArray(), 0, msg, pos += 32, 32);
        pos += 32;
        if (pubkey.length == 64) {
            System.arraycopy(pubkey, 0, msg, pos, pubkey.length);
        } else if (pubkey.length == 65) {
            System.arraycopy(pubkey, 1, msg, pos, 64);
        } else if (pubkey.length == 33) {
            System.arraycopy(pubkey, 1, msg, pos, 32);
            byte yb = pubkey[0];
            pubkey[0] = 0;
            System.arraycopy(BigIntegers.asUnsignedByteArray((BigInteger)SM2Util.getY(new BigInteger(1, pubkey), yb)), 0, msg, pos += 32, 32);
        }
        CryptoUtil.debug("tbd2", msg);
        return SM3.SM3Digest(msg);
    }

    private static BigInteger getBeta(BigInteger x) {
        BigInteger beta = null;
        BigInteger alpha = x.modPow(new BigInteger("3"), gmp).add(gma.multiply(x)).add(gmb).mod(gmp);
        BigInteger[] rs = gmp.divideAndRemainder(new BigInteger("8"));
        int reminder = rs[1].intValue();
        block0 : switch (reminder) {
            case 1: {
                break;
            }
            case 5: {
                int z = alpha.modPow(rs[0].add(rs[0]).add(BigInteger.ONE), gmp).intValue();
                switch (z) {
                    case 1: {
                        beta = alpha.modPow(rs[0].add(BigInteger.ONE), gmp);
                        break block0;
                    }
                    case -1: {
                        beta = alpha.add(alpha);
                        beta = beta.multiply(beta.add(beta).modPow(rs[0], gmp));
                        break block0;
                    }
                }
                return null;
            }
            case 6: 
            case 7: {
                beta = alpha.modPow(rs[0].add(rs[0]).add(BigInteger.ONE), gmp);
                if (beta.multiply(beta).mod(gmp).compareTo(alpha) == 0) break;
                return null;
            }
        }
        return beta;
    }

    static BigInteger getY(BigInteger x, int ypb) {
        BigInteger y = SM2Util.getBeta(x);
        if (y == null) {
            return null;
        }
        byte[] yb = BigIntegers.asUnsignedByteArray((BigInteger)y);
        if ((yb[yb.length - 1] & 0xFF) == ypb - 2) {
            return y;
        }
        return gmp.add(y.negate());
    }

    public static byte[] point2octect(ECPoint p) {
        byte[] pb = new byte[65];
        pb[0] = 4;
        byte[] tmpib = new byte[32];
        tmpib = BigIntegers.asUnsignedByteArray((BigInteger)p.getX().toBigInteger());
        if (tmpib.length > 32) {
            return null;
        }
        System.arraycopy(tmpib, 0, pb, 33 - tmpib.length, tmpib.length);
        tmpib = BigIntegers.asUnsignedByteArray((BigInteger)p.getY().toBigInteger());
        if (tmpib.length > 32) {
            return null;
        }
        System.arraycopy(tmpib, 0, pb, 65 - tmpib.length, tmpib.length);
        return pb;
    }

    public static void point2octect(ECPoint p, byte[] x, byte[] y) {
        System.arraycopy(BigIntegers.asUnsignedByteArray((BigInteger)p.getX().toBigInteger()), 0, x, 0, 32);
        System.arraycopy(BigIntegers.asUnsignedByteArray((BigInteger)p.getY().toBigInteger()), 0, y, 0, 32);
    }

    public static ECPoint octect2point(byte[] pb) {
        byte[] x = new byte[32];
        byte[] y = new byte[32];
        switch (pb.length) {
            case 33: {
                int px = 1;
                System.arraycopy(pb, px, x, 0, 32);
                BigInteger kx = new BigInteger(1, x);
                BigInteger ky = SM2Util.getY(kx, pb[0]);
                if (ky == null) {
                    return null;
                }
                return gmec256.createPoint(kx, ky, false);
            }
            case 65: {
                int px = 1;
                int py = 33;
                if (pb[0] != 4) {
                    return null;
                }
                System.arraycopy(pb, px, x, 0, 32);
                System.arraycopy(pb, py, y, 0, 32);
                break;
            }
            case 64: {
                int px = 0;
                int py = 32;
                System.arraycopy(pb, px, x, 0, 32);
                System.arraycopy(pb, py, y, 0, 32);
                break;
            }
            default: {
                return null;
            }
        }
        return gmec256.createPoint(new BigInteger(1, x), new BigInteger(1, y), false);
    }

    static byte[] getENTLa(byte[] id) {
        byte[] la = new byte[2];
        int entlena = id.length * 8;
        la[1] = (byte)(entlena & 0xFF);
        la[0] = (byte)(entlena >> 8 & 0xFF);
        return la;
    }

    public static byte[] derEncode(BigInteger r, BigInteger s) {
        byte[] rb = SM2Util.fillBytes(r.toByteArray(), 32);
        rb = DERUtil.generateDERCode((int)2, (byte[])rb);
        byte[] sb = SM2Util.fillBytes(s.toByteArray(), 32);
        sb = DERUtil.generateDERCode((int)2, (byte[])sb);
        byte[] all = DERUtil.connect((byte[])rb, (byte[])sb);
        all = DERUtil.generateDERCode((int)48, (byte[])all);
        return all;
    }

    public static byte[] fillBytes(byte[] src, int length) {
        if (src == null) {
            return null;
        }
        if (src.length >= length) {
            return src;
        }
        byte[] dest = new byte[length];
        System.arraycopy(src, 0, dest, dest.length - src.length, src.length);
        return dest;
    }

    /*
     * Unable to fully structure code
     */
    public static byte[] formatInteger(byte[] src, int baseLength) {
        block3: {
            if (src == null) {
                return null;
            }
            if (!SM2.isIntegerIsUnsignedSignature()) break block3;
            if (src.length > baseLength) ** GOTO lbl9
            return src;
lbl-1000:
            // 1 sources

            {
                tmp = new byte[src.length - 1];
                System.arraycopy(src, 1, tmp, 0, tmp.length);
                src = tmp;
lbl9:
                // 2 sources

                ** while (src[0] == 0 && src.length > baseLength)
            }
lbl10:
            // 1 sources

            return src;
        }
        if (src[0] < 0) {
            tmp = new byte[src.length + 1];
            tmp[0] = 0;
            System.arraycopy(src, 0, tmp, 1, src.length);
            return tmp;
        }
        return src;
    }

    public static BigInteger[] derDecode(byte[] encoding) {
        try {
            ASN1Sequence s = (ASN1Sequence)ASN1Object.fromByteArray((byte[])encoding);
            return new BigInteger[]{((DERInteger)s.getObjectAt(0)).getValue(), ((DERInteger)s.getObjectAt(1)).getValue()};
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] I2OSP(int x) {
        byte[] result = new byte[]{(byte)(x >>> 24), (byte)(x >>> 16), (byte)(x >>> 8), (byte)x};
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public static byte[] formatSignature2Seq(byte[] signed) {
        block7: {
            if (signed == null || signed.length == 0) {
                return signed;
            }
            r = null;
            s = null;
            if (signed.length > 65) ** GOTO lbl14
            r = new byte[32];
            System.arraycopy(signed, 0, r, 0, 32);
            s = new byte[32];
            System.arraycopy(signed, 32, s, 0, 32);
            break block7;
lbl-1000:
            // 1 sources

            {
                tmp = new byte[signed.length - 1];
                System.arraycopy(signed, 1, tmp, 0, tmp.length);
                signed = tmp;
lbl14:
                // 2 sources

                ** while (signed[0] == 0)
            }
lbl15:
            // 1 sources

            if (signed[0] != 48) {
                return signed;
            }
            if (signed[0] == 48 && signed.length == 72) {
                return signed;
            }
            try {
                ds = new DERSegment(signed);
                ds = ds.getInnerDERSegment();
                r = ds.nextDERSegment().getInnerData();
                s = ds.nextDERSegment().getInnerData();
                if (r.length == 32 && s.length == 32) {
                    return signed;
                }
                r = SM2Util.fillBytes(r, 32);
                s = SM2Util.fillBytes(s, 32);
            }
            catch (Exception e) {
                e.printStackTrace();
                return signed;
            }
        }
        r = SM2Util.formatInteger(r, 32);
        s = SM2Util.formatInteger(s, 32);
        rb = DERUtil.generateDERCode((int)2, (byte[])r);
        sb = DERUtil.generateDERCode((int)2, (byte[])s);
        all = DERUtil.connect((byte[])rb, (byte[])sb);
        all = DERUtil.generateDERCode((int)48, (byte[])all);
        return all;
    }

    public static void main(String[] args) {
        SM2.setIntegerIsUnsignedSignature(false);
        byte[] bs = new byte[]{-17, 18, 18, 18, 18, 18, 18, 18};
        bs = SM2Util.formatInteger(bs, 8);
        ConsoleLogger.logBinary((String)"bs", (byte[])bs);
    }
}

