/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.oscca.sm2;

import cn.com.infosec.asn1.ASN1InputStream;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.x509.X509Extensions;
import cn.com.infosec.asn1.x509.X509Name;
import cn.com.infosec.jce.provider.InfosecProvider;
import cn.com.infosec.netsign.crypto.exception.CryptoException;
import cn.com.infosec.netsign.der.util.DERSegment;
import cn.com.infosec.netsign.frame.config.ExtendedConfig;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import cn.com.infosec.oscca.OID;
import cn.com.infosec.oscca.SDFJNI;
import cn.com.infosec.oscca.sm2.SM2PublicKey;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;

public class SM2Certificate
extends X509Certificate
implements Serializable {
    private SM2PublicKey pubk;
    private byte[] pubKeyEncoded;
    private BigInteger sn;
    private Principal issuerSubject;
    private String issuerSubjectStr;
    private Principal subject;
    private String subjectStr;
    private byte[] certEncoded;
    private String sigAlgOID;
    private String sigAlgName;
    private byte[] signature;
    private byte[] tbsCert;
    private Date notBefore;
    private String notBeforeStr;
    private Date notAfter;
    private String notAfterStr;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private X509Certificate x509Cert;
    private String crldp;

    public SM2Certificate(X509Certificate cert, byte[] certEncoded, byte[] tbs) {
        this.x509Cert = cert;
        this.certEncoded = certEncoded;
        this.tbsCert = tbs;
        this.parseTBSCert(this.tbsCert);
        this.signature = this.x509Cert.getSignature();
    }

    public SM2Certificate(InputStream in) throws IOException, CertificateException, NoSuchProviderException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509FX", "INFOSEC");
        this.x509Cert = (X509Certificate)cf.generateCertificate(in);
        this.certEncoded = this.x509Cert.getEncoded();
        this.tbsCert = this.x509Cert.getTBSCertificate();
        this.parseTBSCert(this.tbsCert);
        this.signature = this.x509Cert.getSignature();
    }

    private void parseTBSCert(byte[] tbs) {
        this.sn = this.x509Cert.getSerialNumber();
        this.issuerSubject = this.x509Cert.getIssuerDN();
        this.issuerSubjectStr = this.issuerSubject.toString();
        this.notBefore = this.x509Cert.getNotBefore();
        this.notBeforeStr = this.dateFormat.format(this.notBefore);
        this.notAfter = this.x509Cert.getNotAfter();
        this.notAfterStr = this.dateFormat.format(this.notAfter);
        this.subject = this.x509Cert.getSubjectDN();
        this.subjectStr = this.subject.toString();
        this.sigAlgOID = this.x509Cert.getSigAlgOID();
        this.sigAlgName = OID.getAlgrithmNameByOid(this.sigAlgOID);
        DERSegment seg = new DERSegment(tbs);
        seg = seg.getInnerDERSegment().getDERSegment(6);
        this.pubKeyEncoded = seg.getEncoded();
        this.pubk = new SM2PublicKey(this.pubKeyEncoded);
        this.parseCRLDP();
    }

    private void parseCRLDP() {
        try {
            byte[] ext = this.x509Cert.getExtensionValue(X509Extensions.CRLDistributionPoints.getId());
            if (ext == null) {
                return;
            }
            DERSegment seg = new DERSegment(ext);
            if ((seg = seg.getInnerDERSegment().getInnerDERSegment().getDERSegment(0).getInnerDERSegment().getDERSegment(0).getInnerDERSegment().getDERSegment(0).getInnerDERSegment().getDERSegment(0)).getType() == -92) {
                ASN1InputStream derIn = new ASN1InputStream((InputStream)new ByteArrayInputStream(seg.getInnerData()));
                DERObject derObj = derIn.readObject();
                ASN1Sequence seq = ASN1Sequence.getInstance((Object)derObj);
                X509Name name = new X509Name(seq);
                String crlFullName = name.toString();
                String[] pieces1 = crlFullName.split("CN=");
                String[] pieces2 = pieces1[1].split(",");
                this.crldp = pieces2[0];
            } else if (seg.getType() == -122) {
                this.crldp = new String(seg.getInnerData());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getSigAlgOID() {
        return this.sigAlgOID;
    }

    public String getSigAlgName() {
        return this.sigAlgName;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public byte[] getTBSCertificate() {
        return this.tbsCert;
    }

    public Date getNotBefore() {
        return this.notBefore;
    }

    public String getNotBeforeStr() {
        return this.notBeforeStr;
    }

    public Date getNotAfter() {
        return this.notAfter;
    }

    public String getNotAfterStr() {
        return this.notAfterStr;
    }

    public String getCRLDP() {
        return this.crldp;
    }

    public String getSubjectDNStr() {
        return this.subjectStr;
    }

    public String getIssuerDNStr() {
        return this.issuerSubjectStr;
    }

    public Principal getSubjectDN() {
        return this.subject;
    }

    public PublicKey getPublicKey() {
        return this.pubk;
    }

    public SM2PublicKey getSM2PublicKey() {
        return this.pubk;
    }

    public byte[] getPublicKeyEncoded() {
        return this.pubKeyEncoded;
    }

    public BigInteger getSerialNumber() {
        return this.sn;
    }

    public Principal getIssuerDN() {
        return this.issuerSubject;
    }

    public X509Certificate getX509Cert() {
        return this.x509Cert;
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        return this.certEncoded;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("------------------BEGIN CERTIFICATER------------------\n");
        builder.append("ISSUER:").append(this.issuerSubjectStr).append("\n");
        builder.append("SERIAL NUMBER:").append(this.sn.toString()).append("\n");
        builder.append("SUBJECT:").append(this.subjectStr).append("\n");
        builder.append("NOT BEFORE:").append(this.notBeforeStr).append("\n");
        builder.append("NOT AFTER:").append(this.notAfterStr).append("\n");
        builder.append("-------------------END CERTIFICATER------------------\n");
        return builder.toString();
    }

    public void verify(PublicKey key, String sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        throw new NoSuchAlgorithmException("Can not support SM2");
    }

    private boolean checkCertValidity(long notBefore, long notAfter) {
        if (ExtendedConfig.isCheckCertValidity()) {
            long now = System.currentTimeMillis() / 1000L;
            return notBefore <= now && notAfter >= now;
        }
        return true;
    }

    public void verify(PublicKey key) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        try {
            this.verifyWithID(key, null);
        }
        catch (NoSuchProviderException e) {
            e.printStackTrace();
        }
        catch (CryptoException e) {
            throw new SignatureException(e.toString());
        }
    }

    public void verifyWithID(PublicKey key, byte[] id) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException, NoSuchProviderException, CryptoException {
        if (!(key instanceof SM2PublicKey)) {
            throw new InvalidKeyException("Only SM2PublicKey accept");
        }
        SM2PublicKey sm2k = (SM2PublicKey)key;
        String digestAlg = "SM3";
        if (this.sigAlgOID.equals("1.2.156.197.1.502")) {
            digestAlg = "SHA1";
        }
        if (this.sigAlgOID.equals("1.2.156.197.1.503")) {
            digestAlg = "SHA256";
        }
        try {
            if (!SDFJNI.SM2VierifyWithExternalKey(this.tbsCert, digestAlg, this.signature, sm2k, id)) {
                throw new SignatureException("Certificate verify failed by root public key");
            }
        }
        catch (Exception e) {
            throw new SignatureException("Certificate verify failed by root public key", e);
        }
    }

    public static void main(String[] args) {
        try {
            Security.addProvider((Provider)new InfosecProvider());
            FileInputStream in = new FileInputStream("d:/\u6d4b\u9a8c/5year.cer");
            SM2Certificate cert = new SM2Certificate(in);
            System.out.println("sn:" + cert.getSerialNumber().toString(16));
            System.out.println("issuer:" + cert.getIssuerDNStr());
            System.out.println("notBefore:" + cert.notBeforeStr);
            System.out.println("notAfter:" + cert.notAfterStr);
            System.out.println("alg:" + cert.getSigAlgOID());
            System.out.println("subject:" + cert.subjectStr);
            ConsoleLogger.logBinary((String)"public key", (byte[])cert.getPublicKeyEncoded());
            ConsoleLogger.logBinary((String)"signature", (byte[])cert.signature);
            ConsoleLogger.logString((String)("crldp:" + cert.crldp));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Set getCriticalExtensionOIDs() {
        return this.x509Cert.getCriticalExtensionOIDs();
    }

    public byte[] getExtensionValue(String oid) {
        return this.x509Cert.getExtensionValue(oid);
    }

    public Set getNonCriticalExtensionOIDs() {
        return this.x509Cert.getNonCriticalExtensionOIDs();
    }

    public boolean hasUnsupportedCriticalExtension() {
        return this.x509Cert.hasUnsupportedCriticalExtension();
    }

    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        this.x509Cert.checkValidity();
    }

    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        this.x509Cert.checkValidity(date);
    }

    public int getBasicConstraints() {
        return this.x509Cert.getBasicConstraints();
    }

    public boolean[] getIssuerUniqueID() {
        return this.x509Cert.getIssuerUniqueID();
    }

    public boolean[] getKeyUsage() {
        return this.x509Cert.getKeyUsage();
    }

    public byte[] getSigAlgParams() {
        return null;
    }

    public boolean[] getSubjectUniqueID() {
        return this.x509Cert.getSubjectUniqueID();
    }

    public int getVersion() {
        return this.x509Cert.getVersion();
    }
}

