/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.oscca.sm2;

import cn.com.infosec.netsign.crypto.util.Cache;
import cn.com.infosec.oscca.sm2.SM2Gear;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class SM2Cache
extends Cache {
    private SM2Gear signGear;
    private SM2Gear verifyGear;
    public static final String VERIFY_RESULT_TRUE = "true";
    public static final String VERIFY_RESULT_FALSE = "false";
    public static final String VERIFY_RESULT_NOCACHE = "nocached";

    public SM2Cache(int maxCacheSize, SM2Gear signGear, SM2Gear verifyGear) {
        this.maxCacheSize = maxCacheSize;
        this.signGear = signGear;
        this.verifyGear = verifyGear;
    }

    public void putSignatureResult(byte[] plain, String digestAlg, byte[] D, byte[] signature) {
        byte[] key = this.digestSignature(plain, digestAlg, D);
        if (key != null) {
            this.put(new BigInteger(key), signature);
        }
    }

    public byte[] getSignature(byte[] plain, String digestAlg, byte[] D) {
        byte[] key = this.digestSignature(plain, digestAlg, D);
        if (key == null) {
            return null;
        }
        byte[] sig = (byte[])this.cache.get(new BigInteger(key));
        if (sig == null) {
            return null;
        }
        if (this.signGear.next() == 1) {
            return sig;
        }
        return null;
    }

    public void putVerifyResult(byte[] plain, byte[] signed, byte[] x, byte[] y, String digestAlg, boolean result) {
        byte[] key = this.digestVerify(plain, digestAlg, signed, x, y);
        if (key != null) {
            if (result) {
                this.put(new BigInteger(key), VERIFY_RESULT_TRUE);
            } else {
                this.put(new BigInteger(key), VERIFY_RESULT_FALSE);
            }
        }
    }

    public String getVerifyResult(byte[] plain, byte[] signed, byte[] x, byte[] y, String digestAlg) {
        byte[] key = this.digestVerify(plain, digestAlg, signed, x, y);
        if (key == null) {
            return VERIFY_RESULT_NOCACHE;
        }
        String result = (String)this.cache.get(new BigInteger(key));
        if (result != null) {
            if (this.verifyGear.next() == 1) {
                return result;
            }
            return VERIFY_RESULT_NOCACHE;
        }
        return VERIFY_RESULT_NOCACHE;
    }

    private byte[] digestSignature(byte[] plain, String digestAlg, byte[] D) {
        byte[] algb = digestAlg.getBytes();
        byte[] tmp = new byte[plain.length + algb.length + D.length];
        System.arraycopy(plain, 0, tmp, 0, plain.length);
        System.arraycopy(algb, 0, tmp, plain.length, algb.length);
        System.arraycopy(D, 0, tmp, plain.length + algb.length, D.length);
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            return md.digest(tmp);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    private byte[] digestVerify(byte[] plain, String digestAlg, byte[] signed, byte[] x, byte[] y) {
        byte[] algb = digestAlg.getBytes();
        byte[] tmp = new byte[plain.length + algb.length + signed.length + x.length + y.length];
        int i = 0;
        System.arraycopy(plain, 0, tmp, i, plain.length);
        i = plain.length;
        System.arraycopy(algb, 0, tmp, i, algb.length);
        System.arraycopy(signed, 0, tmp, i += algb.length, signed.length);
        System.arraycopy(x, 0, tmp, i += signed.length, x.length);
        System.arraycopy(y, 0, tmp, i += x.length, y.length);
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            return md.digest(tmp);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

