/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.oscca.sm2;

import cn.com.infosec.jce.provider.InfosecProvider;
import cn.com.infosec.jce.provider.JCESM2PrivateKey;
import cn.com.infosec.jce.provider.JCESM2PublicKey;
import cn.com.infosec.netsign.crypto.util.CryptoUtil;
import cn.com.infosec.oscca.sm2.SM2Util;
import java.math.BigInteger;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import org.apache.xml.security.utils.Base64;
import org.bouncycastle.math.ec.ECAlgorithms;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.BigIntegers;

public class SM2 {
    private static boolean SM2_SIGN_MODE_HARD = false;
    private static boolean SM2_VERIFY_MODE_HARD = false;
    private static String SM2_PROVIDER;
    public static final String SM2_PROVIDER_OSCCAV3 = "osccav3jni";
    private static boolean isCacheSM2;
    private static int sm2CacheSize;
    private static String sm2SignGear;
    private static String sm2VerifyGear;
    private static boolean integerIsUnsignedSignature;
    protected static String cryptoDevice;
    private static final SecureRandom random;

    static {
        isCacheSM2 = false;
        sm2CacheSize = 0;
        integerIsUnsignedSignature = true;
        cryptoDevice = null;
        random = SM2.getRandom();
    }

    public static boolean isIntegerIsUnsignedSignature() {
        return integerIsUnsignedSignature;
    }

    public static void setIntegerIsUnsignedSignature(boolean isUnsigned) {
        integerIsUnsignedSignature = isUnsigned;
    }

    public static boolean isCacheSM2() {
        return isCacheSM2;
    }

    public static void setCacheSM2(boolean isCacheSM2) {
        SM2.isCacheSM2 = isCacheSM2;
    }

    public static int getSm2CacheSize() {
        return sm2CacheSize;
    }

    public static void setSm2CacheSize(int sm2CacheSize) {
        SM2.sm2CacheSize = sm2CacheSize;
    }

    public static String getSm2SignGear() {
        return sm2SignGear;
    }

    public static void setSm2SignGear(String sm2SignGear) {
        SM2.sm2SignGear = sm2SignGear;
    }

    public static String getSm2VerifyGear() {
        return sm2VerifyGear;
    }

    public static void setSm2VerifyGear(String sm2VerifyGear) {
        SM2.sm2VerifyGear = sm2VerifyGear;
    }

    public static void setSM2Provider(String provider) {
        SM2_PROVIDER = provider;
    }

    public static String getSM2Provider() {
        return SM2_PROVIDER;
    }

    public static void setSM2SignModeHard(boolean mode) {
        SM2_SIGN_MODE_HARD = mode;
    }

    public static boolean isSM2SignModeHard() {
        return SM2_SIGN_MODE_HARD;
    }

    public static void setSM2VerifyModeHard(boolean mode) {
        SM2_VERIFY_MODE_HARD = mode;
    }

    public static boolean isSM2VerifyModeHard() {
        return SM2_VERIFY_MODE_HARD;
    }

    public static void setCryptoDevice(String deviceName) {
        cryptoDevice = deviceName;
    }

    public static String getCryptoDevice() {
        return cryptoDevice;
    }

    private static SecureRandom getRandom() {
        SecureRandom random;
        try {
            random = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (Exception exp) {
            random = new SecureRandom();
        }
        return random;
    }

    public static void genKeyPair(byte[] privKey, byte[] pubKeyX, byte[] pubKeyY) {
        ECPoint kg;
        BigInteger k = null;
        int nBitLength = SM2Util.gmn.bitLength();
        do {
            k = new BigInteger(nBitLength, random);
        } while ((kg = SM2Util.gmg.multiply(k = k.mod(SM2Util.gmn))).isInfinity());
        byte[] temp = BigIntegers.asUnsignedByteArray((BigInteger)k);
        System.arraycopy(temp, 0, privKey, Math.max(0, 32 - temp.length), Math.min(temp.length, 32));
        temp = BigIntegers.asUnsignedByteArray((BigInteger)kg.getX().toBigInteger());
        System.arraycopy(temp, 0, pubKeyX, Math.max(0, 32 - temp.length), Math.min(temp.length, 32));
        temp = BigIntegers.asUnsignedByteArray((BigInteger)kg.getY().toBigInteger());
        System.arraycopy(temp, 0, pubKeyY, Math.max(0, 32 - temp.length), Math.min(temp.length, 32));
    }

    public static boolean checkKeyPair(byte[] privKey, byte[] pubKeyX, byte[] pubKeyY) {
        if ((0xFF & privKey[0]) > 121) {
            byte[] tmp = new byte[privKey.length + 1];
            tmp[0] = 0;
            System.arraycopy(privKey, 0, tmp, 1, privKey.length);
            privKey = tmp;
        }
        CryptoUtil.debug(privKey);
        CryptoUtil.debug(pubKeyX);
        CryptoUtil.debug(pubKeyY);
        BigInteger k = new BigInteger(privKey);
        ECPoint kg = SM2Util.gmg.multiply(k);
        byte[] x = new byte[32];
        byte[] y = new byte[32];
        byte[] temp = BigIntegers.asUnsignedByteArray((BigInteger)kg.getX().toBigInteger());
        System.arraycopy(temp, 0, x, Math.max(0, 32 - temp.length), Math.min(temp.length, 32));
        if (!Arrays.equals(x, pubKeyX)) {
            return false;
        }
        temp = BigIntegers.asUnsignedByteArray((BigInteger)kg.getY().toBigInteger());
        System.arraycopy(temp, 0, y, Math.max(0, 32 - temp.length), Math.min(temp.length, 32));
        return Arrays.equals(y, pubKeyY);
    }

    public static byte[] signHash(byte[] msg_hash, byte[] privkey) {
        BigInteger k;
        BigInteger d;
        if (msg_hash.length != 32 || privkey.length != 32) {
            return null;
        }
        BigInteger e = new BigInteger(1, msg_hash);
        BigInteger r = null;
        BigInteger s = null;
        do {
            ECPoint p;
            BigInteger x;
            k = null;
            int nBitLength = SM2Util.gmn.bitLength();
            while ((k = new BigInteger(nBitLength, random)).equals(BigInteger.ZERO) || k.compareTo(SM2Util.gmn) >= 0 || (r = (x = (p = SM2Util.gmg.multiply(k)).getX().toBigInteger()).mod(SM2Util.gmn)).equals(BigInteger.ZERO) || e.add(r).compareTo(SM2Util.gmn) == 0) {
            }
            d = new BigInteger(1, privkey);
            r = e.add(r).mod(SM2Util.gmn);
        } while ((s = BigInteger.ONE.add(d).modInverse(SM2Util.gmn).multiply(k.add(d.multiply(r).negate())).mod(SM2Util.gmn)).equals(BigInteger.ZERO));
        try {
            return SM2Util.derEncode(r, s);
        }
        catch (Exception expDerEncode) {
            return null;
        }
    }

    private static boolean verifyHash(byte[] msg_hash, byte[] r, byte[] s, byte[] x, byte[] y) {
        byte[] signature = new byte[64];
        System.arraycopy(r, 0, signature, 0, 32);
        System.arraycopy(s, 0, signature, 32, 32);
        byte[] pubkey = new byte[65];
        pubkey[0] = 4;
        System.arraycopy(x, 0, pubkey, 1, 32);
        System.arraycopy(y, 0, pubkey, 33, 32);
        return SM2.verifyHash(msg_hash, signature, pubkey);
    }

    public static boolean verifyHash(byte[] msg_hash, byte[] signature, byte[] pubkey) {
        if (msg_hash.length != 32) {
            System.out.println("msg_hash length is wrong!");
            return false;
        }
        if (signature.length != 64 && signature.length != 65 && signature.length < 69) {
            System.out.println("signatuer length is wrong!\nsignature length=" + signature.length);
            return false;
        }
        if (pubkey.length != 64 && pubkey.length != 65) {
            System.out.println("public key length is wrong!");
            return false;
        }
        BigInteger e = new BigInteger(1, msg_hash);
        BigInteger r = null;
        BigInteger s = null;
        if (signature.length >= 69) {
            try {
                BigInteger[] rs = SM2Util.derDecode(signature);
                r = rs[0];
                s = rs[1];
            }
            catch (Exception expDerDecode) {
                System.out.println("signature structure is wrong!");
                return false;
            }
        } else {
            byte[] signpart = new byte[32];
            int pos = 0;
            if (signature[0] == 4 && signature.length == 65) {
                pos = 1;
            }
            System.arraycopy(signature, pos, signpart, 0, 32);
            r = new BigInteger(1, signpart);
            System.arraycopy(signature, pos + 32, signpart, 0, 32);
            s = new BigInteger(1, signpart);
        }
        if (r.compareTo(BigInteger.ONE) < 0 || r.compareTo(SM2Util.gmn) >= 0) {
            System.out.println("Signature's R is wrong!");
            return false;
        }
        if (s.compareTo(BigInteger.ONE) < 0 || s.compareTo(SM2Util.gmn) >= 0) {
            System.out.println("Signature's S is wrong!");
            return false;
        }
        BigInteger t = r.add(s).mod(SM2Util.gmn);
        ECPoint Q = SM2Util.octect2point(pubkey);
        ECPoint xy1 = ECAlgorithms.sumOfTwoMultiplies((ECPoint)SM2Util.gmg, (BigInteger)s, (ECPoint)Q, (BigInteger)t);
        BigInteger v = xy1.getX().toBigInteger().add(e).mod(SM2Util.gmn);
        if (v.compareTo(r) != 0) {
            System.out.println("public key is wrong!");
            return false;
        }
        return true;
    }

    public static void main0(String[] args) {
        byte[] privKey = new byte[32];
        byte[] pubKeyX = new byte[32];
        byte[] pubKeyY = new byte[32];
        SM2.genKeyPair(privKey, pubKeyX, pubKeyY);
        byte[] msg_hash = new byte[32];
        byte[] sign = new byte[64];
        System.arraycopy(privKey, 0, msg_hash, 0, 32);
        long startTime = System.nanoTime();
        int max = 100;
        int i = 0;
        while (i < max) {
            sign = SM2.signHash(msg_hash, privKey);
            ++i;
        }
        long endTime = System.nanoTime();
        System.out.println(String.valueOf(max) + "\t sign opertation(s) estimated \t" + (endTime - startTime) + " nanoSecond(s) or \t" + (double)(endTime - startTime) * 1.0 / 1.0E9 + " second(s)\n per second has " + (double)max * 1.0E9 / (double)(endTime - startTime) + " op(s)");
        byte[] pubKey = new byte[64];
        System.arraycopy(pubKeyX, 0, pubKey, 0, 32);
        System.arraycopy(pubKeyY, 0, pubKey, 32, 32);
        boolean result = true;
        startTime = System.nanoTime();
        int i2 = 0;
        while (i2 < max) {
            result = SM2.verifyHash(msg_hash, sign, pubKey);
            ++i2;
        }
        endTime = System.nanoTime();
        System.out.println(String.valueOf(max) + "\t verify opertation(s) estimated \t" + (endTime - startTime) + " nanoSecond(s) or \t" + (double)(endTime - startTime) * 1.0 / 1.0E9 + " second(s)\n per second has " + (double)max * 1.0E9 / (double)(endTime - startTime) + " op(s)");
        System.out.println("result is " + result);
    }

    public static void main(String[] args) throws Exception {
        CryptoUtil.debug = true;
        Security.addProvider((Provider)new InfosecProvider());
        String prikb64 = "MIGHAgEAMBMGByqGSM49AgEGCCqBHM9VAYItBG0wawIBAQQgyR5mzm9jzsJCHN7S3eXK1TUg9CUTO1cXTOJEogcrpF2hRANCAARgGunrQQZg6/HCqeSfWSEIw9NFXEpu+mgZ9d/QGmxONNYDFuTXjR7bzgYIfBg/f2F9Am1B5ptmUaO+9wJpKfvi";
        String certb64 = "MIICgTCCAiWgAwIBAgIFEAEnF5kwDAYIKoEcz1UBg3UFADAfMQswCQYDVQQGEwJDTjEQMA4GA1UECgwHQk9DIFNNMjAeFw0xNTAyMjcwNTM5MzRaFw0xNjAyMjcwNTM5MzRaMIGBMQswCQYDVQQGEwJjbjEbMBkGA1UECgwSQ0ZDQSBURVNUIE9DQTEgU00yMREwDwYDVQQLDAhTTTIgVEVTVDEUMBIGA1UECwwLRW50ZXJwcmlzZXMxLDAqBgNVBAMMIzA0MUAzaHVheGlhYmFua0BodWF4aWFiYW5rQDAwMDAwMDAxMFkwEwYHKoZIzj0CAQYIKoEcz1UBgi0DQgAEbU+uCvko6Tgk8of3C+F1s9G8kJROpkZmk0LHA8lMaofK90RglEilF/G3nCBIsp4ZirYh5UFlDE3O1AUkxWVmcaOB6DCB5TAfBgNVHSMEGDAWgBRr/hjaj0I6prhtsy6Igzo0osEw4TBIBgNVHSAEQTA/MD0GCGCBHIbvKgEBMDEwLwYIKwYBBQUHAgEWI2h0dHA6Ly93d3cuY2ZjYS5jb20uY24vdXMvdXMtMTQuaHRtMDcGA1UdHwQwMC4wLKAqoCiGJmh0dHA6Ly91Y3JsLmNmY2EuY29tLmNuL1NNMi9jcmw4NDEuY3JsMAsGA1UdDwQEAwID6DAdBgNVHQ4EFgQUFnsfAFHhRLUs7Flj2vKfq5aWIAQwEwYDVR0lBAwwCgYIKwYBBQUHAwIwDAYIKoEcz1UBg3UFAANIADBFAiAip6MqJzYyzibZjuGuF+lp9Tg87sGtSp9v0CeHycq7lQIhAOCar5cMSLhIwg+T4nBzgAn97rtIHV/jaTj8jh4loHw+";
        X509Certificate cert = CryptoUtil.generateCertificate(certb64.getBytes());
        JCESM2PublicKey pubk = (JCESM2PublicKey)cert.getPublicKey();
        JCESM2PrivateKey prik = new JCESM2PrivateKey(Base64.decode((String)prikb64));
        CryptoUtil.debug(Base64.decode((String)prikb64));
        System.out.println(SM2.checkKeyPair(prik.getD(), pubk.getX(), pubk.getY()));
    }
}

