/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.oscca;

import cn.com.infosec.asn1.ASN1InputStream;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.DEREncodable;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.jce.provider.InfosecProvider;
import cn.com.infosec.jce.provider.JCESM2PublicKey;
import cn.com.infosec.netsign.crypto.util.Base64;
import cn.com.infosec.netsign.crypto.util.CryptoUtil;
import cn.com.infosec.netsign.crypto.util.SM3;
import cn.com.infosec.netsign.der.util.PKCS7SignedData;
import cn.com.infosec.netsign.der.util.PKCS7SignedDataParser;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import cn.com.infosec.oscca.SDFJNI;
import cn.com.infosec.oscca.sm2.SM2;
import cn.com.infosec.oscca.sm2.SM2PrivateKey;
import cn.com.infosec.oscca.sm2.SM2PublicKey;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.math.BigInteger;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

public class TestSDFJNI {
    static int result = 0;

    public static void main(String[] args) throws Exception {
        Security.addProvider((Provider)new InfosecProvider());
        SM2.setSM2SignModeHard(false);
        SM2.setSM2VerifyModeHard(false);
        SDFJNI.init();
        TestSDFJNI.verifySM2Cert();
    }

    private static void testVerify5() throws Exception {
        FileInputStream in = new FileInputStream("d:/TEMP/rdb/TWCert.cer");
        CertificateFactory cf = CertificateFactory.getInstance("X.509", "INFOSEC");
        X509Certificate cert = (X509Certificate)cf.generateCertificate(in);
        SM2PublicKey pubk = new SM2PublicKey(cert.getPublicKey().getEncoded());
        in = new FileInputStream("d:/TEMP/rdb/TWAuthAttrs.ber");
        byte[] plain = new byte[in.available()];
        in.read(plain);
        plain[0] = 49;
        in = new FileInputStream("d:/TEMP/rdb/TWSig.ber");
        byte[] sig = new byte[in.available()];
        in.read(sig);
        boolean rt = SDFJNI.SM2VierifyWithExternalKey(plain, "SM3", sig, pubk, "1234567812345678".getBytes());
        System.out.println(rt);
    }

    private static void testVerifyP10() throws Exception {
        String p10 = "MIHlMIGLAgEAMCsxFzAVBgNVBAMMDnNoYW95bl9zbTJ0ZXN0MRAwDgYDVQQKDAdpbmZvc2VjMFkwEwYHKoZIzj0CAQYIKoEcz1UBgi0DQgAEIwxcJX5E94ZgtvYeih1+H624n12N54kp8hcsBtM/iuqgrptYeu1CatqGVEJRmK8vo1w6jOQE5hxqbLzFVgkzSjAMBggqgRzPVQGDdQUAA0cAMEQCICK4TXD4HCgJj8LlceB1KH1F0BTbr7AoSTr6XcVNw3T9AiAyP3hEHxBGb0+8yyNymWqlckXa/FMEM9ClNOqhQBbhgA==";
        byte[] p10bs = Base64.decode(p10);
    }

    public static void testVerify4() throws Exception {
        String p7 = "MIIE/AYJKoZIhvcNAQcCoIIE7TCCBOkCAQExDjAMBggqgRzPVQGDEQUAMIICXQYJKoZIhvcNAQcBoIICTgSCAko8P3htbCB2ZXJzaW9uPSIxLjAiIGVuY29kaW5nPSJ1dGYtOCI/PjxzaWduRGF0YT48cHJlQ2hlY2s+ZmFsc2U8L3ByZUNoZWNrPjx0cmFuVHlwZT48dHJhbk5hbWU+6L2s6LSmOiA8L3RyYW5OYW1lPjx0cmFuQ29kZT5DQjAwMDE8L3RyYW5Db2RlPjx0cmFuU2hvdz50cnVlPC90cmFuU2hvdz48dGltZXN0YW1wPjEzMzU1NDQwMTIyNTY8L3RpbWVzdGFtcD48L3RyYW5UeXBlPjxmaWVsZHM+PGZpZWxkPjxuYW1lPueZu+W9lUlEPC9uYW1lPjx2YWx1ZT50ZXN0MDAxPC92YWx1ZT48c2hvdz5mYWxzZTwvc2hvdz48L2ZpZWxkPjxmaWVsZD48bmFtZT7ml7bpl7TmiLM8L25hbWU+PHZhbHVlPjIwMDcwOTEyMTIzMDE1PC92YWx1ZT48c2hvdz5mYWxzZTwvc2hvdz48L2ZpZWxkPjxmaWVsZD48bmFtZT7lr7nmlrnotKblj7c8L25hbWU+PHZhbHVlPui0puWPt++8mjEyMzQ1Njc4OTU0NDQ0NDQ0PC92YWx1ZT48c2hvdz50cnVlPC9zaG93PjwvZmllbGQ+PGZpZWxkPjxuYW1lPuS6pOaYk+mHkeminTwvbmFtZT48dmFsdWU+6YeR6aKd77yaNTAwMC4wMDwvdmFsdWU+PHNob3c+dHJ1ZTwvc2hvdz48L2ZpZWxkPjwvZmllbGRzPjwvc2lnbkRhdGE+oIIBxTCCAcEwggFmoAMCAQICBgDqJQOJTzAMBggqgRzPVQGDdQUAMDMxCzAJBgNVBAYTAmNuMRMwEQYDVQQKDApiYW5rY29tbWNhMQ8wDQYDVQQDDAZyb290Y2EwHhcNMTQwNDA0MDcyNjIxWhcNMTkwNDA0MDcyNjIxWjBtMQswCQYDVQQGEwJDTjETMBEGA1UECgwKYm9jY29tLmNvbTERMA8GA1UECwwIQkFOS0NPTU0xEjAQBgNVBAsMCUN1c3RvbWVyczEiMCAGA1UEAwwZNjAxMzA3MTAwMDAwMjQxQFsyMDAwMDAwXTBZMBMGByqGSM49AgEGCCqBHM9VAYItA0IABELfrDJhWlBYttgds63cA7CxSg9qqIgcMJ1qHujFZBq23JFRYS8IicefsJc25sh+JtMjlaMZe6ohmE7srZq7mpOjKjAoMA4GA1UdDwEB/wQEAwIGwDAWBgNVHSUBAf8EDDAKBggrBgEFBQcDAjAMBggqgRzPVQGDdQUAA0cAMEQCIF2zWPBfxGkmFd+07n8lJ5bu1XMlvzAr8+2mGLTsSsp6AiAT1GTrpBcGMeVS7pYzKQQo5oa3ZSta1mECbL+RWj0sujGBqTCBpgIBATA9MDMxCzAJBgNVBAYTAmNuMRMwEQYDVQQKDApiYW5rY29tbWNhMQ8wDQYDVQQDDAZyb290Y2ECBgDqJQOJTzAMBggqgRzPVQGDEQUAMAwGCCqBHM9VAYItBQAERjBEAiBFO3UreVXCDyl8Nw3Jp/aE6dTdFFQXN3dlQb4hCNvxJQIgUVw7p0okC5c+We8FAfRYlQWi5TywXcCYQw/4daYrdYY=";
        PKCS7SignedData p7sd = PKCS7SignedDataParser.parse((byte[])Base64.decode(p7), (String)"INFOSEC");
        byte[] plain = p7sd.getContent();
        ConsoleLogger.logBinary((String)"plain text", (byte[])plain);
        ConsoleLogger.logString((String)new String(plain, "utf-8"));
        byte[] publicKey = p7sd.getSignCert().getPublicKey().getEncoded();
        SM2PublicKey pubk = new SM2PublicKey(publicKey);
        boolean rt = SDFJNI.SM2VierifyWithExternalKey(plain, "SM3", p7sd.getSignature(), pubk, "1234567812345678".getBytes());
        rt = SDFJNI.SM2VierifyWithExternalKey(plain, "SM3", p7sd.getSignature(), pubk, null);
        System.out.println(rt);
    }

    private static void testVerify3() throws Exception {
        String plain = "20131129|671290000017|92013112900167129000001700065559|000000001006512236|564290000010|40404500772000003|RMB6955.00|";
        byte[] plainbytes = plain.getBytes();
        String signedStr = "MEMCIANr8Q3I4CHqFRng1lfzSyPSEH+24Q/wcBD01T2xwoFNAh8ED3uDJsBjLBva1SCsof6XOBc8Pi1zbn+oiAWeP+cK";
        byte[] signed = Base64.decode(signedStr);
        ConsoleLogger.logBinary((String)"signed", (byte[])signed);
        String userCertFile = "D:/TEMP/zdb/cert.cer";
        FileInputStream in = new FileInputStream(userCertFile);
        byte[] bs = new byte[in.available()];
        in.read(bs);
        ByteArrayInputStream bin = new ByteArrayInputStream(Base64.decode(bs));
        CertificateFactory cf = CertificateFactory.getInstance("X.509", "INFOSEC");
        X509Certificate userCert = (X509Certificate)cf.generateCertificate(bin);
        JCESM2PublicKey pubk = (JCESM2PublicKey)userCert.getPublicKey();
        boolean rv = SDFJNI.SM2VierifyWithExternalKey(plainbytes, "SM3", signed, pubk.getEncoded(), "1234567812345678".getBytes());
        System.out.println("verify result :" + rv);
    }

    private static void testGenerateKeyPair() throws Exception {
        byte[] x;
        int i = 0;
        while (true) {
            if ((i + 1) % 100 == 0) {
                System.out.println("generate sm2 key pair " + (i + 1));
            }
            SM2PrivateKey prik = new SM2PrivateKey();
            SM2PublicKey pubk = new SM2PublicKey();
            SDFJNI.generateSM2SignKeyPair(pubk, prik);
            x = pubk.getX();
            if (x[0] == 0) break;
            if (x[31] == 0) {
                System.out.println(i + 1);
                CryptoUtil.debug(x);
            }
            ++i;
        }
        System.out.println(i + 1);
        CryptoUtil.debug(x);
    }

    private static void testAll() throws Exception {
        CryptoUtil.debug = true;
        System.out.println("generate sm2 key pair...");
        SM2PrivateKey prik = new SM2PrivateKey();
        SM2PublicKey pubk = new SM2PublicKey();
        SDFJNI.generateSM2SignKeyPair(pubk, prik);
        CryptoUtil.debug("privatekey", prik.getD());
        CryptoUtil.debug("publickeyx", pubk.getX());
        CryptoUtil.debug("publickeyy", pubk.getY());
        byte[] plainText = "11111111".getBytes();
        byte[] signed = null;
        int i = 1;
        signed = SDFJNI.SM2SignWithExternalKey(plainText, "SM3", prik.getD(), pubk, null);
        CryptoUtil.debug("signed msg", signed);
        JCESM2PublicKey jcePubk = new JCESM2PublicKey(pubk.getEncoded());
        boolean verified = false;
        try {
            verified = SDFJNI.SM2VierifyWithExternalKey(plainText, "SM3", signed, jcePubk.getEncoded(), null);
        }
        catch (Exception e) {
            verified = false;
        }
        if (i++ % 100 == 0) {
            System.out.println(i);
        }
    }

    private static void testVerify2() {
        String plain = "MIIBH6ADAgECAgIdsDAKBggqhkjOPQQDAjA7MQswCQYDVQQGEwJDTjEQMA4GA1UECgwHaW5mb3NlYzEaMBgGA1UEAwwRbGl4aWFuZ2ZlbmdUZXN0Q0EwHhcNMDgxMTAxMDIwMDAwWhcNNDkxMTAxMDIwMDAwWjA7MQswCQYDVQQGEwJDTjEQMA4GA1UECgwHaW5mb3NlYzEaMBgGA1UEAwwRbGl4aWFuZ2ZlbmdUZXN0Q0EwWTATBgcqhkjOPQIBBggqgRyBRQGCLQNCAAR4GTwV+Ea/3tGzEF3D9u67aexouZX4HTcYxo4w1TCgOw1U/EYuqTOR8jOCuDJ+Y2TYTG6t0cKsVpTr4FDLrcaYoxMwETAPBgNVHRMBAf8EBTADAQH/";
        byte[] plainbytes = Base64.decode(plain);
        byte[] hash = SDFJNI.digest(1, plainbytes, plainbytes.length);
        String signedStr = "MEQCIAVfZaLDxWCnfI3u4d8keRP4++ITdC8DEuPuZRNzOCwlAiA/eDDvQV1baixn6g8u3DmVWmUC6NsSJ8Wi6ttlCCXcmg==";
        byte[] signed = Base64.decode(signedStr);
        byte[] r = new byte[32];
        System.arraycopy(signed, 0, r, 0, 32);
        byte[] s = new byte[32];
        System.arraycopy(signed, 32, s, 0, 32);
        String keyStr = "eBk8FfhGv97RsxBdw/buu2nsaLmV+B03GMaOMNUwoDsNVPxGLqkzkfIzgrgyfmNk2ExurdHCrFaU6+BQy63GmA==";
        byte[] key = Base64.decode(keyStr);
        byte[] x = new byte[32];
        System.arraycopy(key, 0, x, 0, 32);
        byte[] y = new byte[32];
        System.arraycopy(key, 32, y, 0, 32);
        int rv = SDFJNI.eccExtVerify(131328, 256, x, y, hash, r, s);
        System.out.println("verify result :" + rv);
    }

    private static void testSM1Encrypt() throws Exception {
        byte[] enced = SDFJNI.SM1Encrypt(257, "1234567890123456".getBytes(), "1111111ldfjpoirewqjoijri1t43refkj".getBytes());
        CryptoUtil.debug("encrypted", enced);
        byte[] plain = SDFJNI.SM1Decrypt(257, "1234567890123456".getBytes(), enced);
        CryptoUtil.debug("decrypted", plain);
    }

    private static void testInternalSM1Encrypt() throws Exception {
        byte[] enced = SDFJNI.internalSM1Encrypt(257, 1, "11111sadflkjfqpoiwkncihooewqhfokjfsiu111".getBytes());
        CryptoUtil.debug("encrypted", enced);
        byte[] plain = SDFJNI.internalSM1Decrypt(257, 1, enced);
        CryptoUtil.debug("decrypted", plain);
    }

    private static byte[] getPubKey(byte[] cert) throws Exception {
        ASN1InputStream in = new ASN1InputStream(cert);
        DERObject derO = in.readObject();
        ASN1Sequence asq = ASN1Sequence.getInstance((Object)derO);
        DEREncodable o6 = asq.getObjectAt(6);
        byte[] bs = o6.getDERObject().getEncoded();
        CryptoUtil.debug("pubk", bs);
        return bs;
    }

    private static void testVerify() {
        byte[] hash = SDFJNI.digest(1, "11111111".getBytes(), 8);
        byte[] signed = SDFJNI.eccSignData(1, hash, hash.length);
        System.out.println("sign return code:" + SDFJNI.getRetureCode());
        byte[] r = new byte[32];
        System.arraycopy(signed, 0, r, 0, 32);
        byte[] s = new byte[32];
        System.arraycopy(signed, 32, s, 0, 32);
        byte[] key = SDFJNI.exportEccSignPublicKey(1);
        byte[] x = new byte[32];
        System.arraycopy(key, 0, x, 0, 32);
        byte[] y = new byte[32];
        System.arraycopy(key, 32, y, 0, 32);
        int rv = SDFJNI.eccExtVerify(131328, 256, x, y, hash, r, s);
        System.out.println("verify result :" + rv);
    }

    private static void testSign() {
        byte[] bs = SDFJNI.digest(1, "11111111".getBytes(), 8);
        bs = SDFJNI.eccSignData(1, bs, bs.length);
        CryptoUtil.debug("sign", bs);
    }

    private static void testDigest() {
        byte[] bs = SDFJNI.digest(1, "11111111".getBytes(), 8);
        CryptoUtil.debug("digest", bs);
    }

    private static void testExportPubKey() {
        byte[] key = SDFJNI.exportEccSignPublicKey(1);
        CryptoUtil.debug("ecc public key", key);
    }

    private static void testConnect() {
        result = SDFJNI.connectDev();
        System.out.println("connect to swcc:" + result);
    }

    private static void testDisConnect() {
        result = SDFJNI.disConnectDev();
        System.out.println("dis connect to swcc:" + result);
    }

    private static void testOpenSession() {
        result = SDFJNI.openSession();
        System.out.println("open session:" + result);
    }

    private static void testCloseSession() {
        result = SDFJNI.closeSession();
        System.out.println("close session:" + result);
    }

    private static void testGetPriKeyAccessRight() {
        result = SDFJNI.getPrivateKeyAccessRight(1, "11111111".getBytes(), 8);
        System.out.println("get private key access right:" + result);
    }

    private static void testReleasePriKeyAccessRight() {
        result = SDFJNI.releasePrivateKeyAccessRight(1);
        System.out.println("realease private key access right:" + result);
    }

    private static void verifySM2Cert() {
        String rootCertFile = "D:/TEMP/sm2ca/ca.cer";
        String userCertFile = "D:/TEMP/sm2ca/user.cer";
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "INFOSEC");
            FileInputStream in = new FileInputStream(userCertFile);
            X509Certificate userCert = (X509Certificate)cf.generateCertificate(in);
            in = new FileInputStream(rootCertFile);
            X509Certificate rootCert = (X509Certificate)cf.generateCertificate(in);
            byte[] tbs = userCert.getTBSCertificate();
            CryptoUtil.debug("tbs", tbs);
            byte[] signature = userCert.getSignature();
            CryptoUtil.debug("signature", signature);
            JCESM2PublicKey jcepubk = (JCESM2PublicKey)rootCert.getPublicKey();
            byte[] pubk = jcepubk.getEncoded();
            CryptoUtil.debug("pubk", pubk);
            boolean result = SDFJNI.SM2VierifyWithExternalKey(tbs, "SM3", signature, pubk, null);
            System.out.println(result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void testSM3() {
        BigInteger id = new BigInteger("414C494345313233405941484F4F2E434F4D", 16);
        byte[] idBs = id.toByteArray();
        BigInteger abGxGy = new BigInteger("787968B4FA32C3FD2417842E73BBFEFF2F3C848B6831D7E0EC65228B3937E49863E4C6D3B23B0C849CF84241484BFE48F61D59A5B16BA06E6E12D1DA27C5249A421DEBD61B62EAB6746434EBC3CC315E32220B3BADD50BDC4C4E6C147FEDD43D0680512BCBB42C07D47349D2153B70C4E5D7FDFCBFA36EA1A85841B9E46E09A2", 16);
        byte[] abGxGyBs = abGxGy.toByteArray();
        BigInteger xy = new BigInteger("0AE4C7798AA0F119471BEE11825BE46202BB79E2A5844495E97C04FF4DF2548A7C0240F88F1CD4E16352A73C17B7F16F07353E53A176D684A9FE0C6BB798E857", 16);
        byte[] xyBs = xy.toByteArray();
        byte[] plain = "message digest".getBytes();
        byte[] tmp = new byte[2 + idBs.length + abGxGyBs.length + xyBs.length];
        System.out.println(tmp.length);
        int entlen = idBs.length * 8;
        byte[] entlenBs = new byte[]{(byte)(0xFF & entlen >> 8), (byte)(0xFF & entlen)};
        int start = 0;
        System.arraycopy(entlenBs, 0, tmp, start, 2);
        System.arraycopy(idBs, 0, tmp, start += 2, idBs.length);
        System.arraycopy(abGxGyBs, 0, tmp, start += idBs.length, abGxGyBs.length);
        System.arraycopy(xyBs, 0, tmp, start += abGxGyBs.length, xyBs.length);
        CryptoUtil.debug("tbd", tmp);
        byte[] digest = SM3.SM3Digest(tmp);
        CryptoUtil.debug("digested", digest);
        tmp = new byte[digest.length + plain.length];
        System.arraycopy(digest, 0, tmp, 0, digest.length);
        System.arraycopy(plain, 0, tmp, digest.length, plain.length);
        CryptoUtil.debug("tbd", tmp);
        digest = SM3.SM3Digest(tmp);
        CryptoUtil.debug("digested", digest);
    }
}

