/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.oscca;

import cn.com.infosec.netsign.base.util.VerifySignatureException;
import cn.com.infosec.netsign.crypto.exception.CryptoException;
import cn.com.infosec.netsign.crypto.util.CryptoUtil;
import cn.com.infosec.netsign.der.util.DERSegment;
import cn.com.infosec.netsign.frame.config.ExtendedConfig;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import cn.com.infosec.oscca.OSCCAMessageDigest;
import cn.com.infosec.oscca.encryption.SM24Enc;
import cn.com.infosec.oscca.encryption.SM4;
import cn.com.infosec.oscca.sm2.SM2;
import cn.com.infosec.oscca.sm2.SM2Cache;
import cn.com.infosec.oscca.sm2.SM2Gear;
import cn.com.infosec.oscca.sm2.SM2PrivateKey;
import cn.com.infosec.oscca.sm2.SM2PublicKey;
import cn.com.infosec.oscca.sm2.SM2Util;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.HashMap;

public final class SDFJNI {
    public static boolean bUseCImpl = false;
    public static final int SM2_PUBLIC_KEY_LEN = 65;
    public static final int SM4_BLOCK_SIZE = 16;
    protected static SM2Cache cache;
    protected static final int RETURN_CODE_OK = 0;
    public static final int ALG_ID_SM3 = 1;
    public static final int ALG_ID_SHA1 = 2;
    public static final int ALG_ID_SHA256 = 4;
    public static final int ALG_ID_SM2_SIGN = 131328;
    protected static final int ALG_ID_SM2_ENCRYPT = 132096;
    protected static final int SGD_SM1_ECB = 257;
    protected static final int SGD_SM1_CBC = 258;
    protected static final int SGD_SM1_CFB = 260;
    protected static final int SGD_SM1_OFB = 264;
    protected static HashMap accessRights;
    private static boolean inited;

    static {
        accessRights = new HashMap();
        inited = false;
        if (SM2.isSM2SignModeHard() || SM2.isSM2VerifyModeHard()) {
            System.loadLibrary("sdfjni");
            Runnable hook = new Runnable(){

                public void run() {
                    try {
                        System.out.println("Destroy the SDF resources");
                        SDFJNI.destroy();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            Runtime rt = Runtime.getRuntime();
            rt.addShutdownHook(new Thread(hook));
        }
        if (!(SM2.isSM2SignModeHard() && SM2.isSM2VerifyModeHard() && !ExtendedConfig.isUsingCImp() || SM2.getSM2Provider() == null)) {
            System.loadLibrary(SM2.getSM2Provider());
        }
        SDFJNI.setIsUseCImp();
        if (SM2.isCacheSM2()) {
            cache = new SM2Cache(SM2.getSm2CacheSize(), new SM2Gear(SM2.getSm2SignGear()), new SM2Gear(SM2.getSm2VerifyGear()));
        }
    }

    public static void init() throws CryptoException {
        if (SM2.isSM2SignModeHard() || SM2.isSM2VerifyModeHard()) {
            SDFJNI.connectDev();
            int result = SDFJNI.getRetureCode();
            if (result != 0) {
                throw new CryptoException("Connect crypto card failed : " + result);
            }
            SDFJNI.openSession();
            result = SDFJNI.getRetureCode();
            if (result != 0) {
                throw new CryptoException("Crypto card open session failed : " + result);
            }
        } else if (SM2.getSM2Provider() != null) {
            SDFJNI.connectDev();
        }
        inited = true;
    }

    static void destroy() {
        if (SM2.isSM2SignModeHard() || SM2.isSM2VerifyModeHard()) {
            Integer[] keyIndexes = accessRights.keySet().toArray(new Integer[0]);
            if (keyIndexes != null) {
                int i = 0;
                int length = keyIndexes.length;
                while (i < length) {
                    SDFJNI.releasePrivateKeyAccessRight(keyIndexes[i]);
                    ++i;
                }
            }
            SDFJNI.closeSession();
            SDFJNI.disConnectDev();
        }
        inited = false;
    }

    public static void generateSM2SignKeyPair(SM2PublicKey pubk, SM2PrivateKey prik) throws CryptoException {
        if (SM2.isSM2SignModeHard() || SM2.isSM2VerifyModeHard()) {
            if (!inited) {
                throw new CryptoException("SM2 model have not initialized");
            }
            byte[] result = SDFJNI.generateExtECCKeyPair(131328);
            if (result.length != 96) {
                throw new CryptoException("Generate SM2 key pair failed");
            }
            byte[] bs = new byte[32];
            System.arraycopy(result, 0, bs, 0, 32);
            pubk.setX(bs);
            bs = new byte[32];
            System.arraycopy(result, 32, bs, 0, 32);
            pubk.setY(bs);
            bs = new byte[32];
            System.arraycopy(result, 64, bs, 0, 32);
            prik.setD(bs);
        } else {
            SM2.genKeyPair(prik.getD(), pubk.getX(), pubk.getY());
        }
    }

    public static byte[] SM2SignWithInnerKey(byte[] plainText, String digestAlg, int keyIndex, String passwd, SM2PublicKey pubk, byte[] id) throws CryptoException, NoSuchAlgorithmException, NoSuchProviderException {
        byte[] signed;
        if (!SM2.isSM2SignModeHard()) {
            throw new NoSuchAlgorithmException("Not supported by soft alg");
        }
        if (!inited) {
            throw new CryptoException("SM2 model have not initialized");
        }
        byte[] digest = SDFJNI.digest(plainText, digestAlg, pubk, id);
        Boolean access = (Boolean)accessRights.get(new Integer(keyIndex));
        Boolean bl = access = access == null ? Boolean.FALSE : access;
        if (!access.booleanValue()) {
            SDFJNI.getAccessRight(keyIndex, passwd);
        }
        if ((signed = SDFJNI.eccSignData(keyIndex, digest, digest.length)) == null || signed.length == 0) {
            throw new CryptoException("Crypto card sign failed :" + SDFJNI.getRetureCode());
        }
        return signed;
    }

    public static byte[] SM2SignWithExternalKey(byte[] plainText, String digestAlg, byte[] D, SM2PublicKey pubk, byte[] id) throws CryptoException, NoSuchAlgorithmException, NoSuchProviderException {
        CryptoUtil.debug("SDFJNI SM2SignWithExternalKey plaintext", plainText);
        CryptoUtil.debug("SDFJNI SM2SignWithExternalKey digestAlg:" + digestAlg);
        CryptoUtil.debug("SDFJNI SM2SignWithExternalKey d", D);
        if (pubk != null) {
            CryptoUtil.debug("SDFJNI SM2SignWithExternalKey pubk", pubk.getEncoded());
        }
        CryptoUtil.debug("SDFJNI SM2SignWithExternalKey id", id);
        if (cache == null) {
            return SDFJNI.SM2SignWithExternalKeyImpl(plainText, digestAlg, D, pubk, id);
        }
        byte[] signed = cache.getSignature(plainText, digestAlg, D);
        if (signed != null) {
            return signed;
        }
        signed = SDFJNI.SM2SignWithExternalKeyImpl(plainText, digestAlg, D, pubk, id);
        cache.putSignatureResult(plainText, digestAlg, D, signed);
        return signed;
    }

    private static byte[] SM2SignWithExternalKeyImpl(byte[] plainText, String digestAlg, byte[] D, SM2PublicKey pubk, byte[] id) throws CryptoException, NoSuchAlgorithmException, NoSuchProviderException {
        if (!inited) {
            throw new CryptoException("SM2 model have not initialized");
        }
        byte[] digest = SDFJNI.digest(plainText, digestAlg, pubk, id);
        if (SM2.isSM2SignModeHard()) {
            byte[] signed = SDFJNI.eccExtSignData(131328, D, digest);
            byte[] r = new byte[32];
            System.arraycopy(signed, signed.length - 64, r, 0, 32);
            byte[] s = new byte[32];
            System.arraycopy(signed, signed.length - 32, s, 0, 32);
            return SM2Util.formatSignature2Seq(SM2Util.derEncode(new BigInteger(r), new BigInteger(s)));
        }
        if (SM2.getSM2Provider() == null) {
            return SM2Util.formatSignature2Seq(SM2.signHash(digest, D));
        }
        if (SM2.getSM2Provider().equals("osccav3jni")) {
            return SM2Util.formatSignature2Seq(SDFJNI.SM3withSM2Sign(digest, D));
        }
        throw new NoSuchProviderException(SM2.getSM2Provider());
    }

    public static boolean SM2VierifyWithExternalKey(byte[] plainText, String digestAlg, byte[] signed, byte[] pubkData, byte[] id) throws VerifySignatureException, NoSuchAlgorithmException, NoSuchProviderException, CryptoException {
        SM2PublicKey pubk = new SM2PublicKey(pubkData);
        return SDFJNI.SM2VierifyWithExternalKey(plainText, digestAlg, signed, pubk, id);
    }

    public static boolean SM2VierifyWithExternalKey(byte[] plainText, String digestAlg, byte[] signed, SM2PublicKey pubk, byte[] id) throws VerifySignatureException, NoSuchAlgorithmException, NoSuchProviderException, CryptoException {
        CryptoUtil.debug("SDFJNI SM2VierifyWithExternalKey plaintext", plainText);
        CryptoUtil.debug("SDFJNI SM2VierifyWithExternalKey signed", signed);
        CryptoUtil.debug("SDFJNI SM2VierifyWithExternalKey digestAlg:" + digestAlg);
        CryptoUtil.debug("SDFJNI SM2VierifyWithExternalKey pubk", pubk.getEncoded());
        CryptoUtil.debug("SDFJNI SM2VierifyWithExternalKey id", id);
        if (cache == null) {
            return SDFJNI.SM2VerifyWithExternalKeyImpl(plainText, digestAlg, signed, pubk, id);
        }
        String result = cache.getVerifyResult(plainText, signed, pubk.getX(), pubk.getY(), digestAlg);
        if (result.equals("nocached")) {
            boolean verified = false;
            try {
                verified = SDFJNI.SM2VerifyWithExternalKeyImpl(plainText, digestAlg, signed, pubk, id);
            }
            catch (Exception e) {
                e.printStackTrace();
                verified = false;
            }
            cache.putVerifyResult(plainText, signed, pubk.getX(), pubk.getY(), digestAlg, verified);
            return verified;
        }
        return result.equals("true");
    }

    private static boolean SM2VerifyWithExternalKeyImpl(byte[] plainText, String digestAlg, byte[] signed, SM2PublicKey pubk, byte[] id) throws VerifySignatureException, NoSuchAlgorithmException, NoSuchProviderException, CryptoException {
        if (!inited) {
            throw new CryptoException("SM2 model have not initialized");
        }
        byte[] digest = SDFJNI.digest(plainText, digestAlg, pubk, id);
        if (SM2.isSM2VerifyModeHard()) {
            signed = SDFJNI.formatSignedMsg(signed);
            byte[] signedr = new byte[32];
            System.arraycopy(signed, 0, signedr, 0, 32);
            byte[] signeds = new byte[32];
            System.arraycopy(signed, 32, signeds, 0, 32);
            int result = SDFJNI.eccExtVerify(131328, 256, pubk.getX(), pubk.getY(), digest, signedr, signeds);
            return result == 0;
        }
        if (SM2.getSM2Provider() == null) {
            signed = SDFJNI.formatSignedMsg(signed);
            byte[] sm2pubk = new byte[64];
            System.arraycopy(pubk.getX(), 0, sm2pubk, 0, 32);
            System.arraycopy(pubk.getY(), 0, sm2pubk, 32, 32);
            ConsoleLogger.logBinary((String)"sm2 verify digest", (byte[])digest);
            ConsoleLogger.logBinary((String)"sm2 verify signed", (byte[])signed);
            ConsoleLogger.logBinary((String)"sm2 verify sm2pubk", (byte[])sm2pubk);
            return SM2.verifyHash(digest, signed, sm2pubk);
        }
        if (SM2.getSM2Provider().equals("osccav3jni")) {
            byte[] sm2pubk = new byte[65];
            sm2pubk[0] = 4;
            System.arraycopy(pubk.getX(), 0, sm2pubk, 1, 32);
            System.arraycopy(pubk.getY(), 0, sm2pubk, 33, 32);
            signed = SM2Util.formatSignature2Seq(signed);
            ConsoleLogger.logBinary((String)"sm2 verify digest", (byte[])digest);
            ConsoleLogger.logBinary((String)"sm2 verify signed", (byte[])signed);
            ConsoleLogger.logBinary((String)"sm2 verify sm2pubk", (byte[])sm2pubk);
            int result = SDFJNI.SM3withSM2Verify(signed, digest, sm2pubk);
            if (result != 0) {
                System.out.println("SM2 verify result:" + result);
                return false;
            }
            return true;
        }
        throw new NoSuchProviderException(SM2.getSM2Provider());
    }

    /*
     * Unable to fully structure code
     */
    private static byte[] formatSignedMsg(byte[] signed) throws VerifySignatureException {
        if (signed.length != 64) ** GOTO lbl6
        return signed;
lbl-1000:
        // 1 sources

        {
            tmp = new byte[signed.length - 1];
            System.arraycopy(signed, 1, tmp, 0, tmp.length);
            signed = tmp;
lbl6:
            // 2 sources

            ** while (signed[0] == 0)
        }
lbl7:
        // 1 sources

        if (signed[0] != 48) {
            throw new VerifySignatureException("Bad signature structon");
        }
        signedf = new byte[64];
        try {
            ds = new DERSegment(signed);
            ds = ds.getInnerDERSegment();
            tmp = ds.nextDERSegment().getInnerData();
            if (tmp.length >= 32) {
                System.arraycopy(tmp, tmp.length - 32, signedf, 0, 32);
            } else {
                System.arraycopy(tmp, 0, signedf, 32 - tmp.length, tmp.length);
            }
            tmp = ds.nextDERSegment().getInnerData();
            if (tmp.length >= 32) {
                System.arraycopy(tmp, tmp.length - 32, signedf, 32, 32);
            } else {
                System.arraycopy(tmp, 0, signedf, 64 - tmp.length, tmp.length);
            }
            return signedf;
        }
        catch (Exception e) {
            throw new VerifySignatureException((Throwable)e);
        }
    }

    public static byte[] digest(byte[] plain, String digestAlg, SM2PublicKey pubk, byte[] id) throws NoSuchAlgorithmException, NoSuchProviderException {
        digestAlg = digestAlg.toUpperCase();
        byte[] digest = null;
        if (digestAlg.startsWith("SM3")) {
            digest = id != null ? OSCCAMessageDigest.SM3Digest(id, pubk.getX(), pubk.getY(), plain) : OSCCAMessageDigest.SM3Digest(null, null, null, plain);
        } else if (digestAlg.startsWith("SHA1") || digestAlg.equals("SHA-1") || digestAlg.startsWith("SHA256") || digestAlg.equals("SHA-256")) {
            digest = id != null ? OSCCAMessageDigest.SHADigest(digestAlg, id, pubk.getX(), pubk.getY(), plain) : OSCCAMessageDigest.SHADigest(digestAlg, null, null, null, plain);
        } else {
            throw new NoSuchAlgorithmException("Can not support " + digestAlg + " except SM3,SHA1,SHA256");
        }
        CryptoUtil.debug("digest result", digest);
        return SDFJNI.paddingDigest(digest, new byte[32]);
    }

    private static byte[] paddingDigest(byte[] src, byte[] dest) {
        if (src == null) {
            return null;
        }
        if (src.length >= dest.length) {
            return src;
        }
        int plength = dest.length - src.length;
        if (plength <= 2) {
            dest[0] = 1;
        } else {
            dest[0] = 1;
            int i = 1;
            int length = plength - 1;
            while (i < length) {
                dest[i] = -1;
                ++i;
            }
        }
        System.arraycopy(src, 0, dest, plength, src.length);
        return dest;
    }

    protected static synchronized byte[] SM3Digest(byte[] plain, byte[] id, SM2PublicKey pubk) throws CryptoException {
        if (!inited) {
            throw new CryptoException("SM2 model have not initialized");
        }
        if (id == null) {
            return SDFJNI.digest(1, plain, plain.length);
        }
        return SDFJNI.digestWithID(1, plain, id, pubk.getX(), pubk.getY());
    }

    private static synchronized void getAccessRight(int keyIndex, String passwd) throws CryptoException {
        if (!inited) {
            throw new CryptoException("SM2 model have not initialized");
        }
        Boolean access = (Boolean)accessRights.get(new Integer(keyIndex));
        Boolean bl = access = access == null ? Boolean.FALSE : access;
        if (!access.booleanValue()) {
            int ret = SDFJNI.getPrivateKeyAccessRight(keyIndex, passwd.getBytes(), passwd.length());
            if (ret != 0) {
                throw new CryptoException("Failed to get private key " + keyIndex + " access rigth:" + ret);
            }
            accessRights.put(new Integer(keyIndex), new Boolean(true));
        }
    }

    private static byte[][] parseKey(byte[] pubk) {
        byte[][] pubkParams = new byte[2][32];
        System.arraycopy(pubk, pubk.length - 64, pubkParams[0], 0, 32);
        System.arraycopy(pubk, pubk.length - 32, pubkParams[1], 0, 32);
        return pubkParams;
    }

    public static byte[] exportPublicKey(int keyIndex) throws CryptoException {
        if (!inited) {
            throw new CryptoException("SM2 model have not initialized");
        }
        return SDFJNI.exportEccSignPublicKey(keyIndex);
    }

    public static native int getRetureCode();

    protected static native int connectDev();

    protected static native int disConnectDev();

    protected static native int openSession();

    protected static native int closeSession();

    protected static native int getPrivateKeyAccessRight(int var0, byte[] var1, int var2);

    protected static native int releasePrivateKeyAccessRight(int var0);

    protected static native byte[] exportEccSignPublicKey(int var0);

    protected static native byte[] eccSignData(int var0, byte[] var1, int var2);

    protected static native int eccExtVerify(int var0, int var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5, byte[] var6);

    protected static native byte[] eccExtSignData(int var0, byte[] var1, byte[] var2);

    protected static native byte[] digest(int var0, byte[] var1, int var2);

    protected static native byte[] digestWithID(int var0, byte[] var1, byte[] var2, byte[] var3, byte[] var4);

    protected static native byte[] internalSM1Encrypt(int var0, int var1, byte[] var2);

    protected static native byte[] internalSM1Decrypt(int var0, int var1, byte[] var2);

    protected static native byte[] SM1Encrypt(int var0, byte[] var1, byte[] var2);

    protected static native byte[] SM1Decrypt(int var0, byte[] var1, byte[] var2);

    protected static native byte[] generateExtECCKeyPair(int var0);

    protected static native byte[] SM3withSM2Sign(byte[] var0, byte[] var1);

    protected static native int SM3withSM2Verify(byte[] var0, byte[] var1, byte[] var2);

    public static byte[] CImpl_SM2Encrypt(byte[] msg, int msgLen, byte[] sm2Pubk, int keyLen) {
        byte[] cipher = null;
        cipher = SDFJNI.cSM2Encrypt(msg, msgLen, sm2Pubk, keyLen);
        return cipher;
    }

    public static byte[] CImpl_SM2Decrypt(byte[] cipher, int cLen, byte[] sm2prik, int keyLen) {
        return SDFJNI.cSM2Decrypt(cipher, cLen, sm2prik, keyLen);
    }

    public static byte[] CImpl_SM4CbcEncrypt(byte[] plain, int pLen, byte[] key, int keyLen, byte[] iv) {
        return SDFJNI.cSM4CbcEncrypt(plain, pLen, key, keyLen, iv);
    }

    public static byte[] CImpl_SM4CbcDecrypt(byte[] cipher, int cLen, byte[] key, int keyLen, byte[] iv) {
        return SDFJNI.cSM4CbcDecrypt(cipher, cLen, key, keyLen, iv);
    }

    protected static native byte[] cSM2Encrypt(byte[] var0, int var1, byte[] var2, int var3);

    protected static native byte[] cSM2Decrypt(byte[] var0, int var1, byte[] var2, int var3);

    protected static native byte[] cSM4CbcEncrypt(byte[] var0, int var1, byte[] var2, int var3, byte[] var4);

    protected static native byte[] cSM4CbcDecrypt(byte[] var0, int var1, byte[] var2, int var3, byte[] var4);

    private static void setIsUseCImp() {
        if (ExtendedConfig.isUsingCImp() && SM2.getSM2Provider() != null) {
            bUseCImpl = true;
        }
    }

    public static byte[] sm2Encrypt(byte[] keyData, byte[] sm2Pubk) {
        byte[] encKey = bUseCImpl ? SDFJNI.CImpl_SM2Encrypt(keyData, keyData.length, sm2Pubk, 65) : SM24Enc.encrypt(keyData, sm2Pubk);
        return encKey;
    }

    public static byte[] sm4Encrypt(byte[] plaindata, int ptLen, byte[] keyData, byte[] iv) {
        byte[] encdata;
        if (bUseCImpl) {
            encdata = SDFJNI.CImpl_SM4CbcEncrypt(plaindata, ptLen, keyData, 16, iv);
        } else {
            int ctLen = ptLen + 16 - ptLen % 16;
            encdata = new byte[ctLen];
            SM4.sm4_cbc_encrypt(plaindata, ptLen, encdata, keyData, 16, iv);
        }
        return encdata;
    }

    public static byte[] sm2Decrypt(byte[] encKey, byte[] sm2prik) {
        byte[] key = null;
        if (bUseCImpl) {
            key = SDFJNI.CImpl_SM2Decrypt(encKey, encKey.length, sm2prik, sm2prik.length);
        } else {
            key = new byte[encKey.length - 97];
            boolean result = SM24Enc.decrypt(encKey, sm2prik, key);
            if (!result) {
                key = null;
            }
        }
        return key;
    }

    public static byte[] sm4Decrypt(byte[] encdata, int encDataLen, byte[] key, byte[] iv) {
        byte[] out = null;
        out = bUseCImpl ? SDFJNI.CImpl_SM4CbcDecrypt(encdata, encDataLen, key, 16, iv) : SM4.sm4_cbc_decrypt(encdata, encDataLen, out, encDataLen, key, 16, iv);
        return out;
    }
}

