/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.oscca;

import cn.com.infosec.asn1.x509.X509Extensions;
import cn.com.infosec.jce.provider.InfosecProvider;
import cn.com.infosec.netsign.crypto.util.CryptoUtil;
import cn.com.infosec.netsign.der.util.Certificate;
import cn.com.infosec.netsign.der.util.CertificateGenerater;
import cn.com.infosec.netsign.der.util.DERUtil;
import cn.com.infosec.netsign.der.util.Extension;
import cn.com.infosec.netsign.der.util.PublicKey;
import cn.com.infosec.oscca.SDFJNI;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.math.BigInteger;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Set;

public class MakeEccCert {
    private static String CACertFile;
    private static int CAKeyIndex;
    private static String CAKeyPass;
    private static String CADN;
    private static String crluri;
    private static byte[] certBs;

    public static void main(String[] args) throws Exception {
        System.out.println("Generate SM2 certificates");
        Security.addProvider((Provider)new InfosecProvider());
        CryptoUtil.debug = true;
        SDFJNI.connectDev();
        SDFJNI.openSession();
        MakeEccCert.makeCA();
        MakeEccCert.makeKeySignCert();
        MakeEccCert.makeServerSignCert();
    }

    private static void makeServerSignCert() throws Exception {
        System.out.println("Generate the sign cer for netsignserver");
        System.out.print("Sign cert file:");
        byte[] readed = new byte[100];
        System.in.read(readed);
        String userCertFile = new String(readed).trim();
        if (userCertFile == null || userCertFile.equals("")) {
            return;
        }
        FileInputStream in = new FileInputStream(userCertFile);
        certBs = new byte[in.available()];
        in.read(certBs);
        System.out.print("Sign cert serial number(radix 16):");
        readed = new byte[100];
        System.in.read(readed);
        BigInteger serailNumber = new BigInteger(new String(readed).trim(), 16);
        System.out.print("Sign cert DN:");
        readed = new byte[100];
        System.in.read(readed);
        String certdn = new String(readed).trim();
        System.out.print("Key index:");
        readed = new byte[100];
        System.in.read(readed);
        int keyindex = Integer.parseInt(new String(readed).trim());
        System.out.print("Crl distribution point URI(ldaps://192.168.2.149:389/O=ca,CN=crl1):");
        readed = new byte[100];
        System.in.read(readed);
        crluri = new String(readed).trim();
        ByteArrayInputStream cin = new ByteArrayInputStream(certBs);
        CertificateFactory cf = CertificateFactory.getInstance("X.509", "INFOSEC");
        X509Certificate c = (X509Certificate)cf.generateCertificate(cin);
        Certificate cp = new Certificate();
        cp.setSerailNumber(serailNumber);
        cp.setIssuer(CADN);
        cp.setSignatureAlgOid("1.2.156.197.1.501");
        cp.setNotAfter(c.getNotAfter());
        cp.setNotBefore(c.getNotBefore());
        cp.setSubject(certdn);
        PublicKey pubk = new PublicKey();
        pubk.setKeyAlgOid("1.2.840.10045.2.1");
        pubk.setKeyLength(7);
        byte[] pubkbs = SDFJNI.exportPublicKey(keyindex);
        byte[] tmp = new byte[66];
        tmp[0] = 0;
        tmp[1] = 4;
        System.arraycopy(pubkbs, 0, tmp, 2, 64);
        pubk.setKey(tmp);
        cp.setSubjectKeyInfo(pubk);
        ArrayList extensions = MakeEccCert.genExts(c);
        cp.setExtensions(extensions);
        CertificateGenerater cg = new CertificateGenerater(cp);
        byte[] tbs = cg.generateTBSCertificate();
        byte[] signed = SDFJNI.SM2SignWithInnerKey(tbs, "SM3", CAKeyIndex, CAKeyPass, null, null);
        cg.setSignature(signed);
        certBs = cg.generateCertificate();
        FileOutputStream out = new FileOutputStream(String.valueOf(userCertFile) + ".4netsign.cer");
        CryptoUtil.debug("Sign cert for usbkey", certBs);
        out.write(certBs);
        out.flush();
        System.out.println("Generate sign cert for netsignserver finished.");
    }

    private static void makeKeySignCert() throws Exception {
        System.out.println("Generate the sign cer for usb key");
        System.out.print("Sign cert file:");
        byte[] readed = new byte[100];
        System.in.read(readed);
        String userCertFile = new String(readed).trim();
        if (userCertFile == null || userCertFile.equals("")) {
            return;
        }
        FileInputStream in = new FileInputStream(userCertFile);
        certBs = new byte[in.available()];
        in.read(certBs);
        System.out.print("Sign cert serial number(radix 16):");
        readed = new byte[100];
        System.in.read(readed);
        BigInteger serailNumber = new BigInteger(new String(readed).trim(), 16);
        System.out.print("Sign cert DN:");
        readed = new byte[100];
        System.in.read(readed);
        String certdn = new String(readed).trim();
        System.out.print("Crl distribution point URI(ldaps://192.168.2.149:389/O=ca,CN=crl1):");
        readed = new byte[100];
        System.in.read(readed);
        crluri = new String(readed).trim();
        ByteArrayInputStream cin = new ByteArrayInputStream(certBs);
        CertificateFactory cf = CertificateFactory.getInstance("X.509", "INFOSEC");
        X509Certificate c = (X509Certificate)cf.generateCertificate(cin);
        Certificate cp = new Certificate();
        cp.setSerailNumber(serailNumber);
        cp.setIssuer(CADN);
        cp.setSignatureAlgOid("1.2.156.197.1.501");
        cp.setNotAfter(c.getNotAfter());
        cp.setNotBefore(c.getNotBefore());
        cp.setSubject(certdn);
        PublicKey pubk = new PublicKey();
        pubk.setKeyAlgOid("1.2.840.10045.2.1");
        pubk.setKeyLength(7);
        byte[] bs = DERUtil.getDERInnerData((byte[])certBs);
        bs = DERUtil.getDERInnerData((byte[])bs);
        bs = DERUtil.getDERInnerData((byte[])bs, (int)7);
        bs = DERUtil.getDERInnerData((byte[])bs, (int)2);
        pubk.setKey(bs);
        cp.setSubjectKeyInfo(pubk);
        ArrayList extensions = MakeEccCert.genExts(c);
        cp.setExtensions(extensions);
        CertificateGenerater cg = new CertificateGenerater(cp);
        byte[] tbs = cg.generateTBSCertificate();
        byte[] signed = SDFJNI.SM2SignWithInnerKey(tbs, "SM3", CAKeyIndex, CAKeyPass, null, null);
        cg.setSignature(signed);
        certBs = cg.generateCertificate();
        FileOutputStream out = new FileOutputStream(String.valueOf(userCertFile) + ".4usbkey.cer");
        CryptoUtil.debug("Sign cert for usbkey", certBs);
        out.write(certBs);
        out.flush();
        System.out.println("Generate sign cert for usbkey finished.");
    }

    private static void makeCA() throws Exception {
        System.out.print("CA cert file:");
        byte[] readed = new byte[100];
        System.in.read(readed);
        CACertFile = new String(readed).trim();
        FileInputStream in = new FileInputStream(CACertFile);
        certBs = new byte[in.available()];
        in.read(certBs);
        System.out.print("CA key index:");
        readed = new byte[100];
        System.in.read(readed);
        CAKeyIndex = Integer.parseInt(new String(readed).trim());
        System.out.print("CA key password:");
        readed = new byte[100];
        System.in.read(readed);
        CAKeyPass = new String(readed).trim();
        System.out.print("CA CertDN:");
        readed = new byte[100];
        System.in.read(readed);
        CADN = new String(readed).trim();
        ByteArrayInputStream cin = new ByteArrayInputStream(certBs);
        CertificateFactory cf = CertificateFactory.getInstance("X.509", "INFOSEC");
        X509Certificate c = (X509Certificate)cf.generateCertificate(cin);
        Certificate cp = new Certificate();
        cp.setSerailNumber(c.getSerialNumber());
        cp.setIssuer(CADN);
        cp.setSignatureAlgOid("1.2.156.197.1.501");
        cp.setNotAfter(c.getNotAfter());
        cp.setNotBefore(c.getNotBefore());
        cp.setSubject(CADN);
        PublicKey pubk = new PublicKey();
        pubk.setKeyAlgOid("1.2.840.10045.2.1");
        pubk.setKeyLength(7);
        byte[] pubkbs = SDFJNI.exportPublicKey(CAKeyIndex);
        byte[] tmp = new byte[66];
        tmp[0] = 0;
        tmp[1] = 4;
        System.arraycopy(pubkbs, 0, tmp, 2, 64);
        pubk.setKey(tmp);
        cp.setSubjectKeyInfo(pubk);
        ArrayList extensions = MakeEccCert.genExts(c);
        cp.setExtensions(extensions);
        CertificateGenerater cg = new CertificateGenerater(cp);
        byte[] tbs = cg.generateTBSCertificate();
        byte[] signed = SDFJNI.SM2SignWithInnerKey(tbs, "SM3", CAKeyIndex, CAKeyPass, null, null);
        cg.setSignature(signed);
        certBs = cg.generateCertificate();
        FileOutputStream out = new FileOutputStream(String.valueOf(CACertFile) + ".new.cer");
        CryptoUtil.debug("ca cert", certBs);
        out.write(certBs);
        out.flush();
        System.out.println("Create CA cert finished.");
    }

    private static ArrayList genExts(X509Certificate cert) {
        Extension e;
        int i;
        String[] oidstrs;
        ArrayList<Extension> extensions = new ArrayList<Extension>();
        Set<String> oids = cert.getCriticalExtensionOIDs();
        if (oids != null) {
            oidstrs = oids.toArray(new String[0]);
            i = 0;
            while (i < oidstrs.length) {
                e = MakeEccCert.genExtension(oidstrs[i], true);
                if (e == null) {
                    e = new Extension();
                    e.setOid(oidstrs[i]);
                    e.setCritical(true);
                    e.setValue(cert.getExtensionValue(oidstrs[i]));
                }
                extensions.add(e);
                ++i;
            }
        }
        if ((oids = cert.getNonCriticalExtensionOIDs()) != null) {
            oidstrs = oids.toArray(new String[0]);
            i = 0;
            while (i < oidstrs.length) {
                e = MakeEccCert.genExtension(oidstrs[i], false);
                if (e == null) {
                    e = new Extension();
                    e.setOid(oidstrs[i]);
                    e.setValue(cert.getExtensionValue(oidstrs[i]));
                }
                extensions.add(e);
                ++i;
            }
        }
        return extensions;
    }

    private static Extension genExtension(String oid, boolean critical) {
        if (oid.equals(X509Extensions.CRLDistributionPoints.getId()) && crluri != null) {
            byte[] bs = crluri.getBytes();
            bs = DERUtil.generateDERCode((int)134, (byte[])bs);
            bs = DERUtil.generateDERCode((int)160, (byte[])bs);
            bs = DERUtil.generateDERCode((int)160, (byte[])bs);
            bs = DERUtil.generateDERCode((int)48, (byte[])bs);
            bs = DERUtil.generateDERCode((int)48, (byte[])bs);
            bs = DERUtil.generateDERCode((int)4, (byte[])bs);
            Extension e = new Extension();
            e.setOid(oid);
            e.setCritical(critical);
            e.setValue(bs);
            return e;
        }
        return null;
    }
}

