/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.crypto.util.cache;

import cn.com.infosec.netsign.crypto.util.Cache;
import cn.com.infosec.netsign.crypto.util.cache.EnvelopGear;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class EnvelopCache
extends Cache {
    private EnvelopGear enGear;
    private EnvelopGear deGear;

    public EnvelopCache(int maxCacheSize, EnvelopGear enGear, EnvelopGear deGear) {
        this.maxCacheSize = maxCacheSize;
        this.enGear = enGear;
        this.deGear = deGear;
    }

    private byte[] digestBSB(byte[] plain, String digestAlg, byte[] D) {
        byte[] algb = digestAlg.getBytes();
        byte[] tmp = new byte[plain.length + algb.length + D.length];
        System.arraycopy(plain, 0, tmp, 0, plain.length);
        System.arraycopy(algb, 0, tmp, plain.length, algb.length);
        System.arraycopy(D, 0, tmp, plain.length + algb.length, D.length);
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            return md.digest(tmp);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] getCipher(byte[] plain, String digestAlg, byte[] D) {
        byte[] key = this.digestBSB(plain, digestAlg, D);
        if (key == null) {
            return null;
        }
        byte[] cipher = (byte[])this.cache.get(new BigInteger(key));
        if (cipher == null) {
            return null;
        }
        if (this.enGear.next() == 1) {
            return cipher;
        }
        return null;
    }

    public void putCipher(byte[] plain, String digestAlg, byte[] D, byte[] cipher) {
        byte[] key = this.digestBSB(plain, digestAlg, D);
        if (key != null) {
            this.put(new BigInteger(key), cipher);
        }
    }

    public byte[] getDecryptResult(byte[] plain, String digestAlg, byte[] D) {
        byte[] key = this.digestBSB(plain, digestAlg, D);
        if (key == null) {
            return null;
        }
        byte[] cipher = (byte[])this.cache.get(new BigInteger(key));
        if (cipher == null) {
            return null;
        }
        if (this.deGear.next() == 1) {
            return cipher;
        }
        return null;
    }

    public void putDecryptResult(byte[] envelopedMsg, String alg, byte[] key, byte[] bak) {
        this.putCipher(envelopedMsg, alg, key, bak);
    }
}

