/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.crypto.util;

import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.DERInputStream;
import cn.com.infosec.asn1.x509.DigestInfo;
import cn.com.infosec.asn1.x509.X509Name;
import cn.com.infosec.netsign.crypto.exception.CryptoException;
import cn.com.infosec.netsign.crypto.util.CryptoUtil;
import cn.com.infosec.netsign.crypto.util.ICKCryptImpl;
import cn.com.infosec.netsign.crypto.util.PKCS10CertificationRequest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Properties;

public class HardCryptoImpl {
    private static ICKCryptImpl ick = null;
    public static final String LIBNAME = "libname";
    public static final String TOKENNAME = "tokenname";
    public static final String TOKENPASSWORD = "tokenpassowrd";
    public static final String AlgConfigFile = "ALGCONFIGFILE";
    private static String dllname = null;
    private static String tokenName = null;
    private static String tokenpassword = null;
    private static final String configErrMsg = "Can not Found ";
    public static final int CKM_MD2_RSA_PKCS = 4;
    public static final int CKM_MD5_RSA_PKCS = 5;
    public static final int CKM_SHA1_RSA_PKCS = 6;
    public static final int DES = 1;
    public static final int RC4 = 2;
    public static final int RC2 = 3;
    public static final int RC5 = 4;
    public static final byte[] IV = "12345678".getBytes();

    public HardCryptoImpl(Properties p) throws CryptoException {
        HardCryptoImpl.ConfigICK(p);
        ick = ICKCryptImpl.getInstance(dllname, tokenName, tokenpassword);
    }

    public HardCryptoImpl(String dllname, String tokenName, String tokenpassword) throws CryptoException {
        HardCryptoImpl.dllname = dllname;
        HardCryptoImpl.tokenName = tokenName;
        HardCryptoImpl.tokenpassword = tokenpassword;
        ick = ICKCryptImpl.getInstance(dllname, tokenName, tokenpassword);
    }

    private static void ConfigICK(Properties prop) throws CryptoException {
        if (prop == null) {
            throw new CryptoException("ICK Config Properties is NULL");
        }
        dllname = prop.getProperty(LIBNAME);
        tokenName = prop.getProperty(TOKENNAME);
        tokenpassword = prop.getProperty(TOKENPASSWORD);
        if (dllname == null) {
            throw new CryptoException("Can not Found libname");
        }
        if (tokenName == null) {
            throw new CryptoException("Can not Found tokenname");
        }
        if (tokenpassword == null) {
            throw new CryptoException("Can not Found tokenpassowrd");
        }
    }

    public static int getSignALG(String digestAlg) {
        if (digestAlg.equals("SHA1")) {
            return 6;
        }
        if (digestAlg.equals("MD5")) {
            return 5;
        }
        if (digestAlg.equals("MD2")) {
            return 4;
        }
        return 0;
    }

    public synchronized byte[] SignWithAlg(byte[] privkeylabel, byte[] srcddata, int SignALG) throws CryptoException {
        byte[] temp = ick.signwithalg(CryptoUtil.constructHardData(CryptoUtil.JNI_RSA_KEY_NAME, privkeylabel), CryptoUtil.constructHardData(CryptoUtil.JNI_RSA_PLAIN_DATA, srcddata), SignALG);
        byte[] result = CryptoUtil.clearHardData(temp);
        return result;
    }

    public String[] getKeyLabels() throws CryptoException {
        byte[][] temp = null;
        try {
            temp = ick.getKeyLabels();
            String[] rs = new String[temp.length];
            int i = 0;
            while (i < temp.length) {
                rs[i] = temp[i] == null ? null : new String(temp[i]);
                ++i;
            }
            return rs;
        }
        catch (Throwable e) {
            throw new CryptoException("Unsupport get key lables", e);
        }
    }

    public synchronized boolean verify(PublicKey pk, byte[] srcdata, byte[] signeddata, int signalg) throws CryptoException {
        byte[] sourData = CryptoUtil.constructHardData(CryptoUtil.JNI_RSA_PLAIN_DATA, srcdata);
        byte[] resultPubkey = CryptoUtil.constructHardPublicKey(pk);
        byte[] resultSign = CryptoUtil.constructHardData(CryptoUtil.JNI_RSA_SIGNATURE, signeddata);
        boolean bResult = ick.verify(resultPubkey, sourData, resultSign, signalg);
        return bResult;
    }

    public synchronized byte[] DecryptHash(byte[] enchash, PublicKey pk) throws CryptoException {
        byte[] enchashdata = CryptoUtil.constructHardData(CryptoUtil.JNI_RSA_ENCHASH, enchash);
        byte[] resultPubkey = CryptoUtil.constructHardPublicKey(pk);
        CryptoUtil.debug("resultPubkey", resultPubkey);
        CryptoUtil.debug("enchash", enchash);
        byte[] temp = ick.DecryptWithRSAPublicKey(resultPubkey, enchashdata);
        byte[] result = CryptoUtil.clearHardData(temp);
        try {
            byte[] tesultmp = HardCryptoImpl.derDecode(result).getDigest();
            return tesultmp;
        }
        catch (IOException ioixe) {
            throw new CryptoException(ioixe);
        }
    }

    public synchronized boolean verifyRAWSignature(byte[] enchash, PublicKey pk, byte[] hash) throws CryptoException {
        byte[] hashde = this.DecryptHash(enchash, pk);
        return Arrays.equals(hash, hashde);
    }

    private static DigestInfo derDecode(byte[] encoding) throws IOException {
        ByteArrayInputStream bIn = new ByteArrayInputStream(encoding);
        DERInputStream dIn = new DERInputStream((InputStream)bIn);
        return new DigestInfo((ASN1Sequence)dIn.readObject());
    }

    public PublicKey genKeyPair4P10(byte[] prikeylabel, int keysize) throws CryptoException {
        byte[] prikeylabeldata = CryptoUtil.constructHardData(CryptoUtil.JNI_RSA_KEY_NAME, prikeylabel);
        byte[] temp = ick.genKeyPair4P10(prikeylabeldata, keysize);
        byte[][] pubkeyMember = CryptoUtil.splitHardPublicKey(temp);
        PublicKey ppp = CryptoUtil.getPublicKey(pubkeyMember[0], pubkeyMember[1]);
        return ppp;
    }

    public synchronized byte[][] EncryptWithRSAPublicKeyWithAlg(PublicKey pk, byte[] srcdata, long keytype, long keygenalg, long keyencalg, boolean hasiv, byte[] iv) throws CryptoException {
        if (iv == null) {
            iv = IV;
        }
        if (iv.length != 8) {
            throw new CryptoException("IV Length Must 8");
        }
        byte[] resultPubkey = CryptoUtil.constructHardPublicKey(pk);
        byte[] srcdatatemp = CryptoUtil.constructHardData(CryptoUtil.JNI_RSA_PLAIN_DATA, srcdata);
        byte[] ivdata = CryptoUtil.constructHardData(CryptoUtil.JNI_SYM_ALG_IV, iv);
        int hasivint = hasiv ? 0 : 1;
        byte[][] a = ick.EncryptWithRSAPublicKeyWithAlg(resultPubkey, srcdatatemp, keytype, keygenalg, keyencalg, ivdata, hasivint);
        byte[] A = CryptoUtil.clearHardData(a[0]);
        byte[] B = CryptoUtil.clearHardData(a[1]);
        byte[][] aa = new byte[][]{A, B};
        return aa;
    }

    public synchronized byte[] DecryptWithRSAPrivateKeyWithAlg(byte[] prikeylabel, byte[] encdata, byte[] enckey, long keytype, long keydecalg, boolean hasiv, byte[] iv) throws CryptoException {
        if (iv == null) {
            iv = IV;
        }
        if (iv.length != 8) {
            throw new CryptoException("IV Length Must 8");
        }
        int hasivint = hasiv ? 0 : 1;
        byte[] prilabeldata = CryptoUtil.constructHardData(CryptoUtil.JNI_RSA_KEY_NAME, prikeylabel);
        byte[] encdata1 = CryptoUtil.constructHardData(CryptoUtil.JNI_SYM_ENC_DATA, encdata);
        byte[] enckeydata = CryptoUtil.constructHardData(CryptoUtil.JNI_SYM_ENCSECKEY, enckey);
        byte[] ivdata = CryptoUtil.constructHardData(CryptoUtil.JNI_SYM_ALG_IV, iv);
        byte[] temp = ick.DecryptWithRSAPrivateKeyWithAlg(prilabeldata, encdata1, enckeydata, keytype, keydecalg, ivdata, hasivint);
        byte[] result = CryptoUtil.clearHardData(temp);
        return result;
    }

    public String generatePKCS10CSR(String subject, int keysize, byte[] keylabel) throws CryptoException {
        try {
            String[] keylabels = this.getKeyLabels();
            int i = 0;
            while (i < keylabels.length) {
                if (Arrays.equals(keylabels[i].getBytes(), keylabel)) {
                    throw new CryptoException("The PriveKeyLabel has been used");
                }
                ++i;
            }
            X509Name dn = new X509Name(subject);
            PKCS10CertificationRequest csr = new PKCS10CertificationRequest(dn, keysize, null, keylabel, this, "INFOSEC");
            if (!csr.verify()) {
                throw new CryptoException("The P10 Request verify failed");
            }
            return CryptoUtil.createbase64csr(csr);
        }
        catch (Exception ex) {
            throw new CryptoException(ex);
        }
    }

    public void DestoryICK() throws CryptoException {
        ick.free();
    }
}

