/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.crypto.test;

import cn.com.infosec.netsign.crypto.test.Tester;
import java.util.ResourceBundle;

public class TestLoader
implements Runnable {
    private static ResourceBundle values = ResourceBundle.getBundle("cn.com.infosec.netsign.crypto.test.values");
    private static long count = 0L;
    private static long success = 0L;
    private static long error = 0L;
    private Thread t = null;
    private Tester tester;
    private static boolean timeout = false;
    private static Runtime runtime;

    public TestLoader(Tester tester) {
        if (runtime == null) {
            try {
                runtime = Runtime.getRuntime();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.tester = tester;
    }

    public void start() {
        this.t = new Thread(this);
        this.t.start();
    }

    public void run() {
        while (!timeout) {
            ++count;
            try {
                this.tester.test();
                ++success;
            }
            catch (Exception e) {
                ++error;
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        int threads = Integer.parseInt(values.getString("loder.threads"));
        int testtime = Integer.parseInt(values.getString("loder.testtime"));
        String className = values.getString("loder.classname");
        Tester t = null;
        System.out.println("Test start.");
        long now = System.currentTimeMillis() / 1000L;
        int i = 0;
        while (i < threads) {
            try {
                Class<?> c = Class.forName(className);
                t = (Tester)c.newInstance();
                t.init();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            TestLoader tl = new TestLoader(t);
            tl.start();
            ++i;
        }
        while (true) {
            long timecurr;
            if ((timecurr = System.currentTimeMillis() / 1000L) - now >= (long)testtime) break;
            if (timecurr - now != 0L && (timecurr - now) % 60L == 0L) {
                System.out.println(String.valueOf(timecurr - now) + " seconds used.");
                TestLoader.stat(threads, (int)(timecurr - now));
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        timeout = true;
        System.out.println("Stop at " + testtime + " seconds.");
        TestLoader.stat(threads, testtime);
    }

    private static void stat(int threads, int timeused) {
        System.out.println("Total threads:" + threads);
        System.out.println("Total processed:" + count);
        int stat = (int)(success * 10000L / count);
        String statStr = String.valueOf(stat / 100) + "." + (stat - stat / 100 * 100);
        System.out.println("Total successed:" + success + "(" + statStr + "%)");
        stat = (int)(error * 10000L / count);
        statStr = String.valueOf(stat / 100) + "." + (stat - stat / 100 * 100);
        System.out.println("Total error:" + error + "(" + statStr + "%)");
        System.out.println(String.valueOf(count - success - error) + " processes have not finished");
        System.out.println("Stat:" + success / (long)timeused + " per second");
        try {
            long totalMemory = runtime.totalMemory();
            long freeMemory = runtime.freeMemory();
            long maxMemory = runtime.maxMemory();
            System.out.println("Total memory: " + maxMemory);
            long usedMemory = totalMemory - freeMemory;
            stat = (int)(usedMemory * 10000L / maxMemory);
            statStr = String.valueOf(stat / 100) + "." + (stat - stat / 100 * 100);
            System.out.println("Memeory used: " + usedMemory + "(" + statStr + "%)");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

