/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.asn1.x509;

import cn.com.infosec.asn1.ASN1InputStream;
import cn.com.infosec.asn1.ASN1Sequence;
import cn.com.infosec.asn1.ASN1TaggedObject;
import cn.com.infosec.asn1.DERBitString;
import cn.com.infosec.asn1.DEREncodable;
import cn.com.infosec.asn1.DERInteger;
import cn.com.infosec.asn1.x509.AlgorithmIdentifier;
import cn.com.infosec.asn1.x509.Time;
import cn.com.infosec.asn1.x509.X509Extension;
import cn.com.infosec.asn1.x509.X509Extensions;
import cn.com.infosec.asn1.x509.X509Name;
import cn.com.infosec.netsign.asn1.x509.InfosecPublicKey;
import cn.com.infosec.netsign.crypto.exception.CryptoException;
import cn.com.infosec.netsign.crypto.util.CryptoUtil;
import cn.com.infosec.netsign.frame.config.ExtendedConfig;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import cn.com.infosec.oscca.SDFJNI;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import javax.security.auth.x500.X500Principal;

public class InfosecCertificate
extends Certificate {
    private PublicKey pubk;
    private byte[] pubKeyEncoded;
    private BigInteger sn;
    private Principal issuerSubject;
    private String issuerSubjectStr;
    private Principal subject;
    private String subjectStr;
    private byte[] certEncoded;
    private AlgorithmIdentifier encryptAlg;
    private String sigOID;
    private byte[] signature;
    private byte[] tbsCert;
    private Date notBefore;
    private String notBeforeStr;
    private Date notAfter;
    private String notAfterStr;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private X509Extensions extensions;
    private X509Certificate x509Cert;
    private String crldp;

    public X509Certificate getX509Cert() {
        return this.x509Cert;
    }

    public X509Extensions getExtensions() {
        return this.extensions;
    }

    private InfosecCertificate(InputStream in) throws IOException {
        super("X.509");
        this.certEncoded = new byte[in.available()];
        in.read(this.certEncoded);
        ASN1InputStream asn1In = new ASN1InputStream(this.certEncoded);
        ASN1Sequence wholeCert = ASN1Sequence.getInstance((Object)asn1In.readObject());
        ASN1Sequence tbs = ASN1Sequence.getInstance((Object)wholeCert.getObjectAt(0));
        this.tbsCert = tbs.getEncoded();
        this.parseTBSCert(tbs);
        ASN1Sequence alg = ASN1Sequence.getInstance((Object)wholeCert.getObjectAt(1));
        this.encryptAlg = AlgorithmIdentifier.getInstance((Object)alg.getObjectAt(0));
        this.sigOID = this.encryptAlg.getObjectId().getId();
        DERBitString sig = DERBitString.getInstance((Object)wholeCert.getObjectAt(2));
        this.signature = sig.getBytes();
    }

    private void parseTBSCert(ASN1Sequence tbs) {
        DERInteger dsn = DERInteger.getInstance((Object)tbs.getObjectAt(1));
        this.sn = dsn.getValue();
        ASN1Sequence asnIssuer = ASN1Sequence.getInstance((Object)tbs.getObjectAt(3));
        X509Name x509Issuer = X509Name.getInstance((Object)asnIssuer);
        this.issuerSubjectStr = x509Issuer.toString();
        this.issuerSubject = new X500Principal(this.issuerSubjectStr);
        ASN1Sequence asnValidity = ASN1Sequence.getInstance((Object)tbs.getObjectAt(4));
        Time derNotBefore = Time.getInstance((Object)asnValidity.getObjectAt(0));
        this.notBefore = derNotBefore.getDate();
        this.notBeforeStr = this.dateFormat.format(this.notBefore);
        Time derNotAfter = Time.getInstance((Object)asnValidity.getObjectAt(1));
        this.notAfter = derNotAfter.getDate();
        this.notAfterStr = this.dateFormat.format(this.notAfter);
        ASN1Sequence asnSubject = ASN1Sequence.getInstance((Object)tbs.getObjectAt(5));
        X509Name x509Subject = X509Name.getInstance((Object)asnSubject);
        ConsoleLogger.logBinary((String)"subject", (byte[])x509Subject.getDEREncoded());
        this.subjectStr = x509Subject.toString();
        this.subject = new X500Principal(this.subjectStr);
        this.pubKeyEncoded = tbs.getObjectAt(6).getDERObject().getDEREncoded();
        this.pubk = new InfosecPublicKey(this.pubKeyEncoded);
        ASN1TaggedObject tmp = (ASN1TaggedObject)tbs.getObjectAt(tbs.size() - 1);
        this.extensions = X509Extensions.getInstance((ASN1TaggedObject)tmp, (boolean)true);
        this.parseExtensions();
    }

    private void parseExtensions() {
        this.parseCRLDP();
    }

    private void parseCRLDP() {
        try {
            X509Extension ext = this.extensions.getExtension(X509Extensions.CRLDistributionPoints);
            if (ext == null) {
                return;
            }
            ASN1Sequence crldpsSeq = ASN1Sequence.getInstance((Object)X509Extension.convertValueToObject((X509Extension)ext));
            ASN1Sequence crldpSeq = ASN1Sequence.getInstance((Object)crldpsSeq.getObjectAt(0));
            DEREncodable fullName = ASN1TaggedObject.getInstance((Object)ASN1TaggedObject.getInstance((Object)ASN1TaggedObject.getInstance((Object)crldpSeq.getObjectAt(0)).getObjectParser(0, true)).getObjectParser(0, true)).getObjectParser(0, true);
            ConsoleLogger.logBinary((String)"fullName", (byte[])fullName.getDERObject().getEncoded());
            try {
                X509Name name = X509Name.getInstance((Object)fullName);
                String crlFullName = name.toString();
                String[] pieces1 = crlFullName.split("CN=");
                String[] pieces2 = pieces1[1].split(",");
                this.crldp = pieces2[0];
            }
            catch (Exception e) {
                byte[] fullNameDer = fullName.getDERObject().getDEREncoded();
                this.crldp = new String(CryptoUtil.getDERInnerData(fullNameDer));
            }
        }
        catch (Exception e) {
            ConsoleLogger.logException((Throwable)e);
        }
    }

    public String getCRLDP() {
        return this.crldp;
    }

    public String getSubjectDNStr() {
        return this.subjectStr;
    }

    public String getIssuerDNStr() {
        return this.issuerSubjectStr;
    }

    public Principal getSubjectDN() {
        return this.subject;
    }

    public PublicKey getPublicKey() {
        return this.pubk;
    }

    public byte[] getPublicKeyEncoded() {
        return this.pubKeyEncoded;
    }

    public BigInteger getSerialNumber() {
        return this.sn;
    }

    public Principal getIssuerDN() {
        return this.issuerSubject;
    }

    public void checkValidity() throws CertificateNotYetValidException, CertificateExpiredException {
        long now = System.currentTimeMillis();
        if (now < this.notBefore.getTime()) {
            throw new CertificateNotYetValidException("Certificate not valid till " + this.notBeforeStr);
        }
        if (now > this.notAfter.getTime()) {
            throw new CertificateExpiredException("Certificate valid expired at " + this.notAfterStr);
        }
    }

    public static InfosecCertificate getInstance(InputStream in) throws IOException {
        InfosecCertificate cert = new InfosecCertificate(in);
        return cert;
    }

    public static InfosecCertificate getInstance(X509Certificate cert) throws CertificateEncodingException, IOException {
        return InfosecCertificate.getInstance(new ByteArrayInputStream(cert.getEncoded()));
    }

    public AlgorithmIdentifier getEncryptAlg() {
        return this.encryptAlg;
    }

    public String getSigAlgOID() {
        return this.sigOID;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public byte[] getTBSCertificate() {
        return this.tbsCert;
    }

    public Date getNotBefore() {
        return this.notBefore;
    }

    public String getNotBeforeStr() {
        return this.notBeforeStr;
    }

    public Date getNotAfter() {
        return this.notAfter;
    }

    public String getNotAfterStr() {
        return this.notAfterStr;
    }

    public boolean equals(Object anObj) {
        if (anObj == null) {
            return false;
        }
        if (anObj instanceof InfosecCertificate) {
            InfosecCertificate nscert = (InfosecCertificate)anObj;
            if (this == nscert) {
                return true;
            }
            if (this.certEncoded == null && nscert.getEncoded() != null) {
                return false;
            }
            if (this.certEncoded != null && !Arrays.equals(this.certEncoded, nscert.getEncoded())) {
                return false;
            }
            if (this.pubk == null && nscert.pubk != null) {
                return false;
            }
            return this.pubk == null || this.pubk.equals(nscert.pubk);
        }
        return false;
    }

    public byte[] getEncoded() {
        return this.certEncoded;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("------------------BEGIN CERTIFICATER------------------\n");
        builder.append("ISSUER:").append(this.issuerSubjectStr).append("\n");
        builder.append("SERIAL NUMBER:").append(this.sn.toString()).append("\n");
        builder.append("SUBJECT:").append(this.subjectStr).append("\n");
        builder.append("NOT BEFORE:").append(this.notBeforeStr).append("\n");
        builder.append("NOT AFTER:").append(this.notAfterStr).append("\n");
        builder.append("-------------------END CERTIFICATER------------------\n");
        return builder.toString();
    }

    public void verify(PublicKey arg0) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.verify(arg0, "INFOSEC");
    }

    public void verify() throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException, CryptoException {
        try {
            if (!SDFJNI.SM2VierifyWithExternalKey(this.getTBSCertificate(), "SM3", this.getSignature(), this.pubk.getEncoded(), null)) {
                throw new InvalidKeyException("Public key presented not for certificate signature");
            }
        }
        catch (Exception e) {
            throw new SignatureException("Public key presented not for certificate signature", e);
        }
    }

    public void VerifyCert(InfosecCertificate signCert, byte[] tbs, boolean checkValidity, String provider, long notBefore, long notAfter) throws Exception {
        if (checkValidity && !this.checkCertValidity(notBefore, notAfter)) {
            throw new Exception("From:" + signCert.getNotBefore() + " To:" + signCert.getNotAfter());
        }
    }

    private boolean checkCertValidity(long notBefore, long notAfter) {
        if (ExtendedConfig.isCheckCertValidity()) {
            long now = System.currentTimeMillis() / 1000L;
            return notBefore <= now && notAfter >= now;
        }
        return true;
    }

    public static void main(String[] args) {
        try {
            FileInputStream in = new FileInputStream("d:/3.cer.4netsign.cer");
            InfosecCertificate cert = new InfosecCertificate(in);
            ConsoleLogger.logString((String)("sn:" + cert.getSerialNumber().toString(16)));
            ConsoleLogger.logString((String)("issuer:" + cert.getIssuerDNStr()));
            ConsoleLogger.logString((String)("notBefore:" + cert.notBeforeStr));
            ConsoleLogger.logString((String)("notAfter:" + cert.notAfterStr));
            ConsoleLogger.logString((String)("alg:" + cert.encryptAlg.getObjectId()));
            ConsoleLogger.logString((String)("subject:" + cert.subjectStr));
            ConsoleLogger.logBinary((String)"public key", (byte[])cert.getPublicKeyEncoded());
            ConsoleLogger.logBinary((String)"signature", (byte[])cert.signature);
            ConsoleLogger.logString((String)("crldp:" + cert.crldp));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void verify(PublicKey key, String sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
    }
}

