/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.bccms;

import cn.com.infosec.bccms.JcaSM2ContentSignerBuilder;
import cn.com.infosec.bccms.JcaSM2DigestCalculatorProviderBuilder;
import cn.com.infosec.jce.provider.InfosecProvider;
import cn.com.infosec.jce.provider.JCESM2PrivateKey;
import cn.com.infosec.jce.provider.JCESM2PublicKey;
import cn.com.infosec.netsign.crypto.util.Base64;
import cn.com.infosec.netsign.frame.util.PrivateKeyUtil;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import cn.com.infosec.oscca.OSCCAMessageDigest;
import cn.com.infosec.oscca.SDFJNI;
import cn.com.infosec.oscca.sm2.SM2;
import cn.com.infosec.oscca.sm2.SM2PublicKey;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.x509.RSAPublicKeyStructure;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.util.CollectionStore;
import org.bouncycastle.util.Store;

public class TestCMS {
    public static void main(String[] args) throws Exception {
        Security.addProvider((Provider)new InfosecProvider());
        byte[] signed = TestCMS.testencode();
        TestCMS.testdecode(signed);
    }

    private static byte[] testencode() throws Exception {
        SM2.setSM2SignModeHard(false);
        SM2.setSM2VerifyModeHard(false);
        SDFJNI.init();
        String prikStr = "6+v73AjgPZmf8uWotiPcURtQVOZ/Z2GBUCqR1xWkHqc=";
        String aliase = "CN=cert4netsignserver,O=infosec:b010e54d2e128ed0d7d1b4f50584973c27f76ba7";
        String certStr = "MIICKjCCAc6gAwIBAgIBATAMBggqgRzPVQGDdQUAMCQxEDAOBgNVBAMTB3NtMnJvb3QxEDAOBgNVBAoTB2luZm9zZWMwHhcNMTMwMTE2MDUzODM3WhcNMTQwMTE2MDUzODM3WjAvMRswGQYDVQQDExJjZXJ0NG5ldHNpZ25zZXJ2ZXIxEDAOBgNVBAoTB2luZm9zZWMwWTATBgcqhkjOPQIBBggqgRzPVQGCLQNCAATGQstw28SuaGCgMyQcY3P7VDSGgMYU74tfvBJF+w5yr8weI2ubMJmai6DxmDimhiUmL/tOi0Pf8sjglijNL/UOo4HjMIHgMAsGA1UdDwQEAwIGwDAdBgNVHQ4EFgQUYLN5JbOFP7eXhAtvxr+nxi7D/VgwVQYDVR0fBE4wTDBKoEigRqREMEIxDTALBgNVBAMMBGNybDExDDAKBgNVBAsMA2NybDEWMBQGA1UECgwNSW5mb3NlY1Rlc3RDQTELMAkGA1UEBhMCQ04wHQYDVR0lBBYwFAYIKwYBBQUHAwIGCCsGAQUFBwMEMAkGA1UdEwQCMAAwEAYIYIZIAfhCAQEEBAMCBaAwHwYDVR0jBBgwFoAUg+RlNe1bApz2BDtAt7NdEi4MQqYwDAYIKoEcz1UBg3UFAANIADBFAiEA0CcZMiEB3aiuBymSTxH0xyN7uYQK7nEIfMZSBVaM9gsCIGX7tiMe+Cyy0DTVmDZ0m0/GlzpiZGgBBsa7f5OyHD57";
        byte[] d = PrivateKeyUtil.decryptPrivateKey((String)prikStr, (String)aliase);
        JCESM2PrivateKey prik = new JCESM2PrivateKey(d);
        CertificateFactory cf = CertificateFactory.getInstance("X.509", "INFOSEC");
        X509Certificate cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(Base64.decode(certStr.getBytes())));
        ConsoleLogger.logBinary((String)"signCert", (byte[])cert.getEncoded());
        JCESM2PublicKey pubk = (JCESM2PublicKey)cert.getPublicKey();
        CMSProcessableByteArray msg = new CMSProcessableByteArray("11111111".getBytes());
        ArrayList<X509Certificate> list = new ArrayList<X509Certificate>();
        list.add(cert);
        JcaCertStore certs = new JcaCertStore(list);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        JcaSM2ContentSignerBuilder singerBuilder = new JcaSM2ContentSignerBuilder("SM3withSM2");
        singerBuilder.setPucId("1234567812345678".getBytes());
        ContentSigner signer = singerBuilder.build("SM3", pubk, prik);
        JcaSignerInfoGeneratorBuilder sigb = new JcaSignerInfoGeneratorBuilder(new JcaSM2DigestCalculatorProviderBuilder().build());
        gen.addSignerInfoGenerator(sigb.build(signer, cert));
        gen.addCertificates((Store)certs);
        CMSSignedData sigData = gen.generate((CMSTypedData)msg, true);
        byte[] bs = sigData.getEncoded();
        ConsoleLogger.logBinary((String)"signed", (byte[])bs);
        return bs;
    }

    public static void testdecode(byte[] signed) throws Exception {
        ConsoleLogger.isDebug = true;
        ByteArrayInputStream in = new ByteArrayInputStream(signed);
        CMSSignedData signedData = new CMSSignedData((InputStream)in);
        CMSProcessableByteArray pba = (CMSProcessableByteArray)signedData.getSignedContent();
        byte[] plain = (byte[])pba.getContent();
        ConsoleLogger.logBinary((String)"conetent", (byte[])plain);
        SignerInformationStore sis = signedData.getSignerInfos();
        SignerInformation si = sis.getSigners().toArray(new SignerInformation[0])[0];
        byte[] sig = si.getSignature();
        ConsoleLogger.logBinary((String)"Issuer", (byte[])si.getSID().getIssuerAsBytes());
        ConsoleLogger.logString((String)("SN:" + si.getSID().getSerialNumber().toString(16)));
        ConsoleLogger.logBinary((String)"signed", (byte[])sig);
        ConsoleLogger.logString((String)("digest alg:" + si.getDigestAlgOID()));
        ConsoleLogger.logString((String)("encrypt alg:" + si.getEncryptionAlgOID()));
        AttributeTable signedAttrs = si.getSignedAttributes();
        Attribute attr = signedAttrs.get(new DERObjectIdentifier("1.2.840.113549.1.9.4"));
        ASN1Set set = attr.getAttrValues();
        byte[] messageDigestOctet = set.getObjectAt(0).getDERObject().getEncoded();
        byte[] messageDigest = new byte[messageDigestOctet.length - 2];
        System.arraycopy(messageDigestOctet, 2, messageDigest, 0, messageDigest.length);
        ConsoleLogger.logBinary((String)"message digest", (byte[])messageDigest);
        byte[] tbs = si.getEncodedSignedAttributes();
        ConsoleLogger.logBinary((String)"tbs", (byte[])tbs);
        CollectionStore cstore = (CollectionStore)signedData.getCertificates();
        ArrayList list = (ArrayList)cstore.getMatches(null);
        X509CertificateHolder certHolder = (X509CertificateHolder)list.get(0);
        byte[] certbs = certHolder.getEncoded();
        ConsoleLogger.logBinary((String)"cert", (byte[])certHolder.getEncoded());
        System.out.println("Subject:" + certHolder.getSubject().toString());
        System.out.println("Issuer Subject:" + certHolder.getIssuer().toString());
        ConsoleLogger.logBinary((String)"Issuer", (byte[])certHolder.getIssuer().getEncoded());
        byte[] pubkbs = certHolder.getSubjectPublicKeyInfo().getEncoded();
        SM2PublicKey pubk = new SM2PublicKey(pubkbs);
        byte[] digestResult = OSCCAMessageDigest.SM3Digest(null, null, null, plain);
        ConsoleLogger.logBinary((String)"digestResult", (byte[])digestResult);
        ConsoleLogger.logString((String)("digest verify result:" + Arrays.equals(digestResult, messageDigest)));
        ConsoleLogger.logString((String)("Signature verify result:" + SDFJNI.SM2VierifyWithExternalKey(tbs, "SM3", sig, pubk, "1234567812345678".getBytes())));
    }

    public static void testdecodeRSA(byte[] signed) throws Exception {
        ConsoleLogger.isDebug = true;
        ByteArrayInputStream in = new ByteArrayInputStream(signed);
        CMSSignedData signedData = new CMSSignedData((InputStream)in);
        CMSProcessableByteArray pba = (CMSProcessableByteArray)signedData.getSignedContent();
        byte[] plain = (byte[])pba.getContent();
        ConsoleLogger.logBinary((String)"conetent", (byte[])plain);
        ConsoleLogger.logString((String)new String(plain));
        SignerInformationStore sis = signedData.getSignerInfos();
        SignerInformation si = sis.getSigners().toArray(new SignerInformation[0])[0];
        byte[] sig = si.getSignature();
        System.out.println("Issuer Subject:" + si.getSID().getIssuerAsString());
        ConsoleLogger.logBinary((String)"Issuer", (byte[])si.getSID().getIssuerAsBytes());
        if ((0xFF & signed[0]) > 121) {
            byte[] tmp = new byte[signed.length + 1];
            System.arraycopy(signed, 0, tmp, 1, signed.length);
            signed = tmp;
        }
        ConsoleLogger.logBinary((String)"signed", (byte[])sig);
        CollectionStore cstore = (CollectionStore)signedData.getCertificates();
        ArrayList list = (ArrayList)cstore.getMatches(null);
        System.out.println(list.size());
        X509CertificateHolder certHolder = (X509CertificateHolder)list.get(0);
        System.out.println("Subject:" + certHolder.getSubject().toString());
        System.out.println("Issuer Subject:" + certHolder.getIssuer().toString());
        ConsoleLogger.logBinary((String)"Issuer", (byte[])certHolder.getIssuer().getEncoded());
        SubjectPublicKeyInfo ski = certHolder.getSubjectPublicKeyInfo();
        RSAPublicKeyStructure pks = RSAPublicKeyStructure.getInstance((Object)ski.getPublicKey());
        BigInteger exponent = pks.getPublicExponent();
        BigInteger modulues = pks.getModulus();
        BigInteger signedInteger = new BigInteger(signed);
        BigInteger decode = signedInteger.modPow(exponent, modulues);
        ConsoleLogger.logBinary((String)"decoded", (byte[])decode.toByteArray());
        System.out.println("ok");
    }
}

