/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.bccms;

import cn.com.infosec.jce.provider.JCESM2PrivateKey;
import cn.com.infosec.jce.provider.JCESM2PublicKey;
import cn.com.infosec.netsign.crypto.exception.CryptoException;
import cn.com.infosec.oscca.OID;
import cn.com.infosec.oscca.SDFJNI;
import cn.com.infosec.oscca.sm2.SM2PublicKey;
import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.RuntimeOperatorException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class JcaSM2ContentSignerBuilder
extends JcaContentSignerBuilder {
    private static AlgorithmIdentifier sigAlgId;
    protected byte[] pucId;

    public JcaSM2ContentSignerBuilder(String signatureAlg) {
        super("SHA1withRSA");
        sigAlgId = new AlgorithmIdentifier(OID.getAlgrithmOidByName(signatureAlg));
    }

    public void setPucId(byte[] pucId) {
        this.pucId = pucId;
    }

    public ContentSigner build(String digestAlg, JCESM2PublicKey publicKey, JCESM2PrivateKey privateKey) throws OperatorCreationException {
        try {
            String digAlg = digestAlg;
            JCESM2PublicKey pubk = publicKey;
            JCESM2PrivateKey prik = privateKey;
            return new ContentSigner(digAlg, pubk, prik){
                private SignatureOutputStream stream;
                {
                    this.stream = new SignatureOutputStream(string, JcaSM2ContentSignerBuilder.this.pucId, jCESM2PublicKey, jCESM2PrivateKey);
                }

                public AlgorithmIdentifier getAlgorithmIdentifier() {
                    return sigAlgId;
                }

                public OutputStream getOutputStream() {
                    return this.stream;
                }

                public byte[] getSignature() {
                    try {
                        return this.stream.getSignature();
                    }
                    catch (SignatureException e) {
                        throw new RuntimeOperatorException("exception obtaining signature: " + e.getMessage(), (Throwable)e);
                    }
                }
            };
        }
        catch (Throwable e) {
            throw new OperatorCreationException("cannot create signer: " + e.getMessage(), e);
        }
    }

    private class SignatureOutputStream
    extends OutputStream {
        private byte[] pucid;
        private byte[] tbs;
        private JCESM2PublicKey pubk;
        private JCESM2PrivateKey prik;
        private String digestAlg;

        SignatureOutputStream(String digestAlg, byte[] pucid, JCESM2PublicKey pubk, JCESM2PrivateKey privateKey) {
            this.pucid = pucid;
            this.prik = privateKey;
            this.digestAlg = digestAlg;
            this.pubk = pubk;
        }

        public void write(byte[] bytes, int off, int len) throws IOException {
            this.tbs = new byte[len];
            System.arraycopy(bytes, off, this.tbs, 0, len);
        }

        public void write(byte[] bytes) throws IOException {
            this.tbs = bytes;
        }

        public void write(int b) throws IOException {
            throw new NoSuchMethodError();
        }

        byte[] getSignature() throws SignatureException {
            SM2PublicKey publicKey = new SM2PublicKey(this.pubk.getEncoded());
            try {
                return SDFJNI.SM2SignWithExternalKey(this.tbs, this.digestAlg, this.prik.getD(), publicKey, this.pucid);
            }
            catch (NoSuchProviderException e) {
                throw new SignatureException(e.toString());
            }
            catch (NoSuchAlgorithmException e) {
                throw new SignatureException(e.toString());
            }
            catch (CryptoException e) {
                throw new SignatureException(e.toString());
            }
        }
    }
}

