/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.bccms;

import cn.com.infosec.bccms.InfosecCMSSignedData;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.util.CollectionStore;

public class BCCMSSignedDataParser {
    public static InfosecCMSSignedData parse(byte[] p7data) throws CMSException, IOException, CertificateException, NoSuchProviderException {
        InfosecCMSSignedData icsd = new InfosecCMSSignedData();
        ByteArrayInputStream in = new ByteArrayInputStream(p7data);
        CMSSignedData signedData = new CMSSignedData((InputStream)in);
        CMSProcessableByteArray pba = (CMSProcessableByteArray)signedData.getSignedContent();
        if (pba != null) {
            icsd.setContent((byte[])pba.getContent());
        }
        SignerInformationStore sis = signedData.getSignerInfos();
        SignerInformation si = sis.getSigners().toArray(new SignerInformation[0])[0];
        icsd.setSignature(si.getSignature());
        byte[] issuerbs = si.getSID().getIssuerAsBytes();
        BigInteger sn = si.getSID().getSerialNumber();
        icsd.setDigestAlg(si.getDigestAlgOID());
        AttributeTable signedAttrs = si.getSignedAttributes();
        if (signedAttrs != null) {
            Attribute attr = signedAttrs.get(new DERObjectIdentifier("1.2.840.113549.1.9.4"));
            ASN1Set set = attr.getAttrValues();
            byte[] messageDigestOctet = set.getObjectAt(0).getDERObject().getEncoded();
            byte[] messageDigest = new byte[messageDigestOctet.length - 2];
            System.arraycopy(messageDigestOctet, 2, messageDigest, 0, messageDigest.length);
            icsd.setContentDigest(messageDigest);
            byte[] tbs = si.getEncodedSignedAttributes();
            icsd.setTbs(tbs);
        } else {
            icsd.setTbs(icsd.getContent());
        }
        CollectionStore cstore = (CollectionStore)signedData.getCertificates();
        ArrayList list = (ArrayList)cstore.getMatches(null);
        X509Certificate[] certChain = new X509Certificate[list.size()];
        int i = 0;
        int size = list.size();
        while (i < size) {
            X509Certificate cert;
            X509CertificateHolder certHolder = (X509CertificateHolder)list.get(i);
            byte[] certbs = certHolder.getEncoded();
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "INFOSEC");
            certChain[i] = cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(certbs));
            if (Arrays.equals(certHolder.getIssuer().getEncoded(), issuerbs) && certHolder.getSerialNumber().equals(sn)) {
                icsd.setSignCert(certChain[i]);
            }
            ++i;
        }
        icsd.setCertChain(certChain);
        return icsd;
    }
}

