/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.bccms;

import cn.com.infosec.bccms.JcaSM2ContentSignerBuilder;
import cn.com.infosec.bccms.JcaSM2DigestCalculatorProviderBuilder;
import cn.com.infosec.jce.provider.JCESM2PrivateKey;
import cn.com.infosec.jce.provider.JCESM2PublicKey;
import cn.com.infosec.netsign.frame.config.ExtendedConfig;
import cn.com.infosec.oscca.sm2.SM2Certificate;
import cn.com.infosec.oscca.sm2.SM2PrivateKey;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Store;

public class BCCMSSignedDataGenerator {
    public static byte[] generateCMSSignedData(byte[] PlainText, PrivateKey priKey, X509Certificate signCert, String DigestAlg, boolean DetachedMode, String provider) throws InvalidParameterException, CertificateEncodingException, OperatorCreationException, CMSException, IOException {
        CMSProcessableByteArray msg = new CMSProcessableByteArray(PlainText);
        ArrayList<X509Certificate> list = new ArrayList<X509Certificate>();
        list.add(signCert);
        JcaCertStore certs = new JcaCertStore(list);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        ContentSigner signer = new JcaContentSignerBuilder(String.valueOf(DigestAlg) + "withRSA").setProvider(provider).build(priKey);
        JcaSignerInfoGeneratorBuilder sigb = new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(provider).build());
        gen.addSignerInfoGenerator(sigb.build(signer, signCert));
        gen.addCertificates((Store)certs);
        CMSSignedData sigData = gen.generate((CMSTypedData)msg, !DetachedMode);
        byte[] bs = sigData.getEncoded();
        return bs;
    }

    public static byte[] generateSM2CMSSignedData(byte[] PlainText, SM2PrivateKey priKey, SM2Certificate signCert, String DigestAlg, boolean DetachedMode) throws InvalidParameterException, InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException, SignatureException, CertificateEncodingException, OperatorCreationException, CMSException, IOException {
        JCESM2PrivateKey prik = new JCESM2PrivateKey(priKey.getD());
        X509Certificate cert = signCert.getX509Cert();
        JCESM2PublicKey pubk = (JCESM2PublicKey)cert.getPublicKey();
        CMSProcessableByteArray msg = new CMSProcessableByteArray(PlainText);
        ArrayList<X509Certificate> list = new ArrayList<X509Certificate>();
        list.add(cert);
        JcaCertStore certs = new JcaCertStore(list);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        JcaSM2ContentSignerBuilder singerBuilder = new JcaSM2ContentSignerBuilder(String.valueOf(DigestAlg) + "withSM2");
        singerBuilder.setPucId(ExtendedConfig.getSM3SignpucID());
        ContentSigner signer = singerBuilder.build(DigestAlg, pubk, prik);
        JcaSignerInfoGeneratorBuilder sigb = null;
        sigb = DigestAlg.indexOf("SM3") > -1 ? new JcaSignerInfoGeneratorBuilder(new JcaSM2DigestCalculatorProviderBuilder().build()) : new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider("INFOSEC").build());
        gen.addSignerInfoGenerator(sigb.build(signer, cert));
        gen.addCertificates((Store)certs);
        CMSSignedData sigData = gen.generate((CMSTypedData)msg, !DetachedMode);
        return sigData.getEncoded();
    }
}

