/*
 * Decompiled with CFR 0.152.
 */
package com.fr.performance.info;

import com.fr.general.ComparatorUtils;
import com.fr.json.JSONObject;
import com.fr.performance.info.InfoUtils;
import com.fr.performance.info.PerformanceInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourceInfo
implements PerformanceInfo,
Comparable<DataSourceInfo> {
    private String name;
    private long cellCount;
    private long executeTime;
    private long transferTime;
    private int rowCount;
    private int colCount;
    private long nextTime;
    private long buildDataTime;

    public DataSourceInfo() {
    }

    public DataSourceInfo(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public long getCellCount() {
        return this.cellCount;
    }

    public void setCellCount(long l) {
        this.cellCount = l;
    }

    public long getExecuteTime() {
        return this.executeTime;
    }

    public void setExecuteTime(long l) {
        this.executeTime = l;
    }

    public long getTransferTime() {
        return this.transferTime;
    }

    public void setTransferTime(long l) {
        this.transferTime = l;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public void setRowCount(int n) {
        this.rowCount = n;
    }

    public int getColCount() {
        return this.colCount;
    }

    public void setColCount(int n) {
        this.colCount = n;
    }

    public long getNextTime() {
        return this.nextTime;
    }

    public void setNextTime(long l) {
        this.nextTime = l;
    }

    public long getBuildDataTime() {
        return this.buildDataTime;
    }

    public void setBuildDataTime(long l) {
        this.buildDataTime = l;
    }

    public JSONObject createJSON() throws Exception {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("name", (Object)this.name);
        jSONObject.put("totalTime", this.getTotalTime() / 1000000L);
        jSONObject.put("executeTime", this.executeTime / 1000000L);
        jSONObject.put("transferTime", this.transferTime / 1000000L);
        jSONObject.put("cellCount", this.rowCount * this.colCount);
        jSONObject.put("rowCount", this.rowCount);
        jSONObject.put("colCount", this.colCount);
        jSONObject.put("buildDataTime", this.buildDataTime / 1000000L);
        return jSONObject;
    }

    private long getTotalTime() {
        return this.executeTime + this.transferTime + this.buildDataTime;
    }

    public String toString() {
        return this.toJSONString();
    }

    public void parseJSON(JSONObject jSONObject) throws Exception {
        this.setName(jSONObject.getString("name"));
        this.setExecuteTime(jSONObject.getLong("executeTime") * 1000000L);
        this.setTransferTime(jSONObject.getLong("transferTime") * 1000000L);
        this.setRowCount(jSONObject.getInt("rowCount"));
        this.setColCount(jSONObject.getInt("colCount"));
        this.setBuildDataTime(jSONObject.getLong("buildDataTime") * 1000000L);
    }

    public String toJSONString() {
        return InfoUtils.toJSONString(this);
    }

    @Override
    public int compareTo(DataSourceInfo dataSourceInfo) {
        return -ComparatorUtils.compare((double)this.getTotalTime(), (double)dataSourceInfo.getTotalTime());
    }

    public void addBuildDataTime(long l) {
        this.buildDataTime += l;
    }

    public void addNextTime(long l) {
        this.nextTime += l;
    }
}

