/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.swf;

import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.zip.InflaterInputStream;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import org.freehep.graphicsio.ImageParamConverter;
import org.freehep.graphicsio.raw.RawImageWriteParam;
import org.freehep.graphicsio.swf.DefinitionTag;
import org.freehep.graphicsio.swf.SWFInputStream;
import org.freehep.graphicsio.swf.SWFOutputStream;
import org.freehep.graphicsio.swf.SWFTag;
import org.freehep.util.UserProperties;
import org.freehep.util.images.ImageUtilities;
import org.freehep.util.io.ASCII85OutputStream;
import org.freehep.util.io.ByteOrderInputStream;
import org.freehep.util.io.FlateOutputStream;

public class DefineBitsLossless
extends DefinitionTag {
    protected int character;
    protected RenderedImage image;
    protected Color bkg;
    private byte[] imageBytes;
    public static final String rootKey = "org.freehep.graphicsio";
    public static final String COMPRESS_QUALITY = ".CompressQuality";
    public static final String PROGRESSIVE = ".Progressive";
    public static final String COMPRESS = ".Compress";
    public static final String COMPRESS_MODE = ".CompressMode";
    private static final String[] alwaysCompressedFormats = new String[]{"JPG".toLowerCase(), "JPEG".toLowerCase(), "GIF".toLowerCase()};

    public DefineBitsLossless(int n2, Image image, Color color, ImageObserver imageObserver) {
        this(n2, ImageUtilities.createRenderedImage(image, imageObserver, color), color);
    }

    public DefineBitsLossless(int n2, RenderedImage renderedImage, Color color) {
        this();
        this.character = n2;
        this.image = renderedImage;
        this.bkg = color;
    }

    public DefineBitsLossless() {
        super(20, 2);
    }

    protected DefineBitsLossless(int n2, int n3) {
        super(n2, n3);
    }

    public SWFTag read(int n2, SWFInputStream sWFInputStream, int n3) throws IOException {
        DefineBitsLossless defineBitsLossless = new DefineBitsLossless();
        defineBitsLossless.read(n2, sWFInputStream, n3, false);
        return defineBitsLossless;
    }

    protected void read(int n2, SWFInputStream sWFInputStream, int n3, boolean bl) throws IOException {
        this.character = sWFInputStream.readUnsignedShort();
        sWFInputStream.getDictionary().put(this.character, this);
        int n4 = sWFInputStream.readUnsignedByte();
        int n5 = sWFInputStream.readUnsignedShort();
        int n6 = sWFInputStream.readUnsignedShort();
        int n7 = n4 == 3 ? sWFInputStream.readUnsignedByte() + 1 : 0;
        InflaterInputStream inflaterInputStream = new InflaterInputStream(sWFInputStream);
        ByteOrderInputStream byteOrderInputStream = new ByteOrderInputStream(inflaterInputStream, true);
        int[][] nArray = new int[n7][bl ? 4 : 3];
        int n8 = 0;
        while (n8 < n7) {
            nArray[n8][0] = inflaterInputStream.read();
            nArray[n8][1] = inflaterInputStream.read();
            nArray[n8][2] = inflaterInputStream.read();
            if (bl) {
                nArray[n8][3] = inflaterInputStream.read();
            }
            ++n8;
        }
        BufferedImage bufferedImage = new BufferedImage(n5, n6, bl ? 2 : 1);
        WritableRaster writableRaster = bufferedImage.getRaster();
        int[] nArray2 = new int[bl ? 4 : 3];
        int n9 = 0;
        while (n9 < n6) {
            int n10 = 0;
            while (n10 < n5) {
                switch (n4) {
                    default: {
                        System.out.println("ERROR: unknown format in LossLess image: " + n4);
                        return;
                    }
                    case 3: {
                        writableRaster.setPixel(n10, n9, nArray[byteOrderInputStream.readUnsignedByte()]);
                        break;
                    }
                    case 4: {
                        if (bl) {
                            System.out.println("ERROR: unknown format in LossLess2 image: 4");
                            return;
                        }
                        byteOrderInputStream.readUBits(1);
                        nArray2[0] = (int)byteOrderInputStream.readUBits(5);
                        nArray2[1] = (int)byteOrderInputStream.readUBits(5);
                        nArray2[2] = (int)byteOrderInputStream.readUBits(5);
                        writableRaster.setPixel(n10, n9, nArray2);
                        break;
                    }
                    case 5: {
                        if (bl) {
                            nArray2[3] = byteOrderInputStream.readUnsignedByte();
                        } else {
                            byteOrderInputStream.readUnsignedByte();
                        }
                        nArray2[0] = byteOrderInputStream.readUnsignedByte();
                        nArray2[1] = byteOrderInputStream.readUnsignedByte();
                        nArray2[2] = byteOrderInputStream.readUnsignedByte();
                        writableRaster.setPixel(n10, n9, nArray2);
                    }
                }
                ++n10;
            }
            ++n9;
        }
        this.image = bufferedImage;
    }

    public void write(int n2, SWFOutputStream sWFOutputStream) throws IOException {
        this.write(n2, sWFOutputStream, false);
    }

    protected void write(int n2, SWFOutputStream sWFOutputStream, boolean bl) throws IOException {
        sWFOutputStream.writeUnsignedShort(this.character);
        sWFOutputStream.writeUnsignedByte(5);
        sWFOutputStream.writeUnsignedShort(this.image.getWidth());
        sWFOutputStream.writeUnsignedShort(this.image.getHeight());
        sWFOutputStream.write(this.getImageBytes());
    }

    public int getLength() throws IOException {
        return this.getImageBytes().length + 7;
    }

    private byte[] getImageBytes() throws IOException {
        if (this.imageBytes == null) {
            this.imageBytes = DefineBitsLossless.toByteArray(this.image, "RAW", "Flate", DefineBitsLossless.getRAWProperties(this.bkg, "*ARGB"));
        }
        return this.imageBytes;
    }

    public static UserProperties getRAWProperties(Color color, String string) {
        UserProperties userProperties = new UserProperties();
        userProperties.setProperty(RawImageWriteParam.BACKGROUND, color);
        userProperties.setProperty(RawImageWriteParam.CODE, string);
        userProperties.setProperty(RawImageWriteParam.PAD, 1);
        return userProperties;
    }

    public static byte[] toByteArray(RenderedImage renderedImage, String string, String string2, Properties properties) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStream outputStream = byteArrayOutputStream;
        if ("ASCII85".equals(string2) || "Flate-ASCII85".equals(string2)) {
            outputStream = new ASCII85OutputStream(outputStream);
        }
        if ("Flate".equals(string2) || "Flate-ASCII85".equals(string2)) {
            outputStream = new FlateOutputStream(outputStream);
        }
        if (properties == null) {
            properties = new Properties();
        }
        DefineBitsLossless.writeImage(renderedImage, string.toLowerCase(), properties, outputStream);
        outputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public static void writeImage(RenderedImage renderedImage, String string, Properties properties, OutputStream outputStream) throws IOException {
        ImageWriter imageWriter = DefineBitsLossless.getPreferredImageWriter(string);
        if (imageWriter == null) {
            throw new IOException(": No writer for format '" + string + "'.");
        }
        UserProperties userProperties = new UserProperties(properties);
        ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
        if (imageWriteParam instanceof ImageParamConverter) {
            imageWriteParam = ((ImageParamConverter)((Object)imageWriteParam)).getWriteParam(userProperties);
        }
        String string2 = "org.freehep.graphicsio." + string;
        if (imageWriteParam.canWriteCompressed()) {
            if (userProperties.isProperty(String.valueOf(string2) + COMPRESS)) {
                if (userProperties.getProperty(String.valueOf(string2) + COMPRESS_MODE).equals("")) {
                    imageWriteParam.setCompressionMode(1);
                } else {
                    imageWriteParam.setCompressionMode(2);
                    imageWriteParam.setCompressionType(userProperties.getProperty(String.valueOf(string2) + COMPRESS_MODE));
                    imageWriteParam.setCompressionQuality(userProperties.getPropertyFloat(String.valueOf(string2) + COMPRESS_QUALITY));
                }
            } else if (DefineBitsLossless.canWriteUncompressed(string)) {
                imageWriteParam.setCompressionMode(0);
            }
        }
        if (imageWriteParam.canWriteProgressive()) {
            if (userProperties.isProperty(String.valueOf(string2) + PROGRESSIVE)) {
                imageWriteParam.setProgressiveMode(1);
            } else {
                imageWriteParam.setProgressiveMode(0);
            }
        }
        ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(outputStream);
        imageWriter.setOutput(imageOutputStream);
        imageWriter.write(null, new IIOImage(renderedImage, null, null), imageWriteParam);
        imageWriter.dispose();
        imageOutputStream.close();
    }

    public static boolean canWriteUncompressed(String string) {
        return !Arrays.asList(alwaysCompressedFormats).contains(string.toLowerCase());
    }

    public static ImageWriter getPreferredImageWriter(String string) {
        return (ImageWriter)DefineBitsLossless.getImageWriters(ImageIO.getImageWritersByFormatName(string)).first();
    }

    public static SortedSet getImageWriters(Iterator iterator) {
        TreeSet treeSet = new TreeSet(new Comparator(){

            private int order(Object object) {
                String string = object.getClass().getName();
                if (string.startsWith("org.freehep.")) {
                    return 0;
                }
                if (string.startsWith("com.sun.imageio.")) {
                    return 1;
                }
                if (string.startsWith("com.sun.media.")) {
                    return 2;
                }
                return 3;
            }

            public int compare(Object object, Object object2) {
                int n2;
                int n3 = this.order(object);
                return n3 < (n2 = this.order(object2)) ? -1 : (n3 > n2 ? 1 : 0);
            }
        });
        while (iterator.hasNext()) {
            treeSet.add(iterator.next());
        }
        return treeSet;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.valueOf(super.toString()) + "\n");
        stringBuffer.append("  character:  " + this.character);
        stringBuffer.append("  image: " + this.image);
        return stringBuffer.toString();
    }
}

