/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.font;

import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphMetrics;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.freehep.graphics2d.font.CharTable;
import org.freehep.graphicsio.font.CharstringEncoder;
import org.freehep.graphicsio.font.FontEmbedder;
import org.freehep.util.io.ASCIIHexOutputStream;
import org.freehep.util.io.CountedByteOutputStream;
import org.freehep.util.io.EEXECEncryption;

public class FontEmbedderType1
extends FontEmbedder {
    private static final boolean ENCRYPT = true;
    private static final boolean HEX_ENC = true;
    private static final boolean HEX_ENC_CHARSTRINGS = false;
    private PrintStream fontFile;
    private PrintStream encrypted;
    private CountedByteOutputStream byteCounter;
    private int asciiEnd;
    private int encEnd;
    private boolean addZeros;

    public FontEmbedderType1(FontRenderContext fontRenderContext, OutputStream outputStream, boolean bl) {
        super(fontRenderContext);
        this.byteCounter = new CountedByteOutputStream(outputStream);
        this.fontFile = new PrintStream(this.byteCounter);
        this.addZeros = bl;
        this.encEnd = -1;
        this.asciiEnd = -1;
    }

    protected void writeWidths(double[] dArray) throws IOException {
    }

    protected void writeEncoding(CharTable charTable) throws IOException {
        this.fontFile.println("/Encoding 256 array");
        this.fontFile.println("0 1 255 {1 index exch /.notdef put} for");
        for (int i2 = 0; i2 < 256; ++i2) {
            String string = charTable.toName(i2);
            if (string == null) continue;
            this.fontFile.println("dup " + i2 + " /" + string + " put");
        }
        this.fontFile.println("readonly def");
    }

    protected void openIncludeFont() throws IOException {
        this.fontFile.println("%!FontType1-1.0: " + this.getFont().getName());
        this.fontFile.println("% Generated by: " + this.getClass().getName());
        this.fontFile.println("11 dict begin");
        this.fontFile.println("/FontInfo 8 dict dup begin");
        this.fontFile.println("/FullName (" + this.getFont().getPSName() + ") readonly def");
        this.fontFile.println("/FamilyName (" + this.getFont().getFamily() + ") readonly def");
        this.fontFile.println("end readonly def");
        this.fontFile.println("/FontName /" + this.getFontName() + " def");
        this.fontFile.println("/PaintType 0 def");
        this.fontFile.println("/FontType 1 def");
        this.fontFile.println("/FontMatrix [0.0010 0.0 0.0 0.0010 0.0 0.0] readonly def");
    }

    protected void closeIncludeFont() {
        Rectangle2D rectangle2D = this.getFontBBox();
        int n2 = (int)Math.round(rectangle2D.getX());
        int n3 = (int)Math.round(rectangle2D.getY());
        int n4 = (int)Math.round(rectangle2D.getX() + rectangle2D.getWidth());
        int n5 = (int)Math.round(rectangle2D.getY() + rectangle2D.getHeight());
        this.fontFile.println("/FontBBox {" + n2 + " " + n3 + " " + n4 + " " + n5 + "} readonly def");
        this.fontFile.println("currentdict end");
        this.fontFile.print("currentfile eexec ");
        this.asciiEnd = this.byteCounter.getCount();
        this.fontFile.flush();
    }

    protected void openGlyphs() throws IOException {
        this.encrypted = new PrintStream(new EEXECEncryption(new ASCIIHexOutputStream(this.fontFile), 55665));
        this.encrypted.println("dup /Private 8 dict dup begin");
        this.encrypted.println("/RD {string currentfile exch readstring pop} executeonly def");
        this.encrypted.println("/ND {noaccess def} executeonly def");
        this.encrypted.println("/NP {noaccess put} executeonly def");
        this.encrypted.println("/BlueValues [] def");
        this.encrypted.println("/MinFeature {16 16} def");
        this.encrypted.println("/password 5839 def");
        this.encrypted.print("2 index ");
        this.encrypted.println("/CharStrings " + (this.getNODefinedChars() + 1) + " dict dup begin");
    }

    protected void closeGlyphs() throws IOException {
        this.encrypted.println("end");
        this.encrypted.println("end");
    }

    protected void closeEmbedFont() throws IOException {
        this.encrypted.println("readonly put");
        this.encrypted.println("noaccess put");
        this.encrypted.println("dup /FontName get exch definefont pop");
        this.encrypted.print("mark");
        this.encrypted.print(" currentfile closefile ");
        this.encrypted.flush();
        this.encEnd = this.byteCounter.getCount();
        if (this.addZeros) {
            this.fontFile.println();
            for (int i2 = 0; i2 < 16; ++i2) {
                this.fontFile.println("00000000000000000000000000000000");
            }
            this.fontFile.println("cleartomark");
        }
    }

    protected void writeGlyph(String string, Shape shape, GlyphMetrics glyphMetrics) throws IOException {
        double d2 = glyphMetrics != null ? (double)glyphMetrics.getLSB() : 0.0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        CharstringEncoder charstringEncoder = new CharstringEncoder(new EEXECEncryption(byteArrayOutputStream, 4330));
        charstringEncoder.startChar(d2, glyphMetrics != null ? (double)glyphMetrics.getAdvance() : this.getUndefinedWidth());
        charstringEncoder.drawPath(shape);
        charstringEncoder.endchar();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        this.encrypted.print("/" + string + " " + byArray.length + " RD ");
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            this.encrypted.write(byArray[i2] & 0xFF);
        }
        this.encrypted.println("ND");
        this.encrypted.flush();
    }

    public int getAsciiLength() {
        return this.asciiEnd;
    }

    public int getEncryptedLength() {
        return this.encEnd - this.asciiEnd;
    }
}

