/*
 * Decompiled with CFR 0.152.
 */
package com.fr.zip4j.crypto;

import com.fr.zip4j.crypto.IDecrypter;
import com.fr.zip4j.crypto.engine.ZipCryptoEngine;
import com.fr.zip4j.exception.ZipException;
import com.fr.zip4j.model.FileHeader;

public class StandardDecrypter
implements IDecrypter {
    private FileHeader fileHeader;
    private byte[] crc = new byte[4];
    private ZipCryptoEngine zipCryptoEngine;

    public StandardDecrypter(FileHeader fileHeader, byte[] byArray) throws ZipException {
        if (fileHeader == null) {
            throw new ZipException("one of more of the input parameters were null in StandardDecryptor");
        }
        this.fileHeader = fileHeader;
        this.zipCryptoEngine = new ZipCryptoEngine();
        this.init(byArray);
    }

    public int decryptData(byte[] byArray) throws ZipException {
        return this.decryptData(byArray, 0, byArray.length);
    }

    public int decryptData(byte[] byArray, int n2, int n3) throws ZipException {
        if (n2 < 0 || n3 < 0) {
            throw new ZipException("one of the input parameters were null in standard decrpyt data");
        }
        try {
            for (int i2 = n2; i2 < n2 + n3; ++i2) {
                int n4 = byArray[i2] & 0xFF;
                n4 = (n4 ^ this.zipCryptoEngine.decryptByte()) & 0xFF;
                this.zipCryptoEngine.updateKeys((byte)n4);
                byArray[i2] = (byte)n4;
            }
            return n3;
        }
        catch (Exception exception) {
            throw new ZipException(exception);
        }
    }

    public void init(byte[] byArray) throws ZipException {
        byte[] byArray2 = this.fileHeader.getCrcBuff();
        this.crc[3] = (byte)(byArray2[3] & 0xFF);
        this.crc[2] = (byte)(byArray2[3] >> 8 & 0xFF);
        this.crc[1] = (byte)(byArray2[3] >> 16 & 0xFF);
        this.crc[0] = (byte)(byArray2[3] >> 24 & 0xFF);
        if (this.crc[2] > 0 || this.crc[1] > 0 || this.crc[0] > 0) {
            throw new IllegalStateException("Invalid CRC in File Header");
        }
        if (this.fileHeader.getPassword() == null || this.fileHeader.getPassword().length <= 0) {
            throw new ZipException("Wrong password!", 5);
        }
        this.zipCryptoEngine.initKeys(this.fileHeader.getPassword());
        try {
            byte by = byArray[0];
            for (int i2 = 0; i2 < 12; ++i2) {
                this.zipCryptoEngine.updateKeys((byte)(by ^ this.zipCryptoEngine.decryptByte()));
                if (i2 + 1 == 12) continue;
                by = byArray[i2 + 1];
            }
        }
        catch (Exception exception) {
            throw new ZipException(exception);
        }
    }
}

