/*
 * Decompiled with CFR 0.152.
 */
package com.fr.zip4j.crypto.PBKDF2;

import com.fr.zip4j.crypto.PBKDF2.PRF;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class MacBasedPRF
implements PRF {
    protected Mac mac;
    protected int hLen;
    protected String macAlgorithm;

    public MacBasedPRF(String string) {
        this.macAlgorithm = string;
        try {
            this.mac = Mac.getInstance(string);
            this.hLen = this.mac.getMacLength();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        }
    }

    public MacBasedPRF(String string, String string2) {
        this.macAlgorithm = string;
        try {
            this.mac = Mac.getInstance(string, string2);
            this.hLen = this.mac.getMacLength();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new RuntimeException(noSuchProviderException);
        }
    }

    public byte[] doFinal(byte[] byArray) {
        byte[] byArray2 = this.mac.doFinal(byArray);
        return byArray2;
    }

    public byte[] doFinal() {
        byte[] byArray = this.mac.doFinal();
        return byArray;
    }

    public int getHLen() {
        return this.hLen;
    }

    public void init(byte[] byArray) {
        try {
            this.mac.init(new SecretKeySpec(byArray, this.macAlgorithm));
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new RuntimeException(invalidKeyException);
        }
    }

    public void update(byte[] byArray) {
        try {
            this.mac.update(byArray);
        }
        catch (IllegalStateException illegalStateException) {
            throw new RuntimeException(illegalStateException);
        }
    }

    public void update(byte[] byArray, int n2, int n3) {
        try {
            this.mac.update(byArray, n2, n3);
        }
        catch (IllegalStateException illegalStateException) {
            throw new RuntimeException(illegalStateException);
        }
    }
}

