/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.javax.xml.stream.xerces.impl.io;

import com.fr.third.javax.xml.stream.util.BufferAllocator;
import com.fr.third.javax.xml.stream.util.ThreadLocalBufferAllocator;
import com.fr.third.javax.xml.stream.xerces.impl.msg.XMLMessageFormatter;
import com.fr.third.javax.xml.stream.xerces.util.MessageFormatter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UTFDataFormatException;
import java.util.Locale;

public class UTF8Reader
extends Reader {
    public static final int DEFAULT_BUFFER_SIZE = 2048;
    private static final boolean DEBUG_READ = false;
    protected InputStream fInputStream;
    protected byte[] fBuffer;
    protected int fOffset;
    private int fSurrogate = -1;
    private MessageFormatter fFormatter = null;
    private Locale fLocale = null;

    public UTF8Reader(InputStream inputStream) {
        this(inputStream, 2048, new XMLMessageFormatter(), Locale.getDefault());
    }

    public UTF8Reader(InputStream inputStream, MessageFormatter messageFormatter, Locale locale) {
        this(inputStream, 2048, messageFormatter, locale);
    }

    public UTF8Reader(InputStream inputStream, int n2, MessageFormatter messageFormatter, Locale locale) {
        this.fInputStream = inputStream;
        this.fFormatter = messageFormatter;
        this.fLocale = locale;
        BufferAllocator bufferAllocator = ThreadLocalBufferAllocator.getBufferAllocator();
        this.fBuffer = bufferAllocator.getByteBuffer(n2);
        if (this.fBuffer == null) {
            this.fBuffer = new byte[n2];
        }
    }

    public int read() throws IOException {
        int n2 = this.fSurrogate;
        if (this.fSurrogate == -1) {
            int n3;
            int n4 = 0;
            int n5 = n3 = n4 == this.fOffset ? this.fInputStream.read() : this.fBuffer[n4++] & 0xFF;
            if (n3 == -1) {
                return -1;
            }
            if (n3 < 128) {
                n2 = (char)n3;
            } else if ((n3 & 0xE0) == 192) {
                int n6;
                int n7 = n6 = n4 == this.fOffset ? this.fInputStream.read() : this.fBuffer[n4++] & 0xFF;
                if (n6 == -1) {
                    this.expectedByte(2, 2);
                }
                if ((n6 & 0xC0) != 128) {
                    this.invalidByte(2, 2, n6);
                }
                n2 = n3 << 6 & 0x7C0 | n6 & 0x3F;
            } else if ((n3 & 0xF0) == 224) {
                int n8;
                int n9;
                int n10 = n9 = n4 == this.fOffset ? this.fInputStream.read() : this.fBuffer[n4++] & 0xFF;
                if (n9 == -1) {
                    this.expectedByte(2, 3);
                }
                if ((n9 & 0xC0) != 128) {
                    this.invalidByte(2, 3, n9);
                }
                int n11 = n8 = n4 == this.fOffset ? this.fInputStream.read() : this.fBuffer[n4++] & 0xFF;
                if (n8 == -1) {
                    this.expectedByte(3, 3);
                }
                if ((n8 & 0xC0) != 128) {
                    this.invalidByte(3, 3, n8);
                }
                n2 = n3 << 12 & 0xF000 | n9 << 6 & 0xFC0 | n8 & 0x3F;
            } else if ((n3 & 0xF8) == 240) {
                int n12;
                int n13;
                int n14;
                int n15;
                int n16 = n15 = n4 == this.fOffset ? this.fInputStream.read() : this.fBuffer[n4++] & 0xFF;
                if (n15 == -1) {
                    this.expectedByte(2, 4);
                }
                if ((n15 & 0xC0) != 128) {
                    this.invalidByte(2, 3, n15);
                }
                int n17 = n14 = n4 == this.fOffset ? this.fInputStream.read() : this.fBuffer[n4++] & 0xFF;
                if (n14 == -1) {
                    this.expectedByte(3, 4);
                }
                if ((n14 & 0xC0) != 128) {
                    this.invalidByte(3, 3, n14);
                }
                int n18 = n13 = n4 == this.fOffset ? this.fInputStream.read() : this.fBuffer[n4++] & 0xFF;
                if (n13 == -1) {
                    this.expectedByte(4, 4);
                }
                if ((n13 & 0xC0) != 128) {
                    this.invalidByte(4, 4, n13);
                }
                if ((n12 = n3 << 2 & 0x1C | n15 >> 4 & 3) > 16) {
                    this.invalidSurrogate(n12);
                }
                int n19 = n12 - 1;
                int n20 = 0xD800 | n19 << 6 & 0x3C0 | n15 << 2 & 0x3C | n14 >> 4 & 3;
                int n21 = 0xDC00 | n14 << 6 & 0x3C0 | n13 & 0x3F;
                n2 = n20;
                this.fSurrogate = n21;
            } else {
                this.invalidByte(1, 1, n3);
            }
        } else {
            this.fSurrogate = -1;
        }
        return n2;
    }

    public int read(char[] cArray, int n2, int n3) throws IOException {
        int n4;
        int n5 = n2;
        if (this.fSurrogate != -1) {
            cArray[n2 + 1] = (char)this.fSurrogate;
            this.fSurrogate = -1;
            --n3;
            ++n5;
        }
        int n6 = 0;
        if (this.fOffset == 0) {
            if (n3 > this.fBuffer.length) {
                n3 = this.fBuffer.length;
            }
            if ((n6 = this.fInputStream.read(this.fBuffer, 0, n3)) == -1) {
                return -1;
            }
            n6 += n5 - n2;
        } else {
            n6 = this.fOffset;
            this.fOffset = 0;
        }
        int n7 = n6;
        boolean bl = true;
        int n8 = 0;
        n8 = 0;
        while (n8 < n7) {
            n4 = this.fBuffer[n8] & 0xFF;
            if (n4 >= 128) {
                bl = false;
                break;
            }
            cArray[n5++] = (char)n4;
            ++n8;
        }
        if (bl) {
            return n6;
        }
        n4 = n8;
        while (n4 < n7) {
            int n9;
            int n10;
            int n11;
            int n12 = this.fBuffer[n4] & 0xFF;
            if (n12 < 128) {
                cArray[n5++] = (char)n12;
            } else if ((n12 & 0xE0) == 192) {
                n11 = -1;
                if (++n4 < n7) {
                    n11 = this.fBuffer[n4] & 0xFF;
                } else {
                    n11 = this.fInputStream.read();
                    if (n11 == -1) {
                        if (n5 > n2) {
                            this.fBuffer[0] = (byte)n12;
                            this.fOffset = 1;
                            return n5 - n2;
                        }
                        this.expectedByte(2, 2);
                    }
                    ++n6;
                }
                if ((n11 & 0xC0) != 128) {
                    if (n5 > n2) {
                        this.fBuffer[0] = (byte)n12;
                        this.fBuffer[1] = (byte)n11;
                        this.fOffset = 2;
                        return n5 - n2;
                    }
                    this.invalidByte(2, 2, n11);
                }
                n10 = n12 << 6 & 0x7C0 | n11 & 0x3F;
                cArray[n5++] = (char)n10;
                --n6;
            } else if ((n12 & 0xF0) == 224) {
                n11 = -1;
                if (++n4 < n7) {
                    n11 = this.fBuffer[n4] & 0xFF;
                } else {
                    n11 = this.fInputStream.read();
                    if (n11 == -1) {
                        if (n5 > n2) {
                            this.fBuffer[0] = (byte)n12;
                            this.fOffset = 1;
                            return n5 - n2;
                        }
                        this.expectedByte(2, 3);
                    }
                    ++n6;
                }
                if ((n11 & 0xC0) != 128) {
                    if (n5 > n2) {
                        this.fBuffer[0] = (byte)n12;
                        this.fBuffer[1] = (byte)n11;
                        this.fOffset = 2;
                        return n5 - n2;
                    }
                    this.invalidByte(2, 3, n11);
                }
                n10 = -1;
                if (++n4 < n7) {
                    n10 = this.fBuffer[n4] & 0xFF;
                } else {
                    n10 = this.fInputStream.read();
                    if (n10 == -1) {
                        if (n5 > n2) {
                            this.fBuffer[0] = (byte)n12;
                            this.fBuffer[1] = (byte)n11;
                            this.fOffset = 2;
                            return n5 - n2;
                        }
                        this.expectedByte(3, 3);
                    }
                    ++n6;
                }
                if ((n10 & 0xC0) != 128) {
                    if (n5 > n2) {
                        this.fBuffer[0] = (byte)n12;
                        this.fBuffer[1] = (byte)n11;
                        this.fBuffer[2] = (byte)n10;
                        this.fOffset = 3;
                        return n5 - n2;
                    }
                    this.invalidByte(3, 3, n10);
                }
                n9 = n12 << 12 & 0xF000 | n11 << 6 & 0xFC0 | n10 & 0x3F;
                cArray[n5++] = (char)n9;
                n6 -= 2;
            } else if ((n12 & 0xF8) == 240) {
                int n13;
                n11 = -1;
                if (++n4 < n7) {
                    n11 = this.fBuffer[n4] & 0xFF;
                } else {
                    n11 = this.fInputStream.read();
                    if (n11 == -1) {
                        if (n5 > n2) {
                            this.fBuffer[0] = (byte)n12;
                            this.fOffset = 1;
                            return n5 - n2;
                        }
                        this.expectedByte(2, 4);
                    }
                    ++n6;
                }
                if ((n11 & 0xC0) != 128) {
                    if (n5 > n2) {
                        this.fBuffer[0] = (byte)n12;
                        this.fBuffer[1] = (byte)n11;
                        this.fOffset = 2;
                        return n5 - n2;
                    }
                    this.invalidByte(2, 4, n11);
                }
                n10 = -1;
                if (++n4 < n7) {
                    n10 = this.fBuffer[n4] & 0xFF;
                } else {
                    n10 = this.fInputStream.read();
                    if (n10 == -1) {
                        if (n5 > n2) {
                            this.fBuffer[0] = (byte)n12;
                            this.fBuffer[1] = (byte)n11;
                            this.fOffset = 2;
                            return n5 - n2;
                        }
                        this.expectedByte(3, 4);
                    }
                    ++n6;
                }
                if ((n10 & 0xC0) != 128) {
                    if (n5 > n2) {
                        this.fBuffer[0] = (byte)n12;
                        this.fBuffer[1] = (byte)n11;
                        this.fBuffer[2] = (byte)n10;
                        this.fOffset = 3;
                        return n5 - n2;
                    }
                    this.invalidByte(3, 4, n10);
                }
                n9 = -1;
                if (++n4 < n7) {
                    n9 = this.fBuffer[n4] & 0xFF;
                } else {
                    n9 = this.fInputStream.read();
                    if (n9 == -1) {
                        if (n5 > n2) {
                            this.fBuffer[0] = (byte)n12;
                            this.fBuffer[1] = (byte)n11;
                            this.fBuffer[2] = (byte)n10;
                            this.fOffset = 3;
                            return n5 - n2;
                        }
                        this.expectedByte(4, 4);
                    }
                    ++n6;
                }
                if ((n9 & 0xC0) != 128) {
                    if (n5 > n2) {
                        this.fBuffer[0] = (byte)n12;
                        this.fBuffer[1] = (byte)n11;
                        this.fBuffer[2] = (byte)n10;
                        this.fBuffer[3] = (byte)n9;
                        this.fOffset = 4;
                        return n5 - n2;
                    }
                    this.invalidByte(4, 4, n10);
                }
                if ((n13 = n12 << 2 & 0x1C | n11 >> 4 & 3) > 16) {
                    this.invalidSurrogate(n13);
                }
                int n14 = n13 - 1;
                int n15 = n11 & 0xF;
                int n16 = n10 & 0x3F;
                int n17 = n9 & 0x3F;
                int n18 = 0xD800 | n14 << 6 & 0x3C0 | n15 << 2 | n16 >> 4;
                int n19 = 0xDC00 | n16 << 6 & 0x3C0 | n17;
                cArray[n5++] = (char)n18;
                cArray[n5++] = (char)n19;
                n6 -= 2;
            } else {
                if (n5 > n2) {
                    this.fBuffer[0] = (byte)n12;
                    this.fOffset = 1;
                    return n5 - n2;
                }
                this.invalidByte(1, 1, n12);
            }
            ++n4;
        }
        return n6;
    }

    public long skip(long l2) throws IOException {
        int n2;
        int n3;
        long l3 = l2;
        char[] cArray = new char[this.fBuffer.length];
        while ((n3 = this.read(cArray, 0, n2 = (long)cArray.length < l3 ? cArray.length : (int)l3)) > 0 && (l3 -= (long)n3) > 0L) {
        }
        long l4 = l2 - l3;
        return l4;
    }

    public boolean ready() throws IOException {
        return false;
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int n2) throws IOException {
        throw new IOException(this.fFormatter.formatMessage(this.fLocale, "OperationNotSupported", new Object[]{"mark()", "UTF-8"}));
    }

    public void reset() throws IOException {
        this.fOffset = 0;
        this.fSurrogate = -1;
    }

    public void close() throws IOException {
        BufferAllocator bufferAllocator = ThreadLocalBufferAllocator.getBufferAllocator();
        bufferAllocator.returnByteBuffer(this.fBuffer);
        this.fBuffer = null;
        this.fInputStream.close();
    }

    private void expectedByte(int n2, int n3) throws UTFDataFormatException {
        String string = this.fFormatter.formatMessage(this.fLocale, "ExpectedByte", new Object[]{Integer.toString(n2), Integer.toString(n3)});
        throw new UTFDataFormatException(string);
    }

    private void invalidByte(int n2, int n3, int n4) throws UTFDataFormatException {
        String string = this.fFormatter.formatMessage(this.fLocale, "InvalidByte", new Object[]{Integer.toString(n2), Integer.toString(n3)});
        throw new UTFDataFormatException(string);
    }

    private void invalidSurrogate(int n2) throws UTFDataFormatException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("high surrogate bits in UTF-8 sequence must not exceed 0x10 but found 0x");
        String string = this.fFormatter.formatMessage(this.fLocale, "InvalidHighSurrogate", new Object[]{Integer.toHexString(n2)});
        throw new UTFDataFormatException(string);
    }
}

