/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.javax.xml.stream.events;

import com.fr.third.javax.xml.namespace.QName;
import com.fr.third.javax.xml.stream.XMLStreamException;
import com.fr.third.javax.xml.stream.XMLStreamReader;
import com.fr.third.javax.xml.stream.events.AttributeImpl;
import com.fr.third.javax.xml.stream.events.CharacterEvent;
import com.fr.third.javax.xml.stream.events.CommentEvent;
import com.fr.third.javax.xml.stream.events.DTDEvent;
import com.fr.third.javax.xml.stream.events.DummyEvent;
import com.fr.third.javax.xml.stream.events.EndDocumentEvent;
import com.fr.third.javax.xml.stream.events.EndElementEvent;
import com.fr.third.javax.xml.stream.events.EntityDeclarationImpl;
import com.fr.third.javax.xml.stream.events.EntityReferenceEvent;
import com.fr.third.javax.xml.stream.events.NamespaceImpl;
import com.fr.third.javax.xml.stream.events.ProcessingInstructionEvent;
import com.fr.third.javax.xml.stream.events.StartDocumentEvent;
import com.fr.third.javax.xml.stream.events.StartElementEvent;
import com.fr.third.javax.xml.stream.events.XMLEvent;
import com.fr.third.javax.xml.stream.util.XMLEventAllocator;
import com.fr.third.javax.xml.stream.util.XMLEventConsumer;
import com.fr.third.javax.xml.stream.xerces.util.NamespaceContextWrapper;
import com.fr.third.javax.xml.stream.xerces.util.NamespaceSupport;

public class XMLEventAllocatorImpl
implements XMLEventAllocator {
    public XMLEvent allocate(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        if (xMLStreamReader == null) {
            throw new XMLStreamException("Reader cannot be null");
        }
        return this.getXMLEvent(xMLStreamReader);
    }

    public void allocate(XMLStreamReader xMLStreamReader, XMLEventConsumer xMLEventConsumer) throws XMLStreamException {
        XMLEvent xMLEvent = this.getXMLEvent(xMLStreamReader);
        if (xMLEvent != null) {
            xMLEventConsumer.add(xMLEvent);
        }
    }

    public XMLEventAllocator newInstance() {
        return new XMLEventAllocatorImpl();
    }

    XMLEvent getXMLEvent(XMLStreamReader xMLStreamReader) {
        DummyEvent dummyEvent = null;
        int n2 = xMLStreamReader.getEventType();
        switch (n2) {
            case 1: {
                StartElementEvent startElementEvent = new StartElementEvent(this.getQName(xMLStreamReader));
                this.fillAttributes(startElementEvent, xMLStreamReader);
                if (((Boolean)xMLStreamReader.getProperty("com.fr.third.javax.xml.stream.isNamespaceAware")).booleanValue()) {
                    this.fillNamespaceAttributes(startElementEvent, xMLStreamReader);
                    this.setNamespaceContext(startElementEvent, xMLStreamReader);
                }
                startElementEvent.setLocation(xMLStreamReader.getLocation());
                dummyEvent = startElementEvent;
                break;
            }
            case 2: {
                EndElementEvent endElementEvent = new EndElementEvent(this.getQName(xMLStreamReader));
                endElementEvent.setLocation(xMLStreamReader.getLocation());
                if (((Boolean)xMLStreamReader.getProperty("com.fr.third.javax.xml.stream.isNamespaceAware")).booleanValue()) {
                    this.fillNamespaceAttributes(endElementEvent, xMLStreamReader);
                }
                dummyEvent = endElementEvent;
                break;
            }
            case 3: {
                ProcessingInstructionEvent processingInstructionEvent = new ProcessingInstructionEvent(xMLStreamReader.getPITarget(), xMLStreamReader.getPIData());
                processingInstructionEvent.setLocation(xMLStreamReader.getLocation());
                dummyEvent = processingInstructionEvent;
                break;
            }
            case 4: {
                CharacterEvent characterEvent = new CharacterEvent(xMLStreamReader.getText());
                characterEvent.setLocation(xMLStreamReader.getLocation());
                dummyEvent = characterEvent;
                break;
            }
            case 5: {
                CommentEvent commentEvent = new CommentEvent(xMLStreamReader.getText());
                commentEvent.setLocation(xMLStreamReader.getLocation());
                dummyEvent = commentEvent;
                break;
            }
            case 7: {
                StartDocumentEvent startDocumentEvent = new StartDocumentEvent();
                startDocumentEvent.setVersion(xMLStreamReader.getVersion());
                startDocumentEvent.setEncoding(xMLStreamReader.getEncoding());
                if (xMLStreamReader.getCharacterEncodingScheme() != null) {
                    startDocumentEvent.setDeclaredEncoding(true);
                } else {
                    startDocumentEvent.setDeclaredEncoding(false);
                }
                startDocumentEvent.setStandalone(xMLStreamReader.isStandalone());
                startDocumentEvent.setLocation(xMLStreamReader.getLocation());
                dummyEvent = startDocumentEvent;
                break;
            }
            case 8: {
                EndDocumentEvent endDocumentEvent = new EndDocumentEvent();
                endDocumentEvent.setLocation(xMLStreamReader.getLocation());
                dummyEvent = endDocumentEvent;
                break;
            }
            case 9: {
                EntityReferenceEvent entityReferenceEvent = new EntityReferenceEvent(xMLStreamReader.getLocalName(), new EntityDeclarationImpl(xMLStreamReader.getLocalName(), xMLStreamReader.getText()));
                entityReferenceEvent.setLocation(xMLStreamReader.getLocation());
                dummyEvent = entityReferenceEvent;
                break;
            }
            case 10: {
                dummyEvent = null;
                break;
            }
            case 11: {
                dummyEvent = new DTDEvent(xMLStreamReader.getText());
                break;
            }
            case 12: {
                CharacterEvent characterEvent = new CharacterEvent(xMLStreamReader.getText(), true);
                characterEvent.setLocation(xMLStreamReader.getLocation());
                dummyEvent = characterEvent;
                break;
            }
            case 6: {
                CharacterEvent characterEvent = new CharacterEvent(xMLStreamReader.getText(), false, true);
                characterEvent.setLocation(xMLStreamReader.getLocation());
                dummyEvent = characterEvent;
            }
        }
        return dummyEvent;
    }

    protected XMLEvent getNextEvent(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        xMLStreamReader.next();
        return this.getXMLEvent(xMLStreamReader);
    }

    protected void fillAttributes(StartElementEvent startElementEvent, XMLStreamReader xMLStreamReader) {
        int n2 = xMLStreamReader.getAttributeCount();
        QName qName = null;
        String string = null;
        String string2 = null;
        AttributeImpl attributeImpl = null;
        Object var8_8 = null;
        int n3 = 0;
        while (n3 < n2) {
            qName = xMLStreamReader.getAttributeName(n3);
            string = qName.getPrefix();
            string2 = qName.getLocalPart();
            attributeImpl = new AttributeImpl();
            attributeImpl.setName(qName);
            attributeImpl.setAttributeType(xMLStreamReader.getAttributeType(n3));
            attributeImpl.setSpecified(xMLStreamReader.isAttributeSpecified(n3));
            attributeImpl.setValue(xMLStreamReader.getAttributeValue(n3));
            startElementEvent.addAttribute(attributeImpl);
            ++n3;
        }
    }

    protected void fillNamespaceAttributes(StartElementEvent startElementEvent, XMLStreamReader xMLStreamReader) {
        int n2 = xMLStreamReader.getNamespaceCount();
        String string = null;
        String string2 = null;
        NamespaceImpl namespaceImpl = null;
        int n3 = 0;
        while (n3 < n2) {
            string = xMLStreamReader.getNamespaceURI(n3);
            string2 = xMLStreamReader.getNamespacePrefix(n3);
            if (string2 == null) {
                string2 = "";
            }
            namespaceImpl = new NamespaceImpl(string2, string);
            startElementEvent.addNamespaceAttribute(namespaceImpl);
            ++n3;
        }
    }

    protected void fillNamespaceAttributes(EndElementEvent endElementEvent, XMLStreamReader xMLStreamReader) {
        int n2 = xMLStreamReader.getNamespaceCount();
        String string = null;
        String string2 = null;
        NamespaceImpl namespaceImpl = null;
        int n3 = 0;
        while (n3 < n2) {
            string = xMLStreamReader.getNamespaceURI(n3);
            string2 = xMLStreamReader.getNamespacePrefix(n3);
            if (string2 == null) {
                string2 = "";
            }
            namespaceImpl = new NamespaceImpl(string2, string);
            endElementEvent.addNamespace(namespaceImpl);
            ++n3;
        }
    }

    private void setNamespaceContext(StartElementEvent startElementEvent, XMLStreamReader xMLStreamReader) {
        NamespaceContextWrapper namespaceContextWrapper = (NamespaceContextWrapper)xMLStreamReader.getNamespaceContext();
        NamespaceSupport namespaceSupport = new NamespaceSupport(namespaceContextWrapper.getNamespaceContext());
        startElementEvent.setNamespaceContext(new NamespaceContextWrapper(namespaceSupport));
    }

    private QName getQName(XMLStreamReader xMLStreamReader) {
        String string = xMLStreamReader.getPrefix();
        String string2 = xMLStreamReader.getNamespaceURI();
        String string3 = xMLStreamReader.getLocalName();
        QName qName = null;
        if (string != null && string2 != null) {
            qName = new QName(string2, string3, string);
        } else if (string == null && string2 != null) {
            qName = new QName(string2, string3);
        } else if (string == null && string2 == null) {
            qName = new QName(string3);
        }
        return qName;
    }
}

