/*
 * Decompiled with CFR 0.152.
 */
package com.fr.third.JAI;

import com.fr.third.JAI.ForwardSeekableStream;
import com.fr.third.JAI.ImageCodec;
import com.fr.third.JAI.ImageDecodeParam;
import com.fr.third.JAI.ImageDecoder;
import com.fr.third.JAI.ImageEncodeParam;
import com.fr.third.JAI.ImageEncoder;
import com.fr.third.JAI.PNMEncodeParam;
import com.fr.third.JAI.PNMImageDecoder;
import com.fr.third.JAI.PNMImageEncoder;
import com.fr.third.JAI.SeekableStream;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.OutputStream;

public final class PNMCodec
extends ImageCodec {
    public String getFormatName() {
        return "pnm";
    }

    public Class getEncodeParamClass() {
        return PNMEncodeParam.class;
    }

    public Class getDecodeParamClass() {
        return Object.class;
    }

    public boolean canEncodeImage(RenderedImage renderedImage, ImageEncodeParam imageEncodeParam) {
        SampleModel sampleModel = renderedImage.getSampleModel();
        int n2 = sampleModel.getTransferType();
        if (n2 == 4 || n2 == 5) {
            return false;
        }
        int n3 = sampleModel.getNumBands();
        return n3 == 1 || n3 == 3;
    }

    protected ImageEncoder createImageEncoder(OutputStream outputStream, ImageEncodeParam imageEncodeParam) {
        PNMEncodeParam pNMEncodeParam = null;
        if (imageEncodeParam != null) {
            pNMEncodeParam = (PNMEncodeParam)imageEncodeParam;
        }
        return new PNMImageEncoder(outputStream, pNMEncodeParam);
    }

    protected ImageDecoder createImageDecoder(InputStream inputStream, ImageDecodeParam imageDecodeParam) {
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        return new PNMImageDecoder(new ForwardSeekableStream(inputStream), null);
    }

    protected ImageDecoder createImageDecoder(SeekableStream seekableStream, ImageDecodeParam imageDecodeParam) {
        return new PNMImageDecoder(seekableStream, null);
    }

    public int getNumHeaderBytes() {
        return 2;
    }

    public boolean isFormatRecognized(byte[] byArray) {
        return byArray[0] == 80 && byArray[1] >= 49 && byArray[1] <= 54;
    }
}

