/*
 * Decompiled with CFR 0.152.
 */
package com.fr.stable;

import java.io.File;
import javax.swing.UIManager;

public class OperatingSystem {
    private static final int UNIX = 201527;
    private static final int WINDOWS_9x = 1600;
    private static final int WINDOWS_NT = 1638;
    private static final int OS2 = 57005;
    private static final int MAC_OS_X = 2748;
    private static final int UNKNOWN = 2989;
    private static int os;
    private static boolean java14;
    private static boolean java15;
    private static boolean java16;
    private static boolean ibmJDK;
    private static boolean sunJDK;

    private OperatingSystem() {
    }

    public static boolean isDOSDerived() {
        return OperatingSystem.isWindows() || OperatingSystem.isOS2();
    }

    public static boolean isWindows() {
        return os == 1600 || os == 1638;
    }

    public static boolean isWindows9x() {
        return os == 1600;
    }

    public static boolean isWindowsNT() {
        return os == 1638;
    }

    public static boolean isOS2() {
        return os == 57005;
    }

    public static boolean isUnix() {
        return os == 201527 || os == 2748;
    }

    public static boolean isMacOS() {
        return os == 2748;
    }

    public static boolean isMacOSLF() {
        return OperatingSystem.isMacOS() && UIManager.getLookAndFeel().isNativeLookAndFeel();
    }

    public static boolean isJava14() {
        return java14;
    }

    public static boolean isJava15() {
        return java15;
    }

    public static boolean isJava16() {
        return java16;
    }

    public static boolean isIBMJDK() {
        return ibmJDK;
    }

    public static boolean isSunJDK() {
        return sunJDK;
    }

    static {
        String string;
        ibmJDK = false;
        sunJDK = true;
        os = System.getProperty("mrj.version") != null ? 2748 : ((string = System.getProperty("os.name")).indexOf("Windows 9") != -1 || string.indexOf("Windows M") != -1 ? 1600 : (string.indexOf("Windows") != -1 ? 1638 : (string.contains("OS X") ? 2748 : (string.indexOf("OS/2") != -1 ? 57005 : (File.separatorChar == '/' ? 201527 : 2989)))));
        string = System.getProperty("java.version").substring(0, 3);
        java14 = string.compareTo("1.4") == 0;
        java15 = string.compareTo("1.5") == 0;
        java16 = string.compareTo("1.6") == 0;
        ibmJDK = System.getProperty("java.vendor").toUpperCase().startsWith("IBM");
        sunJDK = System.getProperty("java.vendor").toUpperCase().startsWith("SUN");
    }
}

