/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.write;

import com.fr.base.ParameterMapNameSpace;
import com.fr.data.ClassSubmitJob;
import com.fr.data.SubmitJob;
import com.fr.data.SubmitJobProxyHandler;
import com.fr.data.SubmitTask;
import com.fr.data.TableDataSource;
import com.fr.general.xml.GeneralXMLTools;
import com.fr.report.report.Report;
import com.fr.report.write.AbstractSubmitVisitor;
import com.fr.report.write.MismatchException;
import com.fr.script.Calculator;
import com.fr.stable.xml.XMLPrintWriter;
import com.fr.stable.xml.XMLableReader;
import com.fr.write.DMLReport;
import com.fr.write.WClassSubmiterProvider;
import java.sql.Connection;
import java.util.Map;

public class WClassSubmiter
extends AbstractSubmitVisitor
implements WClassSubmiterProvider {
    private SubmitJob submitJob = null;
    private SubmitTask submitTask = null;
    private String dbName = null;
    private Connection connection = null;

    public void execute(Report report, TableDataSource tableDataSource, Map map) throws Exception {
        try {
            super.execute(report, tableDataSource, map);
        }
        catch (MismatchException mismatchException) {
            return;
        }
        if (this.submitTask != null) {
            Calculator calculator = Calculator.createCalculator();
            calculator.setAttribute(DMLReport.KEY, (Object)report);
            calculator.setAttribute(TableDataSource.KEY, (Object)tableDataSource);
            ParameterMapNameSpace parameterMapNameSpace = ParameterMapNameSpace.create(map);
            calculator.pushNameSpace(parameterMapNameSpace);
            this.submitTask.setConnection(this.connection);
            this.submitTask.doJob(calculator);
        }
    }

    public SubmitJob getSubmitJob() {
        return this.submitJob;
    }

    public void setSubmitJob(SubmitJob submitJob) {
        this.submitJob = submitJob;
        this.submitTask = SubmitJobProxyHandler.proxy(submitJob);
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public void readXML(XMLableReader xMLableReader) {
        super.readXML(xMLableReader);
        if (xMLableReader.isChildNode()) {
            String string = xMLableReader.getTagName();
            if ("SubmitJob".equals(string) || "SubmitTask".equals(string)) {
                this.submitJob = (SubmitJob)GeneralXMLTools.readXMLable(xMLableReader);
                this.submitTask = SubmitJobProxyHandler.proxy(this.submitJob);
            } else if ("ClassSubmitJob".equals(xMLableReader.getTagName())) {
                ClassSubmitJob classSubmitJob = new ClassSubmitJob();
                xMLableReader.readXMLObject(classSubmitJob);
                this.submitJob = classSubmitJob;
                this.submitTask = SubmitJobProxyHandler.proxy(this.submitJob);
            }
        }
    }

    public void writeXML(XMLPrintWriter xMLPrintWriter) {
        super.writeXML(xMLPrintWriter);
        if (this.submitJob != null) {
            GeneralXMLTools.writeXMLable(xMLPrintWriter, this.submitJob, "SubmitTask");
        }
    }

    public String getDBName(Calculator calculator) {
        this.dbName = this.submitTask.getDBName(calculator);
        return this.dbName;
    }
}

