/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.core;

import com.fr.report.cell.CellElement;
import com.fr.report.cell.TemplateCellElement;
import com.fr.report.cell.cellattr.CellExpandAttr;
import com.fr.report.cell.cellattr.core.group.DSColumn;
import com.fr.report.elementcase.TemplateElementCase;
import com.fr.stable.ColumnRow;
import com.fr.stable.xml.XMLReadable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class SheetUtils {
    private SheetUtils() {
    }

    private static TemplateCellElement getUpParent(TemplateElementCase templateElementCase, TemplateCellElement templateCellElement) {
        CellExpandAttr cellExpandAttr = templateCellElement.getCellExpandAttr();
        if (cellExpandAttr != null && cellExpandAttr.getUpParentColumnRow() != null) {
            return templateElementCase.getTemplateCellElement(templateCellElement.getCellExpandAttr().getUpParentColumnRow().column, templateCellElement.getCellExpandAttr().getUpParentColumnRow().row);
        }
        return null;
    }

    private static boolean isUpCycle(TemplateElementCase templateElementCase, TemplateCellElement templateCellElement) {
        boolean bl = false;
        HashSet<TemplateCellElement> hashSet = new HashSet<TemplateCellElement>();
        int n2 = 1;
        hashSet.add(templateCellElement);
        TemplateCellElement templateCellElement2 = SheetUtils.getUpParent(templateElementCase, templateCellElement);
        while (templateCellElement2 != null) {
            hashSet.add(templateCellElement2);
            if (hashSet.size() != ++n2) {
                bl = true;
                break;
            }
            templateCellElement2 = SheetUtils.getUpParent(templateElementCase, templateCellElement2);
        }
        return bl;
    }

    private static TemplateCellElement getLeftParent(TemplateElementCase templateElementCase, TemplateCellElement templateCellElement) {
        if (templateCellElement.getCellExpandAttr().getLeftParentColumnRow() != null) {
            return templateElementCase.getTemplateCellElement(templateCellElement.getCellExpandAttr().getLeftParentColumnRow().column, templateCellElement.getCellExpandAttr().getLeftParentColumnRow().row);
        }
        return null;
    }

    private static boolean isLeftCycle(TemplateElementCase templateElementCase, TemplateCellElement templateCellElement) {
        boolean bl = false;
        HashSet<TemplateCellElement> hashSet = new HashSet<TemplateCellElement>();
        int n2 = 1;
        hashSet.add(templateCellElement);
        TemplateCellElement templateCellElement2 = SheetUtils.getLeftParent(templateElementCase, templateCellElement);
        while (templateCellElement2 != null) {
            hashSet.add(templateCellElement2);
            if (hashSet.size() != ++n2) {
                bl = true;
                break;
            }
            templateCellElement2 = SheetUtils.getLeftParent(templateElementCase, templateCellElement2);
        }
        return bl;
    }

    public static void calculateDefaultParent(TemplateElementCase templateElementCase) {
        int n2;
        int n3;
        int n4;
        Cloneable cloneable;
        XMLReadable xMLReadable;
        Object object;
        int n5;
        if (templateElementCase == null) {
            return;
        }
        int n6 = templateElementCase.getColumnCount();
        int n7 = templateElementCase.getRowCount();
        CellElement[] cellElementArray = new CellElement[n6];
        CellElement[] cellElementArray2 = new CellElement[n6];
        for (n5 = 0; n5 < n7; ++n5) {
            object = templateElementCase.getRow(n5);
            while (object.hasNext()) {
                int n8;
                xMLReadable = (TemplateCellElement)object.next();
                if (xMLReadable == null) continue;
                cloneable = xMLReadable.getCellExpandAttr();
                if (cloneable == null) {
                    cloneable = new CellExpandAttr();
                    ((CellExpandAttr)cloneable).setDirection((byte)2);
                    xMLReadable.setCellExpandAttr((CellExpandAttr)cloneable);
                }
                if (((CellExpandAttr)cloneable).isUpParentDefault()) {
                    CellElement cellElement = null;
                    n4 = xMLReadable.getColumn();
                    n3 = xMLReadable.getColumnSpan();
                    for (n8 = 0; n8 < n3 && ((cellElement = cellElementArray[n8 + n4]) == null || cellElement == xMLReadable); ++n8) {
                    }
                    ((CellExpandAttr)cloneable).setUpParentColumnRow(cellElement == null || cellElement == xMLReadable ? null : ColumnRow.valueOf(cellElement.getColumn(), cellElement.getRow()));
                    if (SheetUtils.isUpCycle(templateElementCase, (TemplateCellElement)xMLReadable)) {
                        ((CellExpandAttr)cloneable).setUpParentColumnRow(null);
                        cellElementArray = cellElementArray2;
                        CellElement cellElement2 = null;
                        n2 = xMLReadable.getColumnSpan();
                        for (n3 = 0; n3 < n2 && ((cellElement2 = cellElementArray2[n3 + n4]) == null || cellElement2 == xMLReadable); ++n3) {
                        }
                        ((CellExpandAttr)cloneable).setUpParentColumnRow(cellElement2 == null || cellElement2 == xMLReadable ? null : ColumnRow.valueOf(cellElement2.getColumn(), cellElement2.getRow()));
                    }
                }
                if (!SheetUtils.isUpCycle(templateElementCase, (TemplateCellElement)xMLReadable)) {
                    n4 = xMLReadable.getColumnSpan();
                    for (int i2 = 0; i2 < n4; ++i2) {
                        cellElementArray2[i2 + xMLReadable.getColumn()] = cellElementArray[i2 + xMLReadable.getColumn()];
                    }
                }
                if (((CellExpandAttr)cloneable).getDirection() == 1) {
                    int n9 = xMLReadable.getColumn();
                    n8 = xMLReadable.getColumnSpan();
                    for (n4 = 0; n4 < n8; ++n4) {
                        if (SheetUtils.isUpCycle(templateElementCase, (TemplateCellElement)xMLReadable)) continue;
                        cellElementArray[n4 + n9] = xMLReadable;
                    }
                    continue;
                }
                if (((CellExpandAttr)cloneable).isUpParentDefault() || ((CellExpandAttr)cloneable).getUpParentColumnRow() != null) continue;
                int n10 = xMLReadable.getColumn();
                n8 = xMLReadable.getColumnSpan();
                for (n4 = 0; n4 < n8; ++n4) {
                    cellElementArray[n4 + n10] = null;
                }
            }
        }
        cellElementArray = new CellElement[n7];
        cellElementArray2 = new CellElement[n7];
        for (n5 = 0; n5 < n6; ++n5) {
            object = templateElementCase.getColumn(n5);
            while (object.hasNext()) {
                xMLReadable = (TemplateCellElement)object.next();
                if (xMLReadable == null) continue;
                cloneable = xMLReadable.getCellExpandAttr();
                if (cloneable == null) {
                    cloneable = new CellExpandAttr();
                    ((CellExpandAttr)cloneable).setDirection((byte)2);
                    xMLReadable.setCellExpandAttr((CellExpandAttr)cloneable);
                }
                if (((CellExpandAttr)cloneable).isLeftParentDefault()) {
                    CellElement cellElement = null;
                    n4 = xMLReadable.getRow();
                    n3 = xMLReadable.getRowSpan();
                    for (int i3 = 0; i3 < n3 && ((cellElement = cellElementArray[i3 + n4]) == null || cellElement == xMLReadable); ++i3) {
                    }
                    ((CellExpandAttr)cloneable).setLeftParentColumnRow(cellElement == null || cellElement == xMLReadable ? null : ColumnRow.valueOf(cellElement.getColumn(), cellElement.getRow()));
                    if (SheetUtils.isLeftCycle(templateElementCase, (TemplateCellElement)xMLReadable)) {
                        ((CellExpandAttr)cloneable).setLeftParentColumnRow(null);
                        cellElementArray = cellElementArray2;
                        CellElement cellElement3 = null;
                        n2 = xMLReadable.getRowSpan();
                        for (n3 = 0; n3 < n2 && ((cellElement3 = cellElementArray2[n3 + n4]) == null || cellElement3 == xMLReadable); ++n3) {
                        }
                        ((CellExpandAttr)cloneable).setLeftParentColumnRow(cellElement3 == null || cellElement3 == xMLReadable ? null : ColumnRow.valueOf(cellElement3.getColumn(), cellElement3.getRow()));
                    }
                }
                if (!SheetUtils.isLeftCycle(templateElementCase, (TemplateCellElement)xMLReadable)) {
                    n4 = xMLReadable.getRowSpan();
                    for (int i4 = 0; i4 < n4; ++i4) {
                        cellElementArray2[i4 + xMLReadable.getRow()] = cellElementArray[i4 + xMLReadable.getRow()];
                    }
                }
                if (((CellExpandAttr)cloneable).getDirection() == 0) {
                    int n11 = xMLReadable.getRow();
                    int n12 = xMLReadable.getRowSpan();
                    for (n4 = 0; n4 < n12; ++n4) {
                        if (SheetUtils.isLeftCycle(templateElementCase, (TemplateCellElement)xMLReadable)) continue;
                        cellElementArray[n4 + n11] = xMLReadable;
                    }
                    continue;
                }
                if (((CellExpandAttr)cloneable).isLeftParentDefault() || ((CellExpandAttr)cloneable).getLeftParentColumnRow() != null) continue;
                int n13 = xMLReadable.getRow();
                int n14 = xMLReadable.getRowSpan();
                for (n4 = 0; n4 < n14; ++n4) {
                    cellElementArray[n4 + n13] = null;
                }
            }
        }
        Iterator iterator = templateElementCase.cellIterator();
        while (iterator.hasNext()) {
            CellElement cellElement;
            Cloneable cloneable2;
            object = (TemplateCellElement)iterator.next();
            if (object == null) continue;
            xMLReadable = object.getCellExpandAttr();
            cloneable = ((CellExpandAttr)xMLReadable).getLeftParentColumnRow();
            if (cloneable != null && (cloneable2 = templateElementCase.getCellElement(((ColumnRow)cloneable).column, ((ColumnRow)cloneable).row)) != null) {
                SheetUtils.setAreaDefaultLeftParent(templateElementCase, (CellElement)cloneable2, (CellElement)object);
            }
            if ((cloneable2 = ((CellExpandAttr)xMLReadable).getUpParentColumnRow()) == null || (cellElement = templateElementCase.getCellElement(cloneable2.column, cloneable2.row)) == null) continue;
            SheetUtils.setAreaDefaultUpParent(templateElementCase, cellElement, (CellElement)object);
        }
    }

    private static void setAreaDefaultLeftParent(TemplateElementCase templateElementCase, CellElement cellElement, CellElement cellElement2) {
        int n2 = cellElement.getRow();
        int n3 = cellElement.getRow() + cellElement.getRowSpan() - 1;
        int n4 = cellElement.getColumn();
        int n5 = cellElement2.getRow();
        int n6 = cellElement2.getRow() + cellElement2.getRowSpan() - 1;
        if (n3 == n6) {
            if (n2 <= n5) {
                return;
            }
            SheetUtils.setDefaultLeftParent(ColumnRow.valueOf(n4, n2), templateElementCase, n5, n2 - 1);
        } else if (n3 < n5) {
            SheetUtils.setDefaultLeftParent(ColumnRow.valueOf(n4, n2), templateElementCase, n3 + 1, n5);
        } else if (n6 < n2) {
            SheetUtils.setDefaultLeftParent(ColumnRow.valueOf(n4, n2), templateElementCase, n6, n2 - 1);
        }
    }

    private static void setAreaDefaultUpParent(TemplateElementCase templateElementCase, CellElement cellElement, CellElement cellElement2) {
        int n2 = cellElement.getRow();
        int n3 = cellElement.getColumn();
        int n4 = cellElement.getColumn() + cellElement.getColumnSpan() - 1;
        int n5 = cellElement2.getColumn();
        int n6 = cellElement2.getColumn() + cellElement2.getColumnSpan() - 1;
        if (n4 == n6) {
            if (n3 <= n5) {
                return;
            }
            SheetUtils.setDefaultUpParent(ColumnRow.valueOf(n3, n2), templateElementCase, n5, n3 - 1);
        } else if (n4 < n5) {
            SheetUtils.setDefaultUpParent(ColumnRow.valueOf(n3, n2), templateElementCase, n4 + 1, n5);
        } else if (n6 < n3) {
            SheetUtils.setDefaultUpParent(ColumnRow.valueOf(n3, n2), templateElementCase, n6, n3 - 1);
        }
    }

    private static void setDefaultLeftParent(ColumnRow columnRow, TemplateElementCase templateElementCase, int n2, int n3) {
        Iterator iterator = templateElementCase.cellIterator();
        while (iterator.hasNext()) {
            CellExpandAttr cellExpandAttr;
            Object object;
            TemplateCellElement templateCellElement = (TemplateCellElement)iterator.next();
            int n4 = templateCellElement.getRow();
            if (n4 < n2 || n4 > n3 || (object = templateCellElement.getValue()) instanceof DSColumn || !(cellExpandAttr = templateCellElement.getCellExpandAttr()).isLeftParentDefault() || cellExpandAttr.getLeftParentColumnRow() != null || SheetUtils.willLeadToDeathCircle(templateElementCase, columnRow, ColumnRow.valueOf(templateCellElement.getColumn(), templateCellElement.getRow()), new HashSet())) continue;
            cellExpandAttr.setLeftParentColumnRow(columnRow);
        }
    }

    private static void setDefaultUpParent(ColumnRow columnRow, TemplateElementCase templateElementCase, int n2, int n3) {
        Iterator iterator = templateElementCase.cellIterator();
        while (iterator.hasNext()) {
            CellExpandAttr cellExpandAttr;
            Object object;
            TemplateCellElement templateCellElement = (TemplateCellElement)iterator.next();
            int n4 = templateCellElement.getColumn();
            if (n4 < n2 || n4 > n3 || (object = templateCellElement.getValue()) instanceof DSColumn || !(cellExpandAttr = templateCellElement.getCellExpandAttr()).isUpParentDefault() || cellExpandAttr.getUpParentColumnRow() != null || SheetUtils.willLeadToDeathCircle(templateElementCase, columnRow, ColumnRow.valueOf(templateCellElement.getColumn(), templateCellElement.getRow()), new HashSet())) continue;
            cellExpandAttr.setUpParentColumnRow(columnRow);
        }
    }

    private static boolean willLeadToDeathCircle(TemplateElementCase templateElementCase, ColumnRow columnRow, ColumnRow columnRow2, Set set) {
        if (columnRow == null || columnRow2 == null) {
            return false;
        }
        TemplateCellElement templateCellElement = templateElementCase.getTemplateCellElement(columnRow.column, columnRow.row);
        if (templateCellElement == null) {
            return false;
        }
        if (templateCellElement.getCellExpandAttr() != null) {
            CellExpandAttr cellExpandAttr = templateCellElement.getCellExpandAttr();
            ColumnRow columnRow3 = cellExpandAttr.getLeftParentColumnRow();
            ColumnRow columnRow4 = cellExpandAttr.getUpParentColumnRow();
            if (set.contains(columnRow3) || set.contains(columnRow4)) {
                return true;
            }
            if (columnRow2.equals(cellExpandAttr.getLeftParentColumnRow()) || columnRow2.equals(cellExpandAttr.getUpParentColumnRow())) {
                return true;
            }
            if (columnRow3 != null) {
                set.add(columnRow3);
            }
            if (columnRow4 != null) {
                set.add(columnRow4);
            }
            return SheetUtils.willLeadToDeathCircle(templateElementCase, cellExpandAttr.getLeftParentColumnRow(), columnRow2, set) && SheetUtils.willLeadToDeathCircle(templateElementCase, cellExpandAttr.getUpParentColumnRow(), columnRow2, set);
        }
        return false;
    }
}

