/*
 * Decompiled with CFR 0.152.
 */
package com.fr.report.cell.painter.barcode.qrcode;

import com.fr.base.FRContext;
import com.fr.report.cell.painter.barcode.BarcodeException;
import com.fr.report.cell.painter.barcode.BarcodeImpl;
import com.fr.report.cell.painter.barcode.Module;
import com.fr.report.cell.painter.barcode.output.AbstractOutput;
import com.fr.report.cell.painter.barcode.output.GraphicsOutput;
import com.fr.report.cell.painter.barcode.qrcode.QRCode;
import com.fr.stable.ArrayUtils;
import com.fr.stable.pinyin.ChineseHelper;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.io.UnsupportedEncodingException;

public class QRcodeBarcode
extends BarcodeImpl {
    private byte[] ori_data = null;
    private boolean[][] paintRect = null;
    private QRCode qrcode = new QRCode();

    public QRcodeBarcode(String string) throws BarcodeException {
        super(string);
        this.qrcode.setQrcodeErrorCorrect('M');
        this.qrcode.setQrcodeEncodeMode('B');
        this.qrcode.setQrcodeVersion(7);
        try {
            this.ori_data = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            FRContext.getLogger().error(unsupportedEncodingException.getMessage(), unsupportedEncodingException);
        }
    }

    private int QRCodeversiontoint(int n2) {
        if (n2 != 0) {
            return n2;
        }
        int n3 = ChineseHelper.containChinese(this.data.toString()) ? 2 : 1;
        return this.Getlen(n2) * n3;
    }

    private int Getlen(int n2) {
        return this.data.length() / this.ErrorCorrecttoint(this.getRCodeErrorCorrect()) + 1;
    }

    private int ErrorCorrecttoint(int n2) {
        return 16 - n2 * 3;
    }

    private char ErrorCorrecttochar(int n2) {
        switch (n2) {
            case 0: {
                return 'L';
            }
            case 1: {
                return 'M';
            }
            case 2: {
                return 'Q';
            }
            case 3: {
                return 'H';
            }
        }
        return 'M';
    }

    public void draw(Graphics2D graphics2D, int n2, int n3) {
        graphics2D.setBackground(Color.WHITE);
        graphics2D.setColor(Color.BLACK);
        int n4 = this.getRcodeDrawPix();
        if (!ArrayUtils.isEmpty(this.ori_data)) {
            boolean[][] blArray = this.getPaintRect();
            for (int i2 = 0; i2 < blArray.length; ++i2) {
                for (int i3 = 0; i3 < blArray.length; ++i3) {
                    if (!blArray[i3][i2]) continue;
                    graphics2D.fillRect(n2 + i3 * n4, n3 + i2 * n4, n4, n4);
                }
            }
        }
    }

    private void initQRCodeAttr() {
        char c2 = this.ErrorCorrecttochar(this.getRCodeErrorCorrect());
        this.qrcode.setQrcodeErrorCorrect(c2);
        int n2 = this.QRCodeversiontoint(this.getRCodeVersion());
        this.qrcode.setQrcodeVersion(n2);
    }

    private boolean[][] getPaintRect() {
        if (this.paintRect == null) {
            this.initQRCodeAttr();
            this.paintRect = this.qrcode.calQrcode(this.ori_data);
        }
        return this.paintRect;
    }

    public int getWidth() {
        return this.getPaintRect().length * this.getRcodeDrawPix();
    }

    public int getHeight() {
        return this.getPaintRect().length * this.getRcodeDrawPix();
    }

    protected Module calculateChecksum() {
        return null;
    }

    protected Module[] encodeData() {
        return null;
    }

    protected double getBarcodeWidth(int n2) {
        return 0.0;
    }

    protected Module getPostAmble() {
        return null;
    }

    protected Module getPreAmble() {
        return null;
    }

    protected Dimension draw(GraphicsOutput graphicsOutput, int n2, int n3, double d2, double d3) {
        return null;
    }

    protected Dimension draw(AbstractOutput abstractOutput, int n2, int n3, double d2, double d3) {
        return null;
    }
}

