/*
 * Decompiled with CFR 0.152.
 */
package com.fr.privilege.filter.core;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class RSAUtils {
    public static KeyPair generateKeyPair(int n2) throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", (Provider)new BouncyCastleProvider());
        keyPairGenerator.initialize(n2, new SecureRandom());
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        return keyPair;
    }

    public static RSAPublicKey generateRSAPublicKey(BigInteger bigInteger, BigInteger bigInteger2) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance("RSA", (Provider)new BouncyCastleProvider());
        RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(bigInteger, bigInteger2);
        return (RSAPublicKey)keyFactory.generatePublic(rSAPublicKeySpec);
    }

    public static RSAPrivateKey generateRSAPrivateKey(BigInteger bigInteger, BigInteger bigInteger2) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance("RSA", (Provider)new BouncyCastleProvider());
        RSAPrivateKeySpec rSAPrivateKeySpec = new RSAPrivateKeySpec(bigInteger, bigInteger2);
        return (RSAPrivateKey)keyFactory.generatePrivate(rSAPrivateKeySpec);
    }

    public static byte[] sign(byte[] byArray, PrivateKey privateKey) throws Exception {
        Signature signature = Signature.getInstance("MD5withRSA", (Provider)new BouncyCastleProvider());
        signature.initSign(privateKey, new SecureRandom());
        signature.update(byArray);
        return signature.sign();
    }

    public static boolean verify(byte[] byArray, byte[] byArray2, PublicKey publicKey) throws Exception {
        Signature signature = Signature.getInstance("MD5withRSA", (Provider)new BouncyCastleProvider());
        signature.initVerify(publicKey);
        signature.update(byArray);
        return signature.verify(byArray2);
    }

    public static String toHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            String string = Integer.toHexString(byArray[i2] & 0xFF);
            if (string.length() == 1) {
                string = '0' + string;
            }
            stringBuffer.append(string.toUpperCase());
        }
        return stringBuffer.toString();
    }

    public static byte[] hexStringToBytes(String string) {
        if (string == null || string.equals("")) {
            return null;
        }
        string = string.toUpperCase();
        int n2 = string.length() / 2;
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = i2 * 2;
            byArray[i2] = (byte)(RSAUtils.charToByte(cArray[n3]) << 4 | RSAUtils.charToByte(cArray[n3 + 1]));
        }
        return byArray;
    }

    private static byte charToByte(char c2) {
        return (byte)"0123456789ABCDEF".indexOf(c2);
    }

    public static void main(String[] stringArray) throws Exception {
        byte[] byArray = new byte[2];
        for (int i2 = 0; i2 < 256; ++i2) {
            for (int i3 = 0; i3 < 256; ++i3) {
                boolean bl;
                byArray[0] = (byte)i2;
                byArray[1] = (byte)i3;
                String string = RSAUtils.toHexString(byArray);
                byte[] byArray2 = RSAUtils.hexStringToBytes(string);
                boolean bl2 = bl = byArray[0] == byArray2[0] && byArray[1] == byArray2[1] && byArray2.length == 2;
                if (!bl) {
                    System.out.println(string + byArray[0] + ":" + byArray[1] + bl);
                    System.exit(0);
                }
                System.out.println(string + byArray[0] + ":" + byArray[1] + bl);
            }
        }
        System.out.println("***************");
    }
}

